/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, MediumTests.class})
public class TestBufferedDataBlockEncoder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBufferedDataBlockEncoder.class);
    byte[] row1 = Bytes.toBytes((String)"row1");
    byte[] row2 = Bytes.toBytes((String)"row2");
    byte[] row_1_0 = Bytes.toBytes((String)"row10");
    byte[] fam1 = Bytes.toBytes((String)"fam1");
    byte[] fam2 = Bytes.toBytes((String)"fam2");
    byte[] fam_1_2 = Bytes.toBytes((String)"fam12");
    byte[] qual1 = Bytes.toBytes((String)"qual1");
    byte[] qual2 = Bytes.toBytes((String)"qual2");
    byte[] val = Bytes.toBytes((String)"val");

    @Test
    public void testEnsureSpaceForKey() {
        BufferedDataBlockEncoder.SeekerState state = new BufferedDataBlockEncoder.SeekerState(new ObjectIntPair(), false);
        for (int i = 1; i <= 65536; ++i) {
            state.keyLength = i;
            state.ensureSpaceForKey();
            state.keyBuffer[state.keyLength - 1] = (byte)((i - 1) % 255);
            for (int j = 0; j < i - 1; ++j) {
                Assert.assertEquals((long)((byte)(j % 255)), (long)state.keyBuffer[j]);
            }
        }
    }

    @Test
    public void testCommonPrefixComparators() {
        KeyValue kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        KeyValue kv2 = new KeyValue(this.row1, this.fam_1_2, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((BufferedDataBlockEncoder.compareCommonFamilyPrefix((Cell)kv1, (Cell)kv2, (int)4) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row_1_0, this.fam_1_2, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((BufferedDataBlockEncoder.compareCommonRowPrefix((Cell)kv1, (Cell)kv2, (int)4) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual2, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((BufferedDataBlockEncoder.compareCommonQualifierPrefix((Cell)kv1, (Cell)kv2, (int)4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testKVCodecWithTagsForDecodedCellsWithNoTags() throws Exception {
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"1"), Long.MAX_VALUE, Bytes.toBytes((String)"1"));
        BufferedDataBlockEncoder.OnheapDecodedCell c1 = new BufferedDataBlockEncoder.OnheapDecodedCell(kv1.getKey(), kv1.getRowLength(), kv1.getFamilyOffset() - 8, kv1.getFamilyLength(), kv1.getQualifierOffset() - 8, kv1.getQualifierLength(), kv1.getTimestamp(), kv1.getTypeByte(), kv1.getValueArray(), kv1.getValueOffset(), kv1.getValueLength(), kv1.getSequenceId(), kv1.getTagsArray(), kv1.getTagsOffset(), kv1.getTagsLength());
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"r2"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"2"), Long.MAX_VALUE, Bytes.toBytes((String)"2"));
        BufferedDataBlockEncoder.OnheapDecodedCell c2 = new BufferedDataBlockEncoder.OnheapDecodedCell(kv2.getKey(), kv2.getRowLength(), kv2.getFamilyOffset() - 8, kv2.getFamilyLength(), kv2.getQualifierOffset() - 8, kv2.getQualifierLength(), kv2.getTimestamp(), kv2.getTypeByte(), kv2.getValueArray(), kv2.getValueOffset(), kv2.getValueLength(), kv2.getSequenceId(), kv2.getTagsArray(), kv2.getTagsOffset(), kv2.getTagsLength());
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"r3"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qual"), Long.MAX_VALUE, Bytes.toBytes((String)"3"));
        BufferedDataBlockEncoder.OffheapDecodedExtendedCell c3 = new BufferedDataBlockEncoder.OffheapDecodedExtendedCell(ByteBuffer.wrap(kv2.getKey()), kv2.getRowLength(), kv2.getFamilyOffset() - 8, kv2.getFamilyLength(), kv2.getQualifierOffset() - 8, kv2.getQualifierLength(), kv2.getTimestamp(), kv2.getTypeByte(), ByteBuffer.wrap(kv2.getValueArray()), kv2.getValueOffset(), kv2.getValueLength(), kv2.getSequenceId(), ByteBuffer.wrap(kv2.getTagsArray()), kv2.getTagsOffset(), kv2.getTagsLength());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        KeyValueCodecWithTags codec = new KeyValueCodecWithTags();
        Codec.Encoder encoder = codec.getEncoder((OutputStream)os);
        encoder.write((Cell)c1);
        encoder.write((Cell)c2);
        encoder.write((Cell)c3);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        Codec.Decoder decoder = codec.getDecoder((InputStream)is);
        Assert.assertTrue((boolean)decoder.advance());
        Assert.assertTrue((boolean)CellUtil.equals((Cell)c1, (Cell)decoder.current()));
        Assert.assertTrue((boolean)decoder.advance());
        Assert.assertTrue((boolean)CellUtil.equals((Cell)c2, (Cell)decoder.current()));
        Assert.assertTrue((boolean)decoder.advance());
        Assert.assertTrue((boolean)CellUtil.equals((Cell)c3, (Cell)decoder.current()));
        Assert.assertFalse((boolean)decoder.advance());
    }
}

