/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MetaWithReplicasTestBase;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaWithReplicasBasic
extends MetaWithReplicasTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaWithReplicasBasic.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestMetaWithReplicasBasic.startCluster();
    }

    @Test
    public void testMetaHTDReplicaCount() throws Exception {
        Assert.assertEquals((long)3L, (long)TEST_UTIL.getAdmin().getDescriptor(TableName.META_TABLE_NAME).getRegionReplication());
    }

    @Test
    public void testZookeeperNodesForReplicas() throws Exception {
        ZKWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        Configuration conf = TEST_UTIL.getConfiguration();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ProtobufUtil.parseServerNameFrom((byte[])data);
        for (int i = 1; i < 3; ++i) {
            String secZnode = ZNodePaths.joinZNode((String)baseZNode, (String)(conf.get("zookeeper.znode.metaserver", "meta-region-server") + "-" + i));
            String str = zkw.getZNodePaths().getZNodeForReplica(i);
            Assert.assertTrue((boolean)str.equals(secZnode));
            data = ZKUtil.getData((ZKWatcher)zkw, (String)secZnode);
            ProtobufUtil.parseServerNameFrom((byte[])data);
        }
    }

    @Test
    public void testAccessingUnknownTables() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean("hbase.meta.replicas.use", true);
        Table table = TEST_UTIL.getConnection().getTable(this.name.getTableName());
        Get get = new Get(Bytes.toBytes((String)"foo"));
        Assert.assertThrows(TableNotFoundException.class, () -> table.get(get));
    }
}

