/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.CustomOutputCommitter;
import org.apache.hadoop.FailMapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.TestMRJobs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMROldApiJobs {
    private static final Log LOG = LogFactory.getLog(TestMROldApiJobs.class);
    protected static MiniMRYarnCluster mrCluster;
    private static Configuration conf;
    private static FileSystem localFs;

    @BeforeClass
    public static void setup() throws IOException {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(TestMROldApiJobs.class.getName());
            mrCluster.init(new Configuration());
            mrCluster.start();
        }
        mrCluster.getConfig().setBoolean("mapreduce.job.ubertask.enable", false);
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), TestMRJobs.APP_JAR);
        localFs.setPermission(TestMRJobs.APP_JAR, new FsPermission("700"));
    }

    @AfterClass
    public static void tearDown() {
        if (mrCluster != null) {
            mrCluster.stop();
            mrCluster = null;
        }
    }

    @Test
    public void testJobSucceed() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testJobSucceed().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        JobConf conf = new JobConf(mrCluster.getConfig());
        Path in = new Path(mrCluster.getTestWorkDir().getAbsolutePath(), "in");
        Path out = new Path(mrCluster.getTestWorkDir().getAbsolutePath(), "out");
        TestMROldApiJobs.runJobSucceed(conf, in, out);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(new Path(out, "_job_setup")));
        Assert.assertFalse((boolean)fs.exists(new Path(out, "_job_abort")));
        Assert.assertTrue((boolean)fs.exists(new Path(out, "_job_commit")));
        Assert.assertTrue((boolean)fs.exists(new Path(out, "_task_setup")));
        Assert.assertFalse((boolean)fs.exists(new Path(out, "_task_abort")));
        Assert.assertTrue((boolean)fs.exists(new Path(out, "_task_commit")));
    }

    @Test
    public void testJobFail() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testJobFail().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        JobConf conf = new JobConf(mrCluster.getConfig());
        Path in = new Path(mrCluster.getTestWorkDir().getAbsolutePath(), "fail-in");
        Path out = new Path(mrCluster.getTestWorkDir().getAbsolutePath(), "fail-out");
        TestMROldApiJobs.runJobFail(conf, in, out);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((boolean)fs.exists(new Path(out, "_job_setup")));
        Assert.assertTrue((boolean)fs.exists(new Path(out, "_job_abort")));
        Assert.assertFalse((boolean)fs.exists(new Path(out, "_job_commit")));
        Assert.assertTrue((boolean)fs.exists(new Path(out, "_task_setup")));
        Assert.assertTrue((boolean)fs.exists(new Path(out, "_task_abort")));
        Assert.assertFalse((boolean)fs.exists(new Path(out, "_task_commit")));
    }

    public static void runJobFail(JobConf conf, Path inDir, Path outDir) throws IOException, InterruptedException {
        conf.setJobName("test-job-fail");
        conf.setMapperClass(FailMapper.class);
        conf.setJarByClass(FailMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setMaxMapAttempts(1);
        boolean success = TestMROldApiJobs.runJob(conf, inDir, outDir, 1, 0);
        Assert.assertFalse((String)"Job expected to fail succeeded", (boolean)success);
    }

    public static void runJobSucceed(JobConf conf, Path inDir, Path outDir) throws IOException, InterruptedException {
        conf.setJobName("test-job-succeed");
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        boolean success = TestMROldApiJobs.runJob(conf, inDir, outDir, 1, 1);
        Assert.assertTrue((String)"Job expected to succeed failed", (boolean)success);
    }

    static boolean runJob(JobConf conf, Path inDir, Path outDir, int numMaps, int numReds) throws IOException, InterruptedException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(outDir)) {
            fs.delete(outDir, true);
        }
        if (!fs.exists(inDir)) {
            fs.mkdirs(inDir);
        }
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        for (int i = 0; i < numMaps; ++i) {
            FSDataOutputStream file = fs.create(new Path(inDir, "part-" + i));
            file.writeBytes(input);
            file.close();
        }
        DistributedCache.addFileToClassPath((Path)TestMRJobs.APP_JAR, (Configuration)conf, (FileSystem)fs);
        conf.setOutputCommitter(CustomOutputCommitter.class);
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReds);
        JobClient jobClient = new JobClient(conf);
        RunningJob job = jobClient.submitJob(conf);
        return jobClient.monitorAndPrintJob(conf, job);
    }

    static {
        conf = new Configuration();
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
    }
}

