/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.subapplication;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTable;

public enum SubApplicationColumn implements Column<SubApplicationTable>
{
    ID(SubApplicationColumnFamily.INFO, "id"),
    TYPE(SubApplicationColumnFamily.INFO, "type"),
    CREATED_TIME(SubApplicationColumnFamily.INFO, "created_time", new LongConverter()),
    FLOW_VERSION(SubApplicationColumnFamily.INFO, "flow_version");

    private final ColumnFamily<SubApplicationTable> columnFamily;
    private final String columnQualifier;
    private final byte[] columnQualifierBytes;
    private final ValueConverter valueConverter;

    private SubApplicationColumn(ColumnFamily<SubApplicationTable> columnFamily, String columnQualifier) {
        this(columnFamily, columnQualifier, GenericConverter.getInstance());
    }

    private SubApplicationColumn(ColumnFamily<SubApplicationTable> columnFamily, String columnQualifier, ValueConverter converter) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.columnQualifierBytes = Bytes.toBytes((String)Separator.SPACE.encode(columnQualifier));
        this.valueConverter = converter;
    }

    @Override
    public byte[] getColumnQualifierBytes() {
        return (byte[])this.columnQualifierBytes.clone();
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public Attribute[] getCombinedAttrsWithAggr(Attribute ... attributes) {
        return attributes;
    }

    @Override
    public boolean supplementCellTimestamp() {
        return false;
    }
}

