/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewFileSystemLinkFallback
extends ViewFileSystemBaseTest {
    private static FileSystem fsDefault;
    private static MiniDFSCluster cluster;
    private static final int NAME_SPACES_COUNT = 3;
    private static final int DATA_NODES_COUNT = 3;
    private static final int FS_INDEX_DEFAULT = 0;
    private static final String LINK_FALLBACK_CLUSTER_1_NAME = "Cluster1";
    private static final FileSystem[] FS_HDFS;
    private static final Configuration CONF;
    private static final File TEST_DIR;
    private static final String TEST_BASE_PATH = "/tmp/TestViewFileSystemLinkFallback";
    private static final Logger LOG;

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper(TEST_BASE_PATH);
    }

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException, LoginException, URISyntaxException {
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(CONF).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).numDataNodes(3).build();
        cluster.waitClusterUp();
        for (int i = 0; i < 3; ++i) {
            TestViewFileSystemLinkFallback.FS_HDFS[i] = cluster.getFileSystem(i);
        }
        fsDefault = FS_HDFS[0];
    }

    @AfterClass
    public static void clusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fsDefault;
        super.setUp();
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fsDefault.makeQualified(new Path("/"));
        for (FileStatus status : fsDefault.listStatus(this.targetTestRoot)) {
            fsDefault.delete(status.getPath(), true);
        }
    }

    void setupMountPoints() {
        super.setupMountPoints();
        ConfigUtil.addLinkFallback((Configuration)this.conf, (String)LINK_FALLBACK_CLUSTER_1_NAME, (URI)this.targetTestRoot.toUri());
    }

    int getExpectedDelegationTokenCount() {
        return 1;
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 1;
    }

    @Test
    public void testConfLinkFallback() throws Exception {
        Path testBasePath = new Path(TEST_BASE_PATH);
        Path testLevel2Dir = new Path(TEST_BASE_PATH, "dir1/dirA");
        Path testBaseFile = new Path(testBasePath, "testBaseFile.log");
        Path testBaseFileRelative = new Path(testLevel2Dir, "../../testBaseFile.log");
        Path testLevel2File = new Path(testLevel2Dir, "testLevel2File.log");
        this.fsTarget.mkdirs(testLevel2Dir);
        this.fsTarget.createNewFile(testBaseFile);
        FSDataOutputStream dataOutputStream = this.fsTarget.append(testBaseFile);
        dataOutputStream.write(1);
        dataOutputStream.close();
        this.fsTarget.createNewFile(testLevel2File);
        dataOutputStream = this.fsTarget.append(testLevel2File);
        dataOutputStream.write("test link fallback".toString().getBytes());
        dataOutputStream.close();
        String clusterName = "ClusterFallback";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        Configuration conf = new Configuration();
        ConfigUtil.addLinkFallback((Configuration)conf, (String)clusterName, (URI)this.fsTarget.getUri());
        FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)conf);
        Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
        FileStatus baseFileStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testBaseFile.toUri().toString()));
        LOG.info("BaseFileStat: " + baseFileStat);
        FileStatus baseFileRelStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testBaseFileRelative.toUri().toString()));
        LOG.info("BaseFileRelStat: " + baseFileRelStat);
        Assert.assertEquals((String)("Unexpected file length for " + testBaseFile), (long)1L, (long)baseFileStat.getLen());
        Assert.assertEquals((String)("Unexpected file length for " + testBaseFileRelative), (long)baseFileStat.getLen(), (long)baseFileRelStat.getLen());
        FileStatus level2FileStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testLevel2File.toUri().toString()));
        LOG.info("Level2FileStat: " + level2FileStat);
        vfs.close();
    }

    @Test
    public void testConfLinkFallbackWithRegularLinks() throws Exception {
        Path testBasePath = new Path(TEST_BASE_PATH);
        Path testLevel2Dir = new Path(TEST_BASE_PATH, "dir1/dirA");
        Path testBaseFile = new Path(testBasePath, "testBaseFile.log");
        Path testLevel2File = new Path(testLevel2Dir, "testLevel2File.log");
        this.fsTarget.mkdirs(testLevel2Dir);
        this.fsTarget.createNewFile(testBaseFile);
        this.fsTarget.createNewFile(testLevel2File);
        FSDataOutputStream dataOutputStream = this.fsTarget.append(testLevel2File);
        dataOutputStream.write("test link fallback".toString().getBytes());
        dataOutputStream.close();
        String clusterName = "ClusterFallback";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/internalDir/linkToDir2", (URI)new Path(this.targetTestRoot, "dir2").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/internalDir/internalDirB/linkToDir3", (URI)new Path(this.targetTestRoot, "dir3").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/danglingLink", (URI)new Path(this.targetTestRoot, "missingTarget").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/linkToAFile", (URI)new Path(this.targetTestRoot, "aFile").toUri());
        System.out.println("ViewFs link fallback " + this.fsTarget.getUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (String)clusterName, (URI)this.targetTestRoot.toUri());
        FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)conf);
        Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
        FileStatus baseFileStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testBaseFile.toUri().toString()));
        LOG.info("BaseFileStat: " + baseFileStat);
        Assert.assertEquals((String)("Unexpected file length for " + testBaseFile), (long)0L, (long)baseFileStat.getLen());
        FileStatus level2FileStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testLevel2File.toUri().toString()));
        LOG.info("Level2FileStat: " + level2FileStat);
        dataOutputStream = vfs.append(testLevel2File);
        dataOutputStream.write("Writing via viewfs fallback path".getBytes());
        dataOutputStream.close();
        FileStatus level2FileStatAfterWrite = vfs.getFileStatus(new Path(viewFsUri.toString() + testLevel2File.toUri().toString()));
        Assert.assertTrue((String)("Unexpected file length for " + testLevel2File), (level2FileStatAfterWrite.getLen() > level2FileStat.getLen() ? 1 : 0) != 0);
        vfs.close();
    }

    @Test
    public void testConfLinkFallbackWithMountPoint() throws Exception {
        TEST_DIR.mkdirs();
        Configuration conf = new Configuration();
        String clusterName = "ClusterX";
        String mountPoint = "/user";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        String expectedErrorMsg = "Invalid linkFallback entry in config: linkFallback./user";
        String mountTableEntry = "fs.viewfs.mounttable." + clusterName + "." + "linkFallback" + "." + mountPoint;
        conf.set(mountTableEntry, TEST_DIR.toURI().toString());
        try {
            FileSystem.get((URI)viewFsUri, (Configuration)conf);
            Assert.fail((String)"Shouldn't allow linkMergeSlash to take extra mount points!");
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Unexpected error: " + e.getMessage()), (boolean)e.getMessage().contains(expectedErrorMsg));
        }
    }

    static {
        FS_HDFS = new FileSystem[3];
        CONF = new Configuration();
        TEST_DIR = GenericTestUtils.getTestDir((String)TestViewFileSystemLinkFallback.class.getSimpleName());
        LOG = LoggerFactory.getLogger(TestViewFileSystemLinkFallback.class);
    }
}

