/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaManager;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUpdateService;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRouterQuota {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.NamenodeContext nnContext1;
    private static MiniRouterDFSCluster.NamenodeContext nnContext2;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MountTableResolver resolver;
    private static final int BLOCK_SIZE = 512;

    @Before
    public void setUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().quota().rpc().build();
        routerConf.set("dfs.federation.router.quota-cache.update.interval", "2s");
        Configuration hdfsConf = new Configuration(false);
        hdfsConf.setInt("dfs.blocksize", 512);
        hdfsConf.setInt("dfs.replication", 1);
        cluster.addRouterOverrides(routerConf);
        cluster.addNamenodeOverrides(hdfsConf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        nnContext1 = cluster.getNamenode(cluster.getNameservices().get(0), null);
        nnContext2 = cluster.getNamenode(cluster.getNameservices().get(1), null);
        routerContext = cluster.getRandomRouter();
        Router router = routerContext.getRouter();
        resolver = (MountTableResolver)router.getSubclusterResolver();
    }

    @After
    public void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testNamespaceQuotaExceed() throws Exception {
        long nsQuota = 3L;
        FileSystem nnFs1 = nnContext1.getFileSystem();
        FileSystem nnFs2 = nnContext2.getFileSystem();
        nnFs1.mkdirs(new Path("/testdir1"));
        nnFs2.mkdirs(new Path("/testdir2"));
        MountTable mountTable1 = MountTable.newInstance((String)"/nsquota", Collections.singletonMap("ns0", "/testdir1"));
        mountTable1.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).build());
        this.addMountTable(mountTable1);
        MountTable mountTable2 = MountTable.newInstance((String)"/nsquota/subdir", Collections.singletonMap("ns1", "/testdir2"));
        mountTable2.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).build());
        this.addMountTable(mountTable2);
        final FileSystem routerFs = routerContext.getFileSystem();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                boolean isNsQuotaViolated = false;
                try {
                    routerFs.mkdirs(new Path("/nsquota/" + UUID.randomUUID()));
                    routerFs.mkdirs(new Path("/nsquota/subdir/" + UUID.randomUUID()));
                }
                catch (NSQuotaExceededException e) {
                    isNsQuotaViolated = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return isNsQuotaViolated;
            }
        }, (int)5000, (int)60000);
        nnFs1.mkdirs(new Path("/testdir1/" + UUID.randomUUID()));
        nnFs2.mkdirs(new Path("/testdir2/" + UUID.randomUUID()));
        routerFs.delete(new Path("/nsquota"), true);
        routerFs.rename(new Path("/nsquota/subdir"), new Path("/nsquota/subdir"));
    }

    @Test
    public void testStorageSpaceQuotaaExceed() throws Exception {
        long ssQuota = 3071L;
        FileSystem nnFs1 = nnContext1.getFileSystem();
        FileSystem nnFs2 = nnContext2.getFileSystem();
        nnFs1.mkdirs(new Path("/testdir3"));
        nnFs2.mkdirs(new Path("/testdir4"));
        MountTable mountTable1 = MountTable.newInstance((String)"/ssquota", Collections.singletonMap("ns0", "/testdir3"));
        mountTable1.setQuota(new RouterQuotaUsage.Builder().spaceQuota(ssQuota).build());
        this.addMountTable(mountTable1);
        MountTable mountTable2 = MountTable.newInstance((String)"/ssquota/subdir", Collections.singletonMap("ns1", "/testdir4"));
        mountTable2.setQuota(new RouterQuotaUsage.Builder().spaceQuota(ssQuota).build());
        this.addMountTable(mountTable2);
        final DFSClient routerClient = routerContext.getClient();
        routerClient.create("/ssquota/file", true).close();
        routerClient.create("/ssquota/subdir/file", true).close();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                boolean isDsQuotaViolated = false;
                try {
                    TestRouterQuota.this.appendData("/ssquota/file", routerClient, 512);
                    TestRouterQuota.this.appendData("/ssquota/subdir/file", routerClient, 512);
                }
                catch (DSQuotaExceededException e) {
                    isDsQuotaViolated = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return isDsQuotaViolated;
            }
        }, (int)5000, (int)60000);
        this.appendData("/testdir3/file", nnContext1.getClient(), 512);
        this.appendData("/testdir4/file", nnContext2.getClient(), 512);
    }

    private boolean addMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)entry);
        AddMountTableEntryResponse addResponse = mountTableManager.addMountTableEntry(addRequest);
        resolver.loadCache(true);
        return addResponse.getStatus();
    }

    private void appendData(String path, DFSClient client, int dataLen) throws IOException {
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.APPEND);
        HdfsDataOutputStream stream = client.append(path, 1024, createFlag, null, null);
        byte[] data = new byte[dataLen];
        stream.write(data);
        stream.close();
    }

    @Test
    public void testSetQuota() throws Exception {
        long nsQuota = 5L;
        long ssQuota = 100L;
        FileSystem nnFs1 = nnContext1.getFileSystem();
        FileSystem nnFs2 = nnContext2.getFileSystem();
        nnFs1.mkdirs(new Path("/testdir5"));
        nnFs2.mkdirs(new Path("/testdir6"));
        MountTable mountTable1 = MountTable.newInstance((String)"/setquota", Collections.singletonMap("ns0", "/testdir5"));
        mountTable1.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        this.addMountTable(mountTable1);
        MountTable mountTable2 = MountTable.newInstance((String)"/setquota/subdir", Collections.singletonMap("ns1", "/testdir6"));
        this.addMountTable(mountTable2);
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        ClientProtocol client1 = nnContext1.getClient().getNamenode();
        ClientProtocol client2 = nnContext2.getClient().getNamenode();
        QuotaUsage quota1 = client1.getQuotaUsage("/testdir5");
        QuotaUsage quota2 = client2.getQuotaUsage("/testdir6");
        Assert.assertEquals((long)nsQuota, (long)quota1.getQuota());
        Assert.assertEquals((long)ssQuota, (long)quota1.getSpaceQuota());
        Assert.assertEquals((long)nsQuota, (long)quota2.getQuota());
        Assert.assertEquals((long)ssQuota, (long)quota2.getSpaceQuota());
    }

    @Test
    public void testGetQuota() throws Exception {
        long nsQuota = 10L;
        long ssQuota = 100L;
        FileSystem nnFs1 = nnContext1.getFileSystem();
        FileSystem nnFs2 = nnContext2.getFileSystem();
        nnFs1.mkdirs(new Path("/testdir7"));
        nnFs1.mkdirs(new Path("/testdir7/subdir"));
        nnFs2.mkdirs(new Path("/testdir8"));
        MountTable mountTable1 = MountTable.newInstance((String)"/getquota", Collections.singletonMap("ns0", "/testdir7"));
        mountTable1.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        this.addMountTable(mountTable1);
        MountTable mountTable2 = MountTable.newInstance((String)"/getquota/subdir1", Collections.singletonMap("ns0", "/testdir7/subdir"));
        this.addMountTable(mountTable2);
        MountTable mountTable3 = MountTable.newInstance((String)"/getquota/subdir2", Collections.singletonMap("ns1", "/testdir8"));
        this.addMountTable(mountTable3);
        DFSClient routerClient = routerContext.getClient();
        routerClient.create("/getquota/file", true).close();
        routerClient.create("/getquota/subdir1/file", true).close();
        routerClient.create("/getquota/subdir2/file", true).close();
        ClientProtocol clientProtocol = routerContext.getClient().getNamenode();
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        QuotaUsage quota = clientProtocol.getQuotaUsage("/getquota");
        Assert.assertEquals((long)6L, (long)quota.getFileAndDirectoryCount());
    }

    @Test
    public void testStaleQuotaRemoving() throws Exception {
        long nsQuota = 20L;
        long ssQuota = 200L;
        String stalePath = "/stalequota";
        FileSystem nnFs1 = nnContext1.getFileSystem();
        nnFs1.mkdirs(new Path("/testdir9"));
        MountTable mountTable = MountTable.newInstance((String)stalePath, Collections.singletonMap("ns0", "/testdir9"));
        mountTable.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        this.addMountTable(mountTable);
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        RouterQuotaManager quotaManager = routerContext.getRouter().getQuotaManager();
        RouterQuotaUsage quota = quotaManager.getQuotaUsage(stalePath);
        Assert.assertEquals((long)nsQuota, (long)quota.getQuota());
        Assert.assertEquals((long)ssQuota, (long)quota.getSpaceQuota());
        this.removeMountTable(stalePath);
        updateService.periodicInvoke();
        quota = quotaManager.getQuotaUsage(stalePath);
        Assert.assertNull((Object)quota);
    }

    private boolean removeMountTable(String path) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        RemoveMountTableEntryRequest removeRequest = RemoveMountTableEntryRequest.newInstance((String)path);
        RemoveMountTableEntryResponse removeResponse = mountTableManager.removeMountTableEntry(removeRequest);
        resolver.loadCache(true);
        return removeResponse.getStatus();
    }

    @Test
    public void testQuotaUpdating() throws Exception {
        long nsQuota = 30L;
        long ssQuota = 1024L;
        String path = "/updatequota";
        FileSystem nnFs1 = nnContext1.getFileSystem();
        nnFs1.mkdirs(new Path("/testdir10"));
        MountTable mountTable = MountTable.newInstance((String)path, Collections.singletonMap("ns0", "/testdir10"));
        mountTable.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        this.addMountTable(mountTable);
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        MountTable updatedMountTable = this.getMountTable(path);
        RouterQuotaUsage quota = updatedMountTable.getQuota();
        Assert.assertEquals((long)nsQuota, (long)quota.getQuota());
        Assert.assertEquals((long)ssQuota, (long)quota.getSpaceQuota());
        Assert.assertEquals((long)1L, (long)quota.getFileAndDirectoryCount());
        Assert.assertEquals((long)0L, (long)quota.getSpaceConsumed());
        FileSystem routerFs = routerContext.getFileSystem();
        routerFs.mkdirs(new Path(path + "/" + UUID.randomUUID()));
        DFSClient routerClient = routerContext.getClient();
        routerClient.create(path + "/file", true).close();
        this.appendData(path + "/file", routerClient, 512);
        updateService.periodicInvoke();
        updatedMountTable = this.getMountTable(path);
        quota = updatedMountTable.getQuota();
        Assert.assertEquals((long)nsQuota, (long)quota.getQuota());
        Assert.assertEquals((long)ssQuota, (long)quota.getSpaceQuota());
        Assert.assertEquals((long)3L, (long)quota.getFileAndDirectoryCount());
        Assert.assertEquals((long)512L, (long)quota.getSpaceConsumed());
    }

    private MountTable getMountTable(String path) throws IOException {
        resolver.loadCache(true);
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)path);
        GetMountTableEntriesResponse response = mountTableManager.getMountTableEntries(getRequest);
        List results = response.getEntries();
        return !results.isEmpty() ? (MountTable)results.get(0) : null;
    }

    @Test
    public void testQuotaSynchronization() throws IOException {
        long updateNsQuota = 3L;
        long updateSsQuota = 4L;
        FileSystem nnFs = nnContext1.getFileSystem();
        nnFs.mkdirs(new Path("/testsync"));
        MountTable mountTable = MountTable.newInstance((String)"/quotaSync", Collections.singletonMap("ns0", "/testsync"), (long)Time.now(), (long)Time.now());
        mountTable.setQuota(new RouterQuotaUsage.Builder().quota(1L).spaceQuota(2L).build());
        this.addMountTable(mountTable);
        QuotaUsage realQuota = nnContext1.getFileSystem().getQuotaUsage(new Path("/testsync"));
        Assert.assertNotEquals((long)updateNsQuota, (long)realQuota.getQuota());
        Assert.assertNotEquals((long)updateSsQuota, (long)realQuota.getSpaceQuota());
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        mountTable.setQuota(new RouterQuotaUsage.Builder().quota(updateNsQuota).spaceQuota(updateSsQuota).build());
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance((MountTable)mountTable);
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        mountTableManager.updateMountTableEntry(updateRequest);
        realQuota = nnContext1.getFileSystem().getQuotaUsage(new Path("/testsync"));
        Assert.assertEquals((long)updateNsQuota, (long)realQuota.getQuota());
        Assert.assertEquals((long)updateSsQuota, (long)realQuota.getSpaceQuota());
        mountTable.setQuota(new RouterQuotaUsage.Builder().quota(-1L).spaceQuota(-1L).build());
        updateRequest = UpdateMountTableEntryRequest.newInstance((MountTable)mountTable);
        client = routerContext.getAdminClient();
        mountTableManager = client.getMountTableManager();
        mountTableManager.updateMountTableEntry(updateRequest);
        realQuota = nnContext1.getFileSystem().getQuotaUsage(new Path("/testsync"));
        Assert.assertEquals((long)-1L, (long)realQuota.getQuota());
        Assert.assertEquals((long)-1L, (long)realQuota.getSpaceQuota());
    }

    @Test
    public void testQuotaRefreshAfterQuotaExceed() throws Exception {
        long nsQuota = 3L;
        long ssQuota = 100L;
        FileSystem nnFs1 = nnContext1.getFileSystem();
        FileSystem nnFs2 = nnContext2.getFileSystem();
        nnFs1.mkdirs(new Path("/testdir11"));
        nnFs2.mkdirs(new Path("/testdir12"));
        MountTable mountTable1 = MountTable.newInstance((String)"/setquota1", Collections.singletonMap("ns0", "/testdir11"));
        mountTable1.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        this.addMountTable(mountTable1);
        MountTable mountTable2 = MountTable.newInstance((String)"/setquota2", Collections.singletonMap("ns1", "/testdir12"));
        mountTable2.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        this.addMountTable(mountTable2);
        FileSystem routerFs = routerContext.getFileSystem();
        routerFs.mkdirs(new Path("/setquota1/" + UUID.randomUUID()));
        routerFs.mkdirs(new Path("/setquota1/" + UUID.randomUUID()));
        routerFs.mkdirs(new Path("/setquota1/" + UUID.randomUUID()));
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        resolver.loadCache(true);
        RouterQuotaManager quotaManager = routerContext.getRouter().getQuotaManager();
        ClientProtocol client1 = nnContext1.getClient().getNamenode();
        ClientProtocol client2 = nnContext2.getClient().getNamenode();
        QuotaUsage quota1 = client1.getQuotaUsage("/testdir11");
        QuotaUsage quota2 = client2.getQuotaUsage("/testdir12");
        RouterQuotaUsage cacheQuota1 = quotaManager.getQuotaUsage("/setquota1");
        RouterQuotaUsage cacheQuota2 = quotaManager.getQuotaUsage("/setquota2");
        Assert.assertEquals((long)4L, (long)quota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)4L, (long)cacheQuota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)1L, (long)quota2.getFileAndDirectoryCount());
        Assert.assertEquals((long)1L, (long)cacheQuota2.getFileAndDirectoryCount());
        try {
            routerFs.mkdirs(new Path("/testdir11/" + UUID.randomUUID()));
            Assert.fail((String)"Mkdir should be failed under dir /testdir11.");
        }
        catch (NSQuotaExceededException nSQuotaExceededException) {
            // empty catch block
        }
        routerFs.mkdirs(new Path("/setquota2/" + UUID.randomUUID()));
        routerFs.mkdirs(new Path("/setquota2/" + UUID.randomUUID()));
        updateService.periodicInvoke();
        quota1 = client1.getQuotaUsage("/testdir11");
        cacheQuota1 = quotaManager.getQuotaUsage("/setquota1");
        quota2 = client2.getQuotaUsage("/testdir12");
        cacheQuota2 = quotaManager.getQuotaUsage("/setquota2");
        Assert.assertEquals((long)4L, (long)quota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)4L, (long)cacheQuota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)3L, (long)quota2.getFileAndDirectoryCount());
        Assert.assertEquals((long)3L, (long)cacheQuota2.getFileAndDirectoryCount());
    }

    @Test
    public void testQuotaRefreshWhenDestinationNotPresent() throws Exception {
        long nsQuota = 5L;
        long ssQuota = 1536L;
        FileSystem nnFs = nnContext1.getFileSystem();
        nnFs.mkdirs(new Path("/testdir13"));
        nnFs.mkdirs(new Path("/testdir14"));
        MountTable mountTable = MountTable.newInstance((String)"/setdir1", Collections.singletonMap("ns0", "/testdir13"));
        mountTable.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        this.addMountTable(mountTable);
        mountTable = MountTable.newInstance((String)"/setdir2", Collections.singletonMap("ns0", "/testdir14"));
        mountTable.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        this.addMountTable(mountTable);
        DFSClient routerClient = routerContext.getClient();
        routerClient.create("/setdir1/file1", true).close();
        routerClient.create("/setdir2/file2", true).close();
        this.appendData("/setdir1/file1", routerClient, 512);
        this.appendData("/setdir2/file2", routerClient, 512);
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        resolver.loadCache(true);
        ClientProtocol client1 = nnContext1.getClient().getNamenode();
        RouterQuotaManager quotaManager = routerContext.getRouter().getQuotaManager();
        QuotaUsage quota1 = client1.getQuotaUsage("/testdir13");
        QuotaUsage quota2 = client1.getQuotaUsage("/testdir14");
        RouterQuotaUsage cacheQuota1 = quotaManager.getQuotaUsage("/setdir1");
        RouterQuotaUsage cacheQuota2 = quotaManager.getQuotaUsage("/setdir2");
        MountTable updatedMountTable = this.getMountTable("/setdir1");
        RouterQuotaUsage mountQuota1 = updatedMountTable.getQuota();
        updatedMountTable = this.getMountTable("/setdir2");
        RouterQuotaUsage mountQuota2 = updatedMountTable.getQuota();
        Assert.assertEquals((long)2L, (long)quota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)2L, (long)cacheQuota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)2L, (long)mountQuota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)2L, (long)quota2.getFileAndDirectoryCount());
        Assert.assertEquals((long)2L, (long)cacheQuota2.getFileAndDirectoryCount());
        Assert.assertEquals((long)2L, (long)mountQuota2.getFileAndDirectoryCount());
        Assert.assertEquals((long)512L, (long)quota1.getSpaceConsumed());
        Assert.assertEquals((long)512L, (long)cacheQuota1.getSpaceConsumed());
        Assert.assertEquals((long)512L, (long)mountQuota1.getSpaceConsumed());
        Assert.assertEquals((long)512L, (long)quota2.getSpaceConsumed());
        Assert.assertEquals((long)512L, (long)cacheQuota2.getSpaceConsumed());
        Assert.assertEquals((long)512L, (long)mountQuota2.getSpaceConsumed());
        FileSystem routerFs = routerContext.getFileSystem();
        routerFs.delete(new Path("/setdir1"), true);
        routerClient.create("/setdir2/file3", true).close();
        this.appendData("/setdir2/file3", routerClient, 512);
        int updatedSpace = 1024;
        updateService.periodicInvoke();
        quota2 = client1.getQuotaUsage("/testdir14");
        cacheQuota1 = quotaManager.getQuotaUsage("/setdir1");
        cacheQuota2 = quotaManager.getQuotaUsage("/setdir2");
        updatedMountTable = this.getMountTable("/setdir1");
        mountQuota1 = updatedMountTable.getQuota();
        updatedMountTable = this.getMountTable("/setdir2");
        mountQuota2 = updatedMountTable.getQuota();
        Assert.assertEquals((long)0L, (long)cacheQuota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)0L, (long)mountQuota1.getFileAndDirectoryCount());
        Assert.assertEquals((long)0L, (long)cacheQuota1.getSpaceConsumed());
        Assert.assertEquals((long)0L, (long)mountQuota1.getSpaceConsumed());
        Assert.assertEquals((long)3L, (long)quota2.getFileAndDirectoryCount());
        Assert.assertEquals((long)3L, (long)cacheQuota2.getFileAndDirectoryCount());
        Assert.assertEquals((long)3L, (long)mountQuota2.getFileAndDirectoryCount());
        Assert.assertEquals((long)updatedSpace, (long)quota2.getSpaceConsumed());
        Assert.assertEquals((long)updatedSpace, (long)cacheQuota2.getSpaceConsumed());
        Assert.assertEquals((long)updatedSpace, (long)mountQuota2.getSpaceConsumed());
    }
}

