/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ojalgo.access.Access1D;
import org.ojalgo.matrix.store.DelegatingStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.Scalar;

final class LeftRightStore<N extends Number>
extends DelegatingStore<N> {
    private final MatrixStore<N> myRight;
    private final int mySplit;

    LeftRightStore(MatrixStore<N> base, MatrixStore<N> right) {
        super(base, (int)base.countRows(), (int)(base.countColumns() + right.countColumns()));
        this.myRight = right;
        this.mySplit = (int)base.countColumns();
        if (base.countRows() != right.countRows()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public double doubleValue(long row, long col) {
        return col >= (long)this.mySplit ? this.myRight.doubleValue(row, col - (long)this.mySplit) : this.getBase().doubleValue(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        return col < this.mySplit ? this.getBase().firstInColumn(col) : this.myRight.firstInColumn(col - this.mySplit);
    }

    @Override
    public int firstInRow(int row) {
        return this.getBase().firstInRow(row);
    }

    @Override
    public N get(long row, long col) {
        return col >= (long)this.mySplit ? this.myRight.get(row, col - (long)this.mySplit) : this.getBase().get(row, col);
    }

    @Override
    public int limitOfColumn(int col) {
        return col < this.mySplit ? this.getBase().limitOfColumn(col) : this.myRight.limitOfColumn(col - this.mySplit);
    }

    @Override
    public int limitOfRow(int row) {
        return this.mySplit + this.myRight.limitOfRow(row);
    }

    @Override
    public MatrixStore<N> premultiply(Access1D<N> leftMtrx) {
        Future<MatrixStore<N>> tmpBaseFuture = this.executeMultiplyLeftOnBase(leftMtrx);
        Object tmpRight = this.myRight.premultiply(leftMtrx).get();
        try {
            return new LeftRightStore<N>(tmpBaseFuture.get(), tmpRight);
        }
        catch (InterruptedException | ExecutionException ex) {
            return null;
        }
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        this.getBase().supplyTo(receiver.regionByLimits(this.getRowDim(), this.mySplit));
        this.myRight.supplyTo(receiver.regionByOffsets(0, this.mySplit));
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return column >= (long)this.mySplit ? this.myRight.toScalar(row, column - (long)this.mySplit) : this.getBase().toScalar(row, column);
    }

    @Override
    protected void addNonzerosTo(ElementsConsumer<N> consumer) {
        this.supplyTo(consumer);
    }
}

