/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class CompleteScanResultCache
extends ScanResultCache {
    private final List<Result> partialResults = new ArrayList<Result>();

    public CompleteScanResultCache(List<Result> cache) {
        super(cache);
    }

    private Result combine() throws IOException {
        Result result = Result.createCompleteResult(this.partialResults);
        this.partialResults.clear();
        return result;
    }

    private void prependCombinedAndCache(Result[] results, int length) throws IOException {
        if (length == 0) {
            this.checkUpdateNumberOfCompleteRowsAndCache(this.combine());
            return;
        }
        int start = 0;
        if (Bytes.equals((byte[])this.partialResults.get(0).getRow(), (byte[])results[0].getRow())) {
            this.partialResults.add(results[0]);
            start = 1;
        }
        this.checkUpdateNumberOfCompleteRowsAndCache(this.combine());
        this.addResultArrayToCache(results, start, length);
    }

    @Override
    public void loadResultsToCache(Result[] results, boolean isHeartbeatMessage) throws IOException {
        if (results.length == 0) {
            if (!this.partialResults.isEmpty() && !isHeartbeatMessage) {
                this.checkUpdateNumberOfCompleteRowsAndCache(this.combine());
            }
            return;
        }
        Result last = results[results.length - 1];
        if (last.mayHaveMoreCellsInRow()) {
            if (this.partialResults.isEmpty()) {
                this.partialResults.add(last);
                this.addResultArrayToCache(results, 0, results.length - 1);
                return;
            }
            if (results.length == 1) {
                if (Bytes.equals((byte[])this.partialResults.get(0).getRow(), (byte[])last.getRow())) {
                    this.partialResults.add(last);
                    return;
                }
                Result completeResult = this.combine();
                this.partialResults.add(last);
                this.checkUpdateNumberOfCompleteRowsAndCache(completeResult);
                return;
            }
            this.prependCombinedAndCache(results, results.length - 1);
            this.partialResults.add(last);
            return;
        }
        if (!this.partialResults.isEmpty()) {
            this.prependCombinedAndCache(results, results.length);
            return;
        }
        this.addResultArrayToCache(results, 0, results.length);
    }

    @Override
    protected void checkUpdateNumberOfCompleteRowsAndCache(Result rs) {
        ++this.numberOfCompleteRows;
        this.addResultToCache(rs);
    }

    @Override
    public void clear() {
        this.partialResults.clear();
        super.clear();
    }
}

