/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.util.Map;

public class PreconditionFailedException
extends DocumentClientException {
    private static final long serialVersionUID = 1L;

    public PreconditionFailedException() {
        this("Operation cannot be performed because one of the specified precondition is not met.");
    }

    public PreconditionFailedException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(412, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public PreconditionFailedException(String msg) {
        super(412, msg);
    }

    public PreconditionFailedException(String msg, String resourceAddress) {
        super(msg, null, null, 412, resourceAddress);
    }

    public PreconditionFailedException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public PreconditionFailedException(Exception innerException) {
        this("Operation cannot be performed because one of the specified precondition is not met.", innerException, null, null);
    }

    public PreconditionFailedException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(String.format("%s: %s", "Operation cannot be performed because one of the specified precondition is not met.", message), innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 412, requestUri);
    }
}

