/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity;

import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;

public class TimelineMetricSubDoc {
    private final TimelineMetric timelineMetric;
    private long singleDataTimestamp;
    private Number singleDataValue = 0;

    public TimelineMetricSubDoc() {
        this.timelineMetric = new TimelineMetric();
    }

    public TimelineMetricSubDoc(TimelineMetric timelineMetric) {
        this.timelineMetric = timelineMetric;
        if (timelineMetric.getType() == TimelineMetric.Type.SINGLE_VALUE && timelineMetric.getValues().size() > 0) {
            this.singleDataTimestamp = timelineMetric.getSingleDataTimestamp();
            this.singleDataValue = timelineMetric.getSingleDataValue();
        }
    }

    public TimelineMetricOperation getRealtimeAggregationOp() {
        return this.timelineMetric.getRealtimeAggregationOp();
    }

    public void setRealtimeAggregationOp(TimelineMetricOperation op) {
        this.timelineMetric.setRealtimeAggregationOp(op);
    }

    public String getId() {
        return this.timelineMetric.getId();
    }

    public void setId(String metricId) {
        this.timelineMetric.setId(metricId);
    }

    public void setSingleDataTimestamp(long singleDataTimestamp) {
        this.singleDataTimestamp = singleDataTimestamp;
    }

    public long getSingleDataTimestamp() {
        if (this.timelineMetric.getType() == TimelineMetric.Type.SINGLE_VALUE) {
            return this.singleDataTimestamp;
        }
        return 0L;
    }

    public Number getSingleDataValue() {
        if (this.timelineMetric.getType() == TimelineMetric.Type.SINGLE_VALUE) {
            return this.singleDataValue;
        }
        return null;
    }

    public void setSingleDataValue(Number singleDataValue) {
        this.singleDataValue = singleDataValue;
    }

    public Map<Long, Number> getValues() {
        return this.timelineMetric.getValues();
    }

    public void setValues(Map<Long, Number> vals) {
        this.timelineMetric.setValues(vals);
    }

    public TreeMap<Long, Number> getValuesJAXB() {
        return this.timelineMetric.getValuesJAXB();
    }

    public TimelineMetric.Type getType() {
        return this.timelineMetric.getType();
    }

    public void setType(TimelineMetric.Type metricType) {
        this.timelineMetric.setType(metricType);
    }

    public boolean isValid() {
        return this.timelineMetric.getId() != null;
    }

    public int hashCode() {
        int result = this.timelineMetric.getId().hashCode();
        result = 31 * result + this.timelineMetric.getType().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimelineMetricSubDoc)) {
            return false;
        }
        TimelineMetricSubDoc otherTimelineMetric = (TimelineMetricSubDoc)obj;
        if (!this.timelineMetric.getId().equals(otherTimelineMetric.getId())) {
            return false;
        }
        return this.timelineMetric.getType() == otherTimelineMetric.getType();
    }

    public TimelineMetric fetchTimelineMetric() {
        return this.timelineMetric;
    }
}

