/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.AHSProxy;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public abstract class AppReportFetcher {
    private final Configuration conf;
    private ApplicationHistoryProtocol historyManager;
    private String ahsAppPageUrlBase;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private boolean isAHSEnabled;

    public AppReportFetcher(Configuration conf) {
        this.conf = conf;
        if (conf.getBoolean("yarn.timeline-service.generic-application-history.enabled", false)) {
            this.isAHSEnabled = true;
            String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
            String historyUrl = WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf);
            this.ahsAppPageUrlBase = StringHelper.pjoin((Object[])new Object[]{scheme + historyUrl, "applicationhistory", "app"});
        }
        try {
            this.historyManager = this.isAHSEnabled ? this.getAHSProxy(conf) : null;
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected ApplicationHistoryProtocol getAHSProxy(Configuration configuration) throws IOException {
        InetSocketAddress addr = configuration.getSocketAddr("yarn.timeline-service.address", "0.0.0.0:10200", 10200);
        return (ApplicationHistoryProtocol)AHSProxy.createAHSProxy((Configuration)configuration, ApplicationHistoryProtocol.class, (InetSocketAddress)addr);
    }

    public abstract FetchedAppReport getApplicationReport(ApplicationId var1) throws YarnException, IOException;

    protected FetchedAppReport getApplicationReport(ApplicationClientProtocol applicationsManager, ApplicationId appId) throws YarnException, IOException {
        FetchedAppReport fetchedAppReport;
        GetApplicationReportRequest request = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        try {
            ApplicationReport appReport = applicationsManager.getApplicationReport(request).getApplicationReport();
            fetchedAppReport = new FetchedAppReport(appReport, AppReportSource.RM);
        }
        catch (ApplicationNotFoundException e) {
            if (!this.isAHSEnabled) {
                throw e;
            }
            ApplicationReport appReport = this.historyManager.getApplicationReport(request).getApplicationReport();
            fetchedAppReport = new FetchedAppReport(appReport, AppReportSource.AHS);
        }
        return fetchedAppReport;
    }

    public abstract String getRmAppPageUrlBase(ApplicationId var1) throws IOException, YarnException;

    public String getAhsAppPageUrlBase() {
        return this.ahsAppPageUrlBase;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    public void stop() {
        if (this.historyManager != null) {
            RPC.stopProxy((Object)this.historyManager);
        }
    }

    @VisibleForTesting
    public void setHistoryManager(ApplicationHistoryProtocol historyManager) {
        this.historyManager = historyManager;
    }

    protected static class FetchedAppReport {
        private ApplicationReport appReport;
        private AppReportSource appReportSource;

        public FetchedAppReport(ApplicationReport appReport, AppReportSource appReportSource) {
            this.appReport = appReport;
            this.appReportSource = appReportSource;
        }

        public AppReportSource getAppReportSource() {
            return this.appReportSource;
        }

        public ApplicationReport getApplicationReport() {
            return this.appReport;
        }
    }

    protected static enum AppReportSource {
        RM,
        AHS;

    }
}

