/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTConfiguration;

public class TCPObjectSocket {
    public static int BUFFER_SIZE = 512000;
    InputStream in;
    OutputStream out;
    FSTConfiguration conf;
    Socket socket;
    Throwable lastErr;
    boolean stopped;
    AtomicBoolean readLock = new AtomicBoolean(false);
    AtomicBoolean writeLock = new AtomicBoolean(false);

    public TCPObjectSocket(String host, int port) throws IOException {
        this(new Socket(host, port), FSTConfiguration.createDefaultConfiguration());
    }

    public TCPObjectSocket(String host, int port, FSTConfiguration conf) throws IOException {
        this(new Socket(host, port), conf);
    }

    public TCPObjectSocket(Socket socket, FSTConfiguration conf) throws IOException {
        this.socket = socket;
        this.out = new BufferedOutputStream(socket.getOutputStream(), BUFFER_SIZE);
        this.in = new BufferedInputStream(socket.getInputStream(), BUFFER_SIZE);
        this.conf = conf;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public InputStream getIn() {
        return this.in;
    }

    public Object readObject() throws Exception {
        try {
            while (!this.readLock.compareAndSet(false, true)) {
            }
            Object object = this.conf.decodeFromStream(this.in);
            return object;
        }
        finally {
            this.readLock.set(false);
        }
    }

    public void writeObject(Object toWrite) throws Exception {
        try {
            while (!this.writeLock.compareAndSet(false, true)) {
            }
            this.conf.encodeToStream(this.out, toWrite);
        }
        finally {
            this.writeLock.set(false);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void setLastError(Throwable ex) {
        this.stopped = true;
        this.lastErr = ex;
    }

    public Throwable getLastError() {
        return this.lastErr;
    }

    public void close() throws IOException {
        this.flush();
        this.socket.close();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public void setConf(FSTConfiguration conf) {
        this.conf = conf;
    }
}

