/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSocketUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ServerSocketUtil.class);
    private static Random rand = new Random();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPort(int port, int retries) throws IOException {
        int tryPort = port;
        int tries = 0;
        while (true) {
            if (tries > 0 || tryPort == 0) {
                tryPort = port + rand.nextInt(65535 - port);
            }
            if (tryPort == 0) continue;
            try (ServerSocket s = new ServerSocket(tryPort, 50, InetAddress.getLoopbackAddress());){
                LOG.info("Using port " + tryPort);
                int n = tryPort;
                return n;
            }
            catch (IOException e) {
                if (++tries >= retries) {
                    LOG.info("Port is already in use; giving up");
                    throw e;
                }
                LOG.info("Port is already in use; trying again");
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortAvailable(int port) {
        try (ServerSocket s = new ServerSocket(port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static int waitForPort(int port, int retries) throws InterruptedException, IOException {
        int tries = 0;
        while (!ServerSocketUtil.isPortAvailable(port)) {
            if (++tries >= retries) {
                throw new IOException("Port is already in use; giving up after " + tries + " times.");
            }
            Thread.sleep(1000L);
        }
        return port;
    }

    public static int[] getPorts(int numPorts) throws IOException {
        ServerSocket[] sockets = new ServerSocket[numPorts];
        int[] ports = new int[numPorts];
        for (int i = 0; i < numPorts; ++i) {
            ServerSocket sock;
            sockets[i] = sock = new ServerSocket(0);
            ports[i] = sock.getLocalPort();
        }
        for (ServerSocket sock : sockets) {
            sock.close();
        }
        return ports;
    }
}

