/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.io.PrintStream;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.EpochFormatter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryFormat;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryReporter;

class PrintStreamTelemetryReporter
implements TelemetryReporter {
    @NonNull
    private final PrintStream printStream;
    @NonNull
    private final EpochFormatter epochFormatter;
    @NonNull
    private final TelemetryFormat telemetryFormat;

    public PrintStreamTelemetryReporter(@NonNull PrintStream printStream, @NonNull EpochFormatter epochFormatter, @NonNull TelemetryFormat telemetryFormat) {
        if (printStream == null) {
            throw new NullPointerException("printStream is marked non-null but is null");
        }
        if (epochFormatter == null) {
            throw new NullPointerException("epochFormatter is marked non-null but is null");
        }
        if (telemetryFormat == null) {
            throw new NullPointerException("telemetryFormat is marked non-null but is null");
        }
        this.printStream = printStream;
        this.epochFormatter = epochFormatter;
        this.telemetryFormat = telemetryFormat;
    }

    public PrintStreamTelemetryReporter(PrintStream printStream, TelemetryFormat telemetryFormat) {
        this(printStream, EpochFormatter.DEFAULT, telemetryFormat);
    }

    @Override
    public void reportStart(long epochTimestampNanos, @NonNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.printStream.println(this.telemetryFormat.renderOperationStart(operation, epochTimestampNanos, this.epochFormatter));
    }

    @Override
    public void reportComplete(@NonNull TelemetryDatapointMeasurement datapointMeasurement) {
        if (datapointMeasurement == null) {
            throw new NullPointerException("datapointMeasurement is marked non-null but is null");
        }
        this.printStream.println(this.telemetryFormat.renderDatapointMeasurement(datapointMeasurement, this.epochFormatter));
    }

    @Override
    public void flush() {
        this.printStream.flush();
    }

    @NonNull
    @Generated
    public PrintStream getPrintStream() {
        return this.printStream;
    }

    @NonNull
    @Generated
    public EpochFormatter getEpochFormatter() {
        return this.epochFormatter;
    }

    @NonNull
    @Generated
    public TelemetryFormat getTelemetryFormat() {
        return this.telemetryFormat;
    }
}

