/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.util.List;
import org.ojalgo.access.IntIndex;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.linear.LinearSolver;

final class ExpressionsBasedLinearIntegration
extends ExpressionsBasedModel.Integration<LinearSolver> {
    ExpressionsBasedLinearIntegration() {
    }

    @Override
    public LinearSolver build(ExpressionsBasedModel model) {
        LinearSolver.Builder tmpBuilder = LinearSolver.getBuilder();
        LinearSolver.copy(model, tmpBuilder);
        return tmpBuilder.build(model.options);
    }

    @Override
    public boolean isCapable(ExpressionsBasedModel model) {
        return !model.isAnyVariableInteger() && !model.isAnyExpressionQuadratic();
    }

    @Override
    public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
        Primitive64Array tmpModelSolution = Primitive64Array.make(model.countVariables());
        for (IntIndex tmpFixed : model.getFixedVariables()) {
            tmpModelSolution.set((long)tmpFixed.index, model.getVariable(tmpFixed.index).getValue().doubleValue());
        }
        List<Variable> tmpPositives = model.getPositiveVariables();
        for (int p = 0; p < tmpPositives.size(); ++p) {
            Variable tmpVariable = tmpPositives.get(p);
            int tmpIndex = model.indexOf(tmpVariable);
            tmpModelSolution.set((long)tmpIndex, solverState.doubleValue(p));
        }
        List<Variable> tmpNegatives = model.getNegativeVariables();
        for (int n = 0; n < tmpNegatives.size(); ++n) {
            Variable tmpVariable = tmpNegatives.get(n);
            int tmpIndex = model.indexOf(tmpVariable);
            tmpModelSolution.set((long)tmpIndex, tmpModelSolution.doubleValue((long)tmpIndex) - solverState.doubleValue(tmpPositives.size() + n));
        }
        return new Optimisation.Result(solverState.getState(), solverState.getValue(), tmpModelSolution);
    }

    @Override
    public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
        int tmpIndex;
        Variable tmpVariable;
        List<Variable> tmpPositives = model.getPositiveVariables();
        List<Variable> tmpNegatives = model.getNegativeVariables();
        int tmpCountPositives = tmpPositives.size();
        int tmpCountNegatives = tmpNegatives.size();
        Primitive64Array tmpSolverSolution = Primitive64Array.make(tmpCountPositives + tmpCountNegatives);
        for (int p = 0; p < tmpCountPositives; ++p) {
            tmpVariable = tmpPositives.get(p);
            tmpIndex = model.indexOf(tmpVariable);
            tmpSolverSolution.set((long)p, PrimitiveFunction.MAX.invoke(modelState.doubleValue(tmpIndex), 0.0));
        }
        for (int n = 0; n < tmpCountNegatives; ++n) {
            tmpVariable = tmpNegatives.get(n);
            tmpIndex = model.indexOf(tmpVariable);
            tmpSolverSolution.set((long)(tmpCountPositives + n), PrimitiveFunction.MAX.invoke(-modelState.doubleValue(tmpIndex), 0.0));
        }
        return new Optimisation.Result(modelState.getState(), modelState.getValue(), tmpSolverSolution);
    }
}

