/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class ApplyCholesky
extends MatrixOperation {
    public static final ApplyCholesky SETUP = new ApplyCholesky();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, BigDecimal[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, 1, multipliers[j].negate(), multipliers, 0, 1, j, structure);
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int firstColumn, int columnLimit, ComplexNumber[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke((Number[])data, (int)(j * structure), (int)1, (Number)multipliers[j].conjugate().negate(), (Number[])multipliers, (int)0, (int)1, (int)j, (int)structure);
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, 1, -multipliers[j], multipliers, 0, 1, j, structure);
        }
    }

    private ApplyCholesky() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

