/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultNameNodePort {
    @Test
    public void testGetAddressFromString() throws Exception {
        Assert.assertEquals((long)8020L, (long)DFSUtilClient.getNNAddress((String)"foo").getPort());
        Assert.assertEquals((long)8020L, (long)DFSUtilClient.getNNAddress((String)"hdfs://foo/").getPort());
        Assert.assertEquals((long)555L, (long)DFSUtilClient.getNNAddress((String)"hdfs://foo:555").getPort());
        Assert.assertEquals((long)555L, (long)DFSUtilClient.getNNAddress((String)"foo:555").getPort());
    }

    @Test
    public void testGetAddressFromConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://foo/");
        Assert.assertEquals((long)8020L, (long)DFSUtilClient.getNNAddress((Configuration)conf).getPort());
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://foo:555/");
        Assert.assertEquals((long)555L, (long)DFSUtilClient.getNNAddress((Configuration)conf).getPort());
        FileSystem.setDefaultUri((Configuration)conf, (String)"foo");
        Assert.assertEquals((long)8020L, (long)DFSUtilClient.getNNAddress((Configuration)conf).getPort());
        FileSystem.setDefaultUri((Configuration)conf, (String)"foo:555");
        Assert.assertEquals((long)555L, (long)DFSUtilClient.getNNAddress((Configuration)conf).getPort());
    }

    @Test
    public void testGetUri() {
        Assert.assertEquals((Object)URI.create("hdfs://foo:555"), (Object)DFSUtilClient.getNNUri((InetSocketAddress)new InetSocketAddress("foo", 555)));
        Assert.assertEquals((Object)URI.create("hdfs://foo"), (Object)DFSUtilClient.getNNUri((InetSocketAddress)new InetSocketAddress("foo", 8020)));
    }
}

