/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zstd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.ZStandardCodec;
import org.apache.hadoop.io.compress.zstd.ZStandardCompressor;
import org.apache.hadoop.io.compress.zstd.ZStandardDecompressor;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestZStandardCompressorDecompressor {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final Random RANDOM = new Random(12345L);
    private static final Configuration CONFIGURATION = new Configuration();
    private static File compressedFile;
    private static File uncompressedFile;

    @BeforeClass
    public static void beforeClass() throws Exception {
        CONFIGURATION.setInt("io.file.buffer.size", 65536);
        uncompressedFile = new File(TestZStandardCompressorDecompressor.class.getResource("/zstd/test_file.txt").toURI());
        compressedFile = new File(TestZStandardCompressorDecompressor.class.getResource("/zstd/test_file.txt.zst").toURI());
    }

    @Before
    public void before() throws Exception {
        Assume.assumeTrue((boolean)ZStandardCodec.isNativeCodeLoaded());
    }

    @Test
    public void testCompressionCompressesCorrectly() throws Exception {
        int uncompressedSize = (int)FileUtils.sizeOf((File)uncompressedFile);
        byte[] bytes = FileUtils.readFileToByteArray((File)uncompressedFile);
        Assert.assertEquals((long)uncompressedSize, (long)bytes.length);
        Configuration conf = new Configuration();
        ZStandardCodec codec = new ZStandardCodec();
        codec.setConf(conf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Compressor compressor = codec.createCompressor();
        CompressionOutputStream outputStream = codec.createOutputStream((OutputStream)baos, compressor);
        for (byte aByte : bytes) {
            outputStream.write((int)aByte);
        }
        outputStream.finish();
        outputStream.close();
        Assert.assertEquals((long)uncompressedSize, (long)compressor.getBytesRead());
        Assert.assertTrue((boolean)compressor.finished());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        Decompressor decompressor = codec.createDecompressor();
        CompressionInputStream inputStream = codec.createInputStream((InputStream)bais, decompressor);
        byte[] buffer = new byte[100];
        int n = buffer.length;
        while ((n = inputStream.read(buffer, 0, n)) != -1) {
            byteArrayOutputStream.write(buffer, 0, n);
        }
        Assert.assertArrayEquals((byte[])bytes, (byte[])byteArrayOutputStream.toByteArray());
    }

    @Test(expected=NullPointerException.class)
    public void testCompressorSetInputNullPointerException() {
        ZStandardCompressor compressor = new ZStandardCompressor();
        compressor.setInput(null, 0, 10);
    }

    @Test(expected=NullPointerException.class)
    public void testDecompressorSetInputNullPointerException() {
        ZStandardDecompressor decompressor = new ZStandardDecompressor(4096);
        decompressor.setInput(null, 0, 10);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testCompressorSetInputAIOBException() {
        ZStandardCompressor compressor = new ZStandardCompressor();
        compressor.setInput(new byte[0], -5, 10);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testDecompressorSetInputAIOUBException() {
        ZStandardDecompressor decompressor = new ZStandardDecompressor(4096);
        decompressor.setInput(new byte[0], -5, 10);
    }

    @Test(expected=NullPointerException.class)
    public void testCompressorCompressNullPointerException() throws Exception {
        ZStandardCompressor compressor = new ZStandardCompressor();
        byte[] bytes = TestZStandardCompressorDecompressor.generate(6144);
        compressor.setInput(bytes, 0, bytes.length);
        compressor.compress(null, 0, 0);
    }

    @Test(expected=NullPointerException.class)
    public void testDecompressorCompressNullPointerException() throws Exception {
        ZStandardDecompressor decompressor = new ZStandardDecompressor(4096);
        byte[] bytes = TestZStandardCompressorDecompressor.generate(6144);
        decompressor.setInput(bytes, 0, bytes.length);
        decompressor.decompress(null, 0, 0);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testCompressorCompressAIOBException() throws Exception {
        ZStandardCompressor compressor = new ZStandardCompressor();
        byte[] bytes = TestZStandardCompressorDecompressor.generate(6144);
        compressor.setInput(bytes, 0, bytes.length);
        compressor.compress(new byte[0], 0, -1);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testDecompressorCompressAIOBException() throws Exception {
        ZStandardDecompressor decompressor = new ZStandardDecompressor(4096);
        byte[] bytes = TestZStandardCompressorDecompressor.generate(6144);
        decompressor.setInput(bytes, 0, bytes.length);
        decompressor.decompress(new byte[0], 0, -1);
    }

    @Test
    public void testSetInputWithBytesSizeMoreThenDefaultZStandardBufferSize() throws Exception {
        int bytesSize = 0x202001;
        ZStandardCompressor compressor = new ZStandardCompressor();
        byte[] bytes = TestZStandardCompressorDecompressor.generate(bytesSize);
        Assert.assertTrue((String)"needsInput error !!!", (boolean)compressor.needsInput());
        compressor.setInput(bytes, 0, bytes.length);
        byte[] emptyBytes = new byte[bytesSize];
        int cSize = compressor.compress(emptyBytes, 0, bytes.length);
        Assert.assertTrue((cSize > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressorDecompressorLogicWithCompressionStreams() throws Exception {
        DataOutputStream deflateOut = null;
        DataInputStream inflateIn = null;
        int byteSize = 102400;
        byte[] bytes = TestZStandardCompressorDecompressor.generate(byteSize);
        int bufferSize = 4096;
        try {
            DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
            CompressorStream deflateFilter = new CompressorStream((OutputStream)compressedDataBuffer, (Compressor)new ZStandardCompressor(), bufferSize);
            deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));
            deflateOut.write(bytes, 0, bytes.length);
            deflateOut.flush();
            deflateFilter.finish();
            DataInputBuffer deCompressedDataBuffer = new DataInputBuffer();
            deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
            DecompressorStream inflateFilter = new DecompressorStream((InputStream)deCompressedDataBuffer, (Decompressor)new ZStandardDecompressor(bufferSize), bufferSize);
            inflateIn = new DataInputStream(new BufferedInputStream((InputStream)inflateFilter));
            byte[] result = new byte[byteSize];
            inflateIn.read(result);
            Assert.assertArrayEquals((String)"original array not equals compress/decompressed array", (byte[])result, (byte[])bytes);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(deflateOut);
            IOUtils.closeQuietly(inflateIn);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)deflateOut);
        IOUtils.closeQuietly((InputStream)inflateIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressorDecompressorWithFinish() throws Exception {
        DataOutputStream deflateOut = null;
        DataInputStream inflateIn = null;
        int byteSize = 102400;
        byte[] bytes = TestZStandardCompressorDecompressor.generate(byteSize);
        int firstLength = 30720;
        int bufferSize = 4096;
        try {
            DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
            CompressorStream deflateFilter = new CompressorStream((OutputStream)compressedDataBuffer, (Compressor)new ZStandardCompressor(), bufferSize);
            deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));
            deflateOut.write(bytes, 0, firstLength);
            deflateFilter.finish();
            deflateOut.flush();
            deflateFilter.resetState();
            deflateOut.write(bytes, firstLength, firstLength);
            deflateFilter.finish();
            deflateOut.flush();
            deflateFilter.resetState();
            deflateOut.write(bytes, firstLength * 2, byteSize - firstLength * 2);
            deflateFilter.finish();
            deflateOut.flush();
            DataInputBuffer deCompressedDataBuffer = new DataInputBuffer();
            deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
            DecompressorStream inflateFilter = new DecompressorStream((InputStream)deCompressedDataBuffer, (Decompressor)new ZStandardDecompressor(bufferSize), bufferSize);
            inflateIn = new DataInputStream(new BufferedInputStream((InputStream)inflateFilter));
            byte[] result = new byte[byteSize];
            inflateIn.read(result);
            Assert.assertArrayEquals((String)"original array not equals compress/decompressed array", (byte[])bytes, (byte[])result);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(deflateOut);
            IOUtils.closeQuietly(inflateIn);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)deflateOut);
        IOUtils.closeQuietly((InputStream)inflateIn);
    }

    @Test
    public void testZStandardCompressDecompressInMultiThreads() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        for (int i = 0; i < 10; ++i) {
            ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

                @Override
                public void doWork() throws Exception {
                    TestZStandardCompressorDecompressor.this.testCompressDecompress();
                }
            });
        }
        ctx.startThreads();
        ctx.waitFor(60000L);
    }

    @Test
    public void testCompressDecompress() throws Exception {
        int rawDataSize = 4096;
        byte[] rawData = TestZStandardCompressorDecompressor.generate(rawDataSize);
        ZStandardCompressor compressor = new ZStandardCompressor();
        ZStandardDecompressor decompressor = new ZStandardDecompressor(4096);
        Assert.assertFalse((boolean)compressor.finished());
        compressor.setInput(rawData, 0, rawData.length);
        Assert.assertEquals((long)0L, (long)compressor.getBytesRead());
        compressor.finish();
        byte[] compressedResult = new byte[rawDataSize];
        int cSize = compressor.compress(compressedResult, 0, rawDataSize);
        Assert.assertEquals((long)rawDataSize, (long)compressor.getBytesRead());
        Assert.assertTrue((cSize < rawDataSize ? 1 : 0) != 0);
        decompressor.setInput(compressedResult, 0, cSize);
        byte[] decompressedBytes = new byte[rawDataSize];
        decompressor.decompress(decompressedBytes, 0, decompressedBytes.length);
        Assert.assertEquals((Object)TestZStandardCompressorDecompressor.bytesToHex(rawData), (Object)TestZStandardCompressorDecompressor.bytesToHex(decompressedBytes));
        compressor.reset();
        decompressor.reset();
    }

    @Test
    public void testCompressingWithOneByteOutputBuffer() throws Exception {
        int uncompressedSize = (int)FileUtils.sizeOf((File)uncompressedFile);
        byte[] bytes = FileUtils.readFileToByteArray((File)uncompressedFile);
        Assert.assertEquals((long)uncompressedSize, (long)bytes.length);
        Configuration conf = new Configuration();
        ZStandardCodec codec = new ZStandardCodec();
        codec.setConf(conf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZStandardCompressor compressor = new ZStandardCompressor(3, 4096, 1);
        CompressionOutputStream outputStream = codec.createOutputStream((OutputStream)baos, (Compressor)compressor);
        for (byte aByte : bytes) {
            outputStream.write((int)aByte);
        }
        outputStream.finish();
        outputStream.close();
        Assert.assertEquals((long)uncompressedSize, (long)compressor.getBytesRead());
        Assert.assertTrue((boolean)compressor.finished());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        Decompressor decompressor = codec.createDecompressor();
        CompressionInputStream inputStream = codec.createInputStream((InputStream)bais, decompressor);
        byte[] buffer = new byte[100];
        int n = buffer.length;
        while ((n = inputStream.read(buffer, 0, n)) != -1) {
            byteArrayOutputStream.write(buffer, 0, n);
        }
        Assert.assertArrayEquals((byte[])bytes, (byte[])byteArrayOutputStream.toByteArray());
    }

    @Test
    public void testZStandardCompressDecompress() throws Exception {
        byte[] rawData = null;
        int rawDataSize = 0;
        rawDataSize = 4096;
        rawData = TestZStandardCompressorDecompressor.generate(rawDataSize);
        ZStandardCompressor compressor = new ZStandardCompressor();
        ZStandardDecompressor decompressor = new ZStandardDecompressor(rawDataSize);
        Assert.assertTrue((boolean)compressor.needsInput());
        Assert.assertFalse((String)"testZStandardCompressDecompress finished error", (boolean)compressor.finished());
        compressor.setInput(rawData, 0, rawData.length);
        compressor.finish();
        byte[] compressedResult = new byte[rawDataSize];
        int cSize = compressor.compress(compressedResult, 0, rawDataSize);
        Assert.assertEquals((long)rawDataSize, (long)compressor.getBytesRead());
        Assert.assertTrue((String)"compressed size no less then original size", (cSize < rawDataSize ? 1 : 0) != 0);
        decompressor.setInput(compressedResult, 0, cSize);
        byte[] decompressedBytes = new byte[rawDataSize];
        decompressor.decompress(decompressedBytes, 0, decompressedBytes.length);
        String decompressed = TestZStandardCompressorDecompressor.bytesToHex(decompressedBytes);
        String original = TestZStandardCompressorDecompressor.bytesToHex(rawData);
        Assert.assertEquals((Object)original, (Object)decompressed);
        compressor.reset();
        decompressor.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecompressingOutput() throws Exception {
        byte[] decompressedResult;
        byte[] expectedDecompressedResult = FileUtils.readFileToByteArray((File)uncompressedFile);
        ZStandardCodec codec = new ZStandardCodec();
        codec.setConf(CONFIGURATION);
        CompressionInputStream inputStream = codec.createInputStream((InputStream)FileUtils.openInputStream((File)compressedFile), codec.createDecompressor());
        byte[] toDecompress = new byte[100];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalFileSize = 0;
        int result = toDecompress.length;
        try {
            while ((result = inputStream.read(toDecompress, 0, result)) != -1) {
                baos.write(toDecompress, 0, result);
                totalFileSize += result;
            }
            decompressedResult = baos.toByteArray();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
        Assert.assertEquals((long)decompressedResult.length, (long)totalFileSize);
        Assert.assertEquals((Object)TestZStandardCompressorDecompressor.bytesToHex(expectedDecompressedResult), (Object)TestZStandardCompressorDecompressor.bytesToHex(decompressedResult));
    }

    @Test
    public void testZStandardDirectCompressDecompress() throws Exception {
        int[] size;
        for (int aSize : size = new int[]{1, 4, 16, 4096, 65536, 131072, 0x100000}) {
            System.out.println("aSize = " + aSize);
            this.compressDecompressLoop(aSize);
        }
    }

    private void compressDecompressLoop(int rawDataSize) throws IOException {
        byte[] rawData = null;
        rawData = TestZStandardCompressorDecompressor.generate(rawDataSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(rawDataSize + 12);
        CompressorStream deflateFilter = new CompressorStream((OutputStream)baos, (Compressor)new ZStandardCompressor(), 4096);
        DataOutputStream deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));
        deflateOut.write(rawData, 0, rawData.length);
        deflateOut.flush();
        deflateFilter.finish();
        byte[] compressedResult = baos.toByteArray();
        int compressedSize = compressedResult.length;
        ZStandardDecompressor.ZStandardDirectDecompressor decompressor = new ZStandardDecompressor.ZStandardDirectDecompressor(4096);
        ByteBuffer inBuf = ByteBuffer.allocateDirect(compressedSize);
        ByteBuffer outBuf = ByteBuffer.allocateDirect(8096);
        inBuf.put(compressedResult, 0, compressedSize);
        inBuf.flip();
        ByteBuffer expected = ByteBuffer.wrap(rawData);
        outBuf.clear();
        while (!decompressor.finished()) {
            decompressor.decompress(inBuf, outBuf);
            outBuf.flip();
            while (outBuf.remaining() > 0) {
                Assert.assertEquals((long)expected.get(), (long)outBuf.get());
            }
            outBuf.clear();
        }
        outBuf.flip();
        while (outBuf.remaining() > 0) {
            Assert.assertEquals((long)expected.get(), (long)outBuf.get());
        }
        outBuf.clear();
        Assert.assertEquals((long)0L, (long)expected.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadingWithAStream() throws Exception {
        byte[] resultOfDecompression;
        FileInputStream inputStream = FileUtils.openInputStream((File)compressedFile);
        ZStandardCodec codec = new ZStandardCodec();
        codec.setConf(CONFIGURATION);
        Decompressor decompressor = codec.createDecompressor();
        CompressionInputStream cis = codec.createInputStream((InputStream)inputStream, decompressor);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int n;
            byte[] buffer = new byte[100];
            while ((n = cis.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, n);
            }
            resultOfDecompression = baos.toByteArray();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
            IOUtils.closeQuietly((InputStream)cis);
        }
        byte[] expected = FileUtils.readFileToByteArray((File)uncompressedFile);
        Assert.assertEquals((Object)TestZStandardCompressorDecompressor.bytesToHex(expected), (Object)TestZStandardCompressorDecompressor.bytesToHex(resultOfDecompression));
    }

    @Test
    public void testDecompressReturnsWhenNothingToDecompress() throws Exception {
        ZStandardDecompressor decompressor = new ZStandardDecompressor(4096);
        int result = decompressor.decompress(new byte[10], 0, 10);
        Assert.assertEquals((long)0L, (long)result);
    }

    public static byte[] generate(int size) {
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (byte)RANDOM.nextInt(16);
        }
        return data;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

