/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnName;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public final class EventColumnNameConverter
implements KeyConverter<EventColumnName> {
    private static final int[] SEGMENT_SIZES = new int[]{0, 8, 0};

    @Override
    public byte[] encode(EventColumnName key) {
        byte[] first = Separator.encode(key.getId(), Separator.SPACE, Separator.TAB, Separator.VALUES);
        if (key.getTimestamp() == null) {
            return Separator.VALUES.join(first, Separator.EMPTY_BYTES);
        }
        byte[] second = Bytes.toBytes((long)LongConverter.invertLong(key.getTimestamp()));
        if (key.getInfoKey() == null) {
            return Separator.VALUES.join(first, second, Separator.EMPTY_BYTES);
        }
        return Separator.VALUES.join(first, second, Separator.encode(key.getInfoKey(), Separator.SPACE, Separator.TAB, Separator.VALUES));
    }

    @Override
    public EventColumnName decode(byte[] bytes) {
        byte[][] components = Separator.VALUES.split(bytes, SEGMENT_SIZES);
        if (components.length != 3) {
            throw new IllegalArgumentException("the column name is not valid");
        }
        String id = Separator.decode(Bytes.toString((byte[])components[0]), Separator.VALUES, Separator.TAB, Separator.SPACE);
        Long ts = LongConverter.invertLong(Bytes.toLong((byte[])components[1]));
        String infoKey = components[2].length == 0 ? null : Separator.decode(Bytes.toString((byte[])components[2]), Separator.VALUES, Separator.TAB, Separator.SPACE);
        return new EventColumnName(id, ts, infoKey);
    }
}

