/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.recovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.JniDBFactory;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.internal.NativeDB;
import org.apache.hadoop.shaded.org.iq80.leveldb.DB;
import org.apache.hadoop.shaded.org.iq80.leveldb.DBException;
import org.apache.hadoop.shaded.org.iq80.leveldb.Options;
import org.apache.hadoop.shaded.org.iq80.leveldb.WriteBatch;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.records.TimelineDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.timeline.util.LeveldbUtils;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeveldbTimelineStateStore
extends TimelineStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(LeveldbTimelineStateStore.class);
    private static final String DB_NAME = "timeline-state-store.ldb";
    private static final FsPermission LEVELDB_DIR_UMASK = FsPermission.createImmutable((short)448);
    private static final byte[] TOKEN_ENTRY_PREFIX = JniDBFactory.bytes((String)"t");
    private static final byte[] TOKEN_MASTER_KEY_ENTRY_PREFIX = JniDBFactory.bytes((String)"k");
    private static final byte[] LATEST_SEQUENCE_NUMBER_KEY = JniDBFactory.bytes((String)"s");
    private static final Version CURRENT_VERSION_INFO = Version.newInstance(1, 0);
    private static final byte[] TIMELINE_STATE_STORE_VERSION_KEY = JniDBFactory.bytes((String)"v");
    private DB db;

    public LeveldbTimelineStateStore() {
        super(LeveldbTimelineStateStore.class.getName());
    }

    @Override
    protected void initStorage(Configuration conf) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startStorage() throws IOException {
        Options options = new Options();
        Path dbPath = new Path(this.getConfig().get("yarn.timeline-service.leveldb-state-store.path"), DB_NAME);
        LocalFileSystem localFS = null;
        try {
            localFS = FileSystem.getLocal((Configuration)this.getConfig());
            if (!localFS.exists(dbPath)) {
                if (!localFS.mkdirs(dbPath)) {
                    throw new IOException("Couldn't create directory for leveldb timeline store " + dbPath);
                }
                localFS.setPermission(dbPath, LEVELDB_DIR_UMASK);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
        JniDBFactory factory = new JniDBFactory();
        try {
            options.createIfMissing(false);
            this.db = factory.open(new File(dbPath.toString()), options);
            LOG.info("Loading the existing database at th path: " + dbPath.toString());
            this.checkVersion();
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                try {
                    options.createIfMissing(true);
                    this.db = factory.open(new File(dbPath.toString()), options);
                    LOG.info("Creating a new database at th path: " + dbPath.toString());
                    this.storeVersion(CURRENT_VERSION_INFO);
                }
                catch (DBException ex) {
                    throw new IOException(ex);
                }
            }
            throw new IOException(e);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void closeStorage() throws IOException {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.db});
    }

    @Override
    public TimelineStateStore.TimelineServiceState loadState() throws IOException {
        LOG.info("Loading timeline service state from leveldb");
        TimelineStateStore.TimelineServiceState state = new TimelineStateStore.TimelineServiceState();
        int numKeys = this.loadTokenMasterKeys(state);
        int numTokens = this.loadTokens(state);
        this.loadLatestSequenceNumber(state);
        LOG.info("Loaded " + numKeys + " master keys and " + numTokens + " tokens from leveldb, and latest sequence number is " + state.getLatestSequenceNumber());
        return state;
    }

    @Override
    public void storeToken(TimelineDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        DataOutputStream ds = null;
        WriteBatch batch = null;
        try {
            byte[] k = LeveldbTimelineStateStore.createTokenEntryKey(tokenId.getSequenceNumber());
            if (this.db.get(k) != null) {
                throw new IOException(tokenId + " already exists");
            }
            byte[] v = LeveldbTimelineStateStore.buildTokenData(tokenId, renewDate);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ds = new DataOutputStream(bs);
            ds.writeInt(tokenId.getSequenceNumber());
            batch = this.db.createWriteBatch();
            batch.put(k, v);
            batch.put(LATEST_SEQUENCE_NUMBER_KEY, bs.toByteArray());
            this.db.write(batch);
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{ds});
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{batch});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{ds});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{batch});
    }

    @Override
    public void updateToken(TimelineDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        try {
            byte[] k = LeveldbTimelineStateStore.createTokenEntryKey(tokenId.getSequenceNumber());
            if (this.db.get(k) == null) {
                throw new IOException(tokenId + " doesn't exist");
            }
            byte[] v = LeveldbTimelineStateStore.buildTokenData(tokenId, renewDate);
            this.db.put(k, v);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeToken(TimelineDelegationTokenIdentifier tokenId) throws IOException {
        try {
            byte[] key = LeveldbTimelineStateStore.createTokenEntryKey(tokenId.getSequenceNumber());
            this.db.delete(key);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void storeTokenMasterKey(DelegationKey key) throws IOException {
        try {
            byte[] k = LeveldbTimelineStateStore.createTokenMasterKeyEntryKey(key.getKeyId());
            if (this.db.get(k) != null) {
                throw new IOException(key + " already exists");
            }
            byte[] v = LeveldbTimelineStateStore.buildTokenMasterKeyData(key);
            this.db.put(k, v);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeTokenMasterKey(DelegationKey key) throws IOException {
        try {
            byte[] k = LeveldbTimelineStateStore.createTokenMasterKeyEntryKey(key.getKeyId());
            this.db.delete(k);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    private static byte[] buildTokenData(TimelineDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        TimelineDelegationTokenIdentifierData data = new TimelineDelegationTokenIdentifierData(tokenId, renewDate);
        return data.toByteArray();
    }

    private static byte[] buildTokenMasterKeyData(DelegationKey key) throws IOException {
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(memStream);
        try {
            key.write((DataOutput)dataStream);
            dataStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{dataStream});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{dataStream});
        return memStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTokenMasterKeyData(TimelineStateStore.TimelineServiceState state, byte[] keyData) throws IOException {
        DelegationKey key = new DelegationKey();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(keyData));
        try {
            key.readFields((DataInput)in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        state.tokenMasterKeyState.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTokenData(TimelineStateStore.TimelineServiceState state, byte[] tokenData) throws IOException {
        TimelineDelegationTokenIdentifierData data = new TimelineDelegationTokenIdentifierData();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(tokenData));
        try {
            data.readFields(in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        state.tokenState.put(data.getTokenIdentifier(), data.getRenewDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadTokenMasterKeys(TimelineStateStore.TimelineServiceState state) throws IOException {
        byte[] base = LeveldbUtils.KeyBuilder.newInstance().add(TOKEN_MASTER_KEY_ENTRY_PREFIX).getBytesForLookup();
        int numKeys = 0;
        LeveldbIterator iterator = null;
        try {
            byte[] k;
            iterator = new LeveldbIterator(this.db);
            iterator.seek(base);
            while (iterator.hasNext() && LeveldbUtils.prefixMatches(base, base.length, k = iterator.peekNext().getKey())) {
                byte[] v = iterator.peekNext().getValue();
                LeveldbTimelineStateStore.loadTokenMasterKeyData(state, v);
                ++numKeys;
                iterator.next();
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
        return numKeys;
    }

    private int loadTokens(TimelineStateStore.TimelineServiceState state) throws IOException {
        byte[] base = LeveldbUtils.KeyBuilder.newInstance().add(TOKEN_ENTRY_PREFIX).getBytesForLookup();
        int numTokens = 0;
        LeveldbIterator iterator = null;
        try {
            byte[] k;
            iterator = new LeveldbIterator(this.db);
            iterator.seek(base);
            while (iterator.hasNext() && LeveldbUtils.prefixMatches(base, base.length, k = iterator.peekNext().getKey())) {
                byte[] v = iterator.peekNext().getValue();
                LeveldbTimelineStateStore.loadTokenData(state, v);
                ++numTokens;
                iterator.next();
            }
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{iterator});
        return numTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLatestSequenceNumber(TimelineStateStore.TimelineServiceState state) throws IOException {
        byte[] data = null;
        try {
            data = this.db.get(LATEST_SEQUENCE_NUMBER_KEY);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data != null) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            try {
                state.latestSequenceNumber = in.readInt();
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        }
    }

    private static byte[] createTokenEntryKey(int seqNum) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(TOKEN_ENTRY_PREFIX).add(Integer.toString(seqNum)).getBytes();
    }

    private static byte[] createTokenMasterKeyEntryKey(int keyId) throws IOException {
        return LeveldbUtils.KeyBuilder.newInstance().add(TOKEN_MASTER_KEY_ENTRY_PREFIX).add(Integer.toString(keyId)).getBytes();
    }

    @VisibleForTesting
    Version loadVersion() throws IOException {
        try {
            byte[] data = this.db.get(TIMELINE_STATE_STORE_VERSION_KEY);
            if (data == null || data.length == 0) {
                return this.getCurrentVersion();
            }
            VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom(data));
            return version;
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    void storeVersion(Version state) throws IOException {
        byte[] data = ((VersionPBImpl)state).getProto().toByteArray();
        try {
            this.db.put(TIMELINE_STATE_STORE_VERSION_KEY, data);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private void checkVersion() throws IOException {
        Version loadedVersion = this.loadVersion();
        LOG.info("Loaded timeline state store version info " + loadedVersion);
        if (loadedVersion.equals(this.getCurrentVersion())) {
            return;
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            String incompatibleMessage = "Incompatible version for timeline state store: expecting version " + this.getCurrentVersion() + ", but loading version " + loadedVersion;
            LOG.error(incompatibleMessage);
            throw new IOException(incompatibleMessage);
        }
        LOG.info("Storing timeline state store version info " + this.getCurrentVersion());
        this.storeVersion(CURRENT_VERSION_INFO);
    }
}

