/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.cli;

import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.shaded.org.apache.commons.cli.PosixParser;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliParseException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliWrapperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.MalformedPathException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.StatPrinter;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.Stat;

public class GetCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetCommand() {
        super("get", "[-s] [-w] path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws CliParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'get path [watch]' has been deprecated. Please use 'get [-s] [-w] path' instead.");
            PosixParser parser = new PosixParser();
            try {
                this.cl = parser.parse(options, cmdArgs);
            }
            catch (ParseException ex) {
                throw new CliParseException(ex);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        byte[] data;
        boolean watch = this.cl.hasOption("w");
        String path = this.args[1];
        Stat stat = new Stat();
        try {
            data = this.zk.getData(path, watch, stat);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        data = data == null ? "null".getBytes() : data;
        this.out.println(new String(data));
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return watch;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("w", false, "watch");
    }
}

