/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.VolumeScanner;
import org.apache.hadoop.hdfs.server.datanode.checker.DatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.ThrottledAsyncChecker;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.top.metrics.TopMetrics;
import org.apache.hadoop.http.HttpRequestLog;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.GSet;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotTestHelper {
    static final Logger LOG = LoggerFactory.getLogger(SnapshotTestHelper.class);

    public static void disableLogs() {
        String[] lognames;
        for (String n : lognames = new String[]{"org.apache.hadoop.hdfs.server.common.Util", "org.apache.hadoop.hdfs.server.blockmanagement.BlockReportLeaseManager", "org.apache.hadoop.hdfs.server.namenode.FileJournalManager", "org.apache.hadoop.hdfs.server.namenode.NNStorageRetentionManager", "org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf", "org.apache.hadoop.hdfs.server.namenode.FSEditLog", "org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceScanner", "org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice", "org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl", "org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetAsyncDiskService", "org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskAsyncLazyPersistService"}) {
            GenericTestUtils.disableLog(LoggerFactory.getLogger((String)n));
        }
        GenericTestUtils.disableLog(LoggerFactory.getLogger(UserGroupInformation.class));
        GenericTestUtils.disableLog(LoggerFactory.getLogger(BlockManager.class));
        GenericTestUtils.disableLog(LoggerFactory.getLogger(FSNamesystem.class));
        GenericTestUtils.disableLog(LoggerFactory.getLogger(DirectoryScanner.class));
        GenericTestUtils.disableLog(LoggerFactory.getLogger(MetricsSystemImpl.class));
        GenericTestUtils.disableLog(DatasetVolumeChecker.LOG);
        GenericTestUtils.disableLog(DatanodeDescriptor.LOG);
        GenericTestUtils.disableLog(GSet.LOG);
        GenericTestUtils.disableLog(TopMetrics.LOG);
        GenericTestUtils.disableLog(HttpRequestLog.LOG);
        GenericTestUtils.disableLog(ThrottledAsyncChecker.LOG);
        GenericTestUtils.disableLog(VolumeScanner.LOG);
        GenericTestUtils.disableLog(BlockScanner.LOG);
        GenericTestUtils.disableLog(HttpServer2.LOG);
        GenericTestUtils.disableLog(DataNode.LOG);
        GenericTestUtils.disableLog(BlockPoolSliceStorage.LOG);
        GenericTestUtils.disableLog(LeaseManager.LOG);
        GenericTestUtils.disableLog(NameNode.stateChangeLog);
        GenericTestUtils.disableLog(NameNode.blockStateChangeLog);
        GenericTestUtils.disableLog(DFSClient.LOG);
        GenericTestUtils.disableLog(ProtobufRpcEngine2.Server.LOG);
    }

    private SnapshotTestHelper() {
    }

    public static Path getSnapshotRoot(Path snapshottedDir, String snapshotName) {
        return new Path(snapshottedDir, ".snapshot/" + snapshotName);
    }

    public static Path getSnapshotPath(Path snapshottedDir, String snapshotName, String fileLocalName) {
        return new Path(SnapshotTestHelper.getSnapshotRoot(snapshottedDir, snapshotName), fileLocalName);
    }

    public static Path createSnapshot(DistributedFileSystem hdfs, Path snapshotRoot, String snapshotName) throws Exception {
        LOG.info("createSnapshot " + snapshotName + " for " + snapshotRoot);
        Assert.assertTrue((boolean)hdfs.exists(snapshotRoot));
        hdfs.allowSnapshot(snapshotRoot);
        hdfs.createSnapshot(snapshotRoot, snapshotName);
        hdfs.setQuota(snapshotRoot, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        return SnapshotTestHelper.getSnapshotRoot(snapshotRoot, snapshotName);
    }

    public static void checkSnapshotCreation(DistributedFileSystem hdfs, Path snapshotRoot, Path snapshottedDir) throws Exception {
        Assert.assertTrue((boolean)hdfs.exists(snapshotRoot));
        FileStatus[] currentFiles = hdfs.listStatus(snapshottedDir);
        FileStatus[] snapshotFiles = hdfs.listStatus(snapshotRoot);
        Assert.assertEquals((String)("snapshottedDir=" + snapshottedDir + ", snapshotRoot=" + snapshotRoot), (long)currentFiles.length, (long)snapshotFiles.length);
    }

    public static void compareDumpedTreeInFile(File file1, File file2, boolean compareQuota) throws IOException {
        try {
            SnapshotTestHelper.compareDumpedTreeInFile(file1, file2, compareQuota, false);
        }
        catch (Throwable t) {
            LOG.info("FAILED compareDumpedTreeInFile(" + file1 + ", " + file2 + ")", t);
            SnapshotTestHelper.compareDumpedTreeInFile(file1, file2, compareQuota, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compareDumpedTreeInFile(File file1, File file2, boolean compareQuota, boolean print) throws IOException {
        if (print) {
            SnapshotTestHelper.printFile(file1);
            SnapshotTestHelper.printFile(file2);
        }
        BufferedReader reader1 = new BufferedReader(new FileReader(file1));
        BufferedReader reader2 = new BufferedReader(new FileReader(file2));
        try {
            String line1 = "";
            String line2 = "";
            while ((line1 = reader1.readLine()) != null && (line2 = reader2.readLine()) != null) {
                if (print) {
                    System.out.println();
                    System.out.println("1) " + line1);
                    System.out.println("2) " + line2);
                }
                line1 = line1.replaceAll("INodeFileWithSnapshot", "INodeFile");
                line2 = line2.replaceAll("INodeFileWithSnapshot", "INodeFile");
                line1 = line1.replaceAll("@[\\dabcdef]+", "");
                line2 = line2.replaceAll("@[\\dabcdef]+", "");
                line1 = line1.replaceAll("replicas=\\[.*\\]", "replicas=[]");
                line2 = line2.replaceAll("replicas=\\[.*\\]", "replicas=[]");
                if (!compareQuota) {
                    line1 = line1.replaceAll("Quota\\[.*\\]", "Quota[]");
                    line2 = line2.replaceAll("Quota\\[.*\\]", "Quota[]");
                }
                if (line1.contains("(INodeFileSnapshot)") || line1.contains("(INodeFileUnderConstructionSnapshot)")) {
                    line1 = line1.replaceAll("\\{blockUCState=\\w+, primaryNodeIndex=[-\\d]+, replicas=\\[\\]\\}", "");
                    line2 = line2.replaceAll("\\{blockUCState=\\w+, primaryNodeIndex=[-\\d]+, replicas=\\[\\]\\}", "");
                }
                Assert.assertEquals((Object)line1.trim(), (Object)line2.trim());
            }
            Assert.assertNull((Object)reader1.readLine());
            Assert.assertNull((Object)reader2.readLine());
        }
        finally {
            reader1.close();
            reader2.close();
        }
    }

    static void printFile(File f) throws IOException {
        System.out.println();
        System.out.println("File: " + f);
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
    }

    public static void dumpTree2File(FSDirectory fsdir, File f) throws IOException {
        PrintWriter out = new PrintWriter((Writer)new FileWriter(f, false), true);
        fsdir.getINode("/").dumpTreeRecursively(out, new StringBuilder(), 0x7FFFFFFE);
        out.close();
    }

    static Path getSnapshotFile(Path snapshotRoot, Path file) {
        Path rootParent = snapshotRoot.getParent();
        if (rootParent != null && rootParent.getName().equals(".snapshot")) {
            Path snapshotDir = rootParent.getParent();
            if (file.toString().contains(snapshotDir.toString()) && !file.equals((Object)snapshotDir)) {
                String fileName = file.toString().substring(snapshotDir.toString().length() + 1);
                Path snapshotFile = new Path(snapshotRoot, fileName);
                return snapshotFile;
            }
        }
        return null;
    }

    public static void dumpTree(String message, MiniDFSCluster cluster) throws UnresolvedLinkException {
        System.out.println("XXX " + message);
        try {
            cluster.getNameNode().getNamesystem().getFSDirectory().getINode("/").dumpTreeRecursively(System.out);
        }
        catch (UnresolvedLinkException ule) {
            throw ule;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static class TestDirectoryTree {
        final int height;
        final Node topNode;
        final Map<Integer, ArrayList<Node>> levelMap;
        int id = 0;

        TestDirectoryTree(int height, FileSystem fs) throws Exception {
            this.height = height;
            this.topNode = new Node(new Path("/TestSnapshot"), 0, null, fs);
            this.levelMap = new HashMap<Integer, ArrayList<Node>>();
            this.addDirNode(this.topNode, 0);
            this.genChildren(this.topNode, height - 1, fs);
        }

        private void addDirNode(Node node, int atLevel) {
            ArrayList<Node> list = this.levelMap.get(atLevel);
            if (list == null) {
                list = new ArrayList();
                this.levelMap.put(atLevel, list);
            }
            list.add(node);
        }

        private void genChildren(Node parent, int level, FileSystem fs) throws Exception {
            if (level == 0) {
                return;
            }
            parent.leftChild = new Node(new Path(parent.nodePath, "left" + ++this.id), this.height - level, parent, fs);
            parent.rightChild = new Node(new Path(parent.nodePath, "right" + ++this.id), this.height - level, parent, fs);
            this.addDirNode(parent.leftChild, parent.leftChild.level);
            this.addDirNode(parent.rightChild, parent.rightChild.level);
            this.genChildren(parent.leftChild, level - 1, fs);
            this.genChildren(parent.rightChild, level - 1, fs);
        }

        Node getRandomDirNode(Random random, List<Node> excludedList) {
            Node randomNode;
            do {
                int level = random.nextInt(this.height);
                ArrayList<Node> levelList = this.levelMap.get(level);
                int index = random.nextInt(levelList.size());
                randomNode = levelList.get(index);
            } while (excludedList != null && excludedList.contains(randomNode));
            return randomNode;
        }

        static class Node {
            final int level;
            Node leftChild;
            Node rightChild;
            final Node parent;
            final Path nodePath;
            ArrayList<Path> fileList;
            int nullFileIndex = 0;
            final ArrayList<Node> nonSnapshotChildren;

            Node(Path path, int level, Node parent, FileSystem fs) throws Exception {
                this.nodePath = path;
                this.level = level;
                this.parent = parent;
                this.nonSnapshotChildren = new ArrayList();
                fs.mkdirs(this.nodePath);
            }

            void initFileList(FileSystem fs, String namePrefix, long fileLen, short replication, long seed, int numFiles) throws Exception {
                this.fileList = new ArrayList(numFiles);
                for (int i = 0; i < numFiles; ++i) {
                    Path file = new Path(this.nodePath, namePrefix + "-f" + i);
                    this.fileList.add(file);
                    if (i >= numFiles - 1) continue;
                    DFSTestUtil.createFile(fs, file, fileLen, replication, seed);
                }
                this.nullFileIndex = numFiles - 1;
            }

            public boolean equals(Object o) {
                if (o != null && o instanceof Node) {
                    Node node = (Node)o;
                    return node.nodePath.equals((Object)this.nodePath);
                }
                return false;
            }

            public int hashCode() {
                return this.nodePath.hashCode();
            }
        }
    }
}

