/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.net.InetAddress;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMetrics;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreRecordOperations;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateStoreDriver
implements StateStoreRecordOperations {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreDriver.class);
    private Configuration conf;
    private String identifier;
    private StateStoreMetrics metrics;

    public boolean init(Configuration config, String id, Collection<Class<? extends BaseRecord>> records, StateStoreMetrics stateStoreMetrics) {
        boolean success;
        this.conf = config;
        this.identifier = id;
        this.metrics = stateStoreMetrics;
        if (this.identifier == null) {
            LOG.warn("The identifier for the State Store connection is not set");
        }
        if (!(success = this.initDriver())) {
            LOG.error("Cannot initialize driver for {}", (Object)this.getDriverName());
            return false;
        }
        for (Class<? extends BaseRecord> cls : records) {
            String recordString = StateStoreUtils.getRecordName(cls);
            if (this.initRecordStorage(recordString, cls)) continue;
            LOG.error("Cannot initialize record store for {}", (Object)cls.getSimpleName());
            return false;
        }
        return true;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public StateStoreMetrics getMetrics() {
        return this.metrics;
    }

    public abstract boolean initDriver();

    public abstract <T extends BaseRecord> boolean initRecordStorage(String var1, Class<T> var2);

    public abstract boolean isDriverReady();

    public void verifyDriverReady() throws StateStoreUnavailableException {
        if (!this.isDriverReady()) {
            String driverName = this.getDriverName();
            String hostname = this.getHostname();
            throw new StateStoreUnavailableException("State Store driver " + driverName + " in " + hostname + " is not ready.");
        }
    }

    public abstract void close() throws Exception;

    public long getTime() {
        return Time.now();
    }

    private String getDriverName() {
        return this.getClass().getSimpleName();
    }

    private String getHostname() {
        String hostname = "Unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.error("Cannot get local address", (Throwable)e);
        }
        return hostname;
    }
}

