/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.PeriodicService;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterMetrics;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterSafemodeService
extends PeriodicService {
    private static final Logger LOG = LoggerFactory.getLogger(RouterSafemodeService.class);
    private final Router router;
    private volatile boolean safeMode;
    private volatile boolean isSafeModeSetManually;
    private long startupInterval;
    private long staleInterval;
    private long startupTime;
    private long enterSafeModeTime = Time.now();

    public RouterSafemodeService(Router router) {
        super(RouterSafemodeService.class.getSimpleName());
        this.router = router;
    }

    boolean isInSafeMode() {
        return this.safeMode;
    }

    void setManualSafeMode(boolean mode) {
        this.safeMode = mode;
        this.isSafeModeSetManually = mode;
    }

    private void enter() {
        LOG.info("Entering safe mode");
        this.enterSafeModeTime = Time.now();
        this.safeMode = true;
        this.router.updateRouterState(RouterServiceState.SAFEMODE);
    }

    private void leave() {
        long timeInSafemode = Time.now() - this.enterSafeModeTime;
        LOG.info("Leaving safe mode after {} milliseconds", (Object)timeInSafemode);
        RouterMetrics routerMetrics = this.router.getRouterMetrics();
        if (routerMetrics == null) {
            LOG.error("The Router metrics are not enabled");
        } else {
            routerMetrics.setSafeModeTime(timeInSafemode);
        }
        this.safeMode = false;
        this.router.updateRouterState(RouterServiceState.RUNNING);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.setIntervalMs(conf.getTimeDuration("dfs.federation.router.cache.ttl", RBFConfigKeys.DFS_ROUTER_CACHE_TIME_TO_LIVE_MS_DEFAULT, TimeUnit.MILLISECONDS));
        this.startupInterval = conf.getTimeDuration("dfs.federation.router.safemode.extension", RBFConfigKeys.DFS_ROUTER_SAFEMODE_EXTENSION_DEFAULT, TimeUnit.MILLISECONDS);
        LOG.info("Leave startup safe mode after {} ms", (Object)this.startupInterval);
        this.staleInterval = conf.getTimeDuration("dfs.federation.router.safemode.expiration", RBFConfigKeys.DFS_ROUTER_SAFEMODE_EXPIRATION_DEFAULT, TimeUnit.MILLISECONDS);
        LOG.info("Enter safe mode after {} ms without reaching the State Store", (Object)this.staleInterval);
        this.startupTime = Time.now();
        this.enter();
        super.serviceInit(conf);
    }

    @Override
    public void periodicInvoke() {
        boolean isCacheStale;
        long now = Time.now();
        long delta = now - this.startupTime;
        if (delta < this.startupInterval) {
            LOG.info("Delaying safemode exit for {} milliseconds...", (Object)(this.startupInterval - delta));
            return;
        }
        StateStoreService stateStore = this.router.getStateStore();
        long cacheUpdateTime = stateStore.getCacheUpdateTime();
        boolean bl = isCacheStale = now - cacheUpdateTime > this.staleInterval;
        if (isCacheStale) {
            if (!this.safeMode) {
                this.enter();
            }
        } else if (this.safeMode && !this.isSafeModeSetManually) {
            this.leave();
        }
    }
}

