/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockChecksumType;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockECReconstructionCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.thirdparty.protobuf.UninitializedMessageException;
import org.apache.hadoop.util.DataChecksum;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestPBHelper {
    private static final double DELTA = 1.0E-6;

    @Test
    public void testGetByteString() {
        Assert.assertSame((Object)ByteString.EMPTY, (Object)PBHelperClient.getByteString((byte[])new byte[0]));
    }

    @Test
    public void testConvertNamenodeRole() {
        Assert.assertEquals((Object)HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.BACKUP));
        Assert.assertEquals((Object)HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.CHECKPOINT));
        Assert.assertEquals((Object)HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.BACKUP, (Object)PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.CHECKPOINT, (Object)PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.NAMENODE, (Object)PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsServerProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE));
    }

    private static StorageInfo getStorageInfo(HdfsServerConstants.NodeType type) {
        return new StorageInfo(1, 2, "cid", 3L, type);
    }

    @Test
    public void testConvertStoragInfo() {
        StorageInfo info = TestPBHelper.getStorageInfo(HdfsServerConstants.NodeType.NAME_NODE);
        HdfsServerProtos.StorageInfoProto infoProto = PBHelper.convert((StorageInfo)info);
        StorageInfo info2 = PBHelper.convert((HdfsServerProtos.StorageInfoProto)infoProto, (HdfsServerConstants.NodeType)HdfsServerConstants.NodeType.NAME_NODE);
        Assert.assertEquals((Object)info.getClusterID(), (Object)info2.getClusterID());
        Assert.assertEquals((long)info.getCTime(), (long)info2.getCTime());
        Assert.assertEquals((long)info.getLayoutVersion(), (long)info2.getLayoutVersion());
        Assert.assertEquals((long)info.getNamespaceID(), (long)info2.getNamespaceID());
    }

    @Test
    public void testConvertNamenodeRegistration() {
        StorageInfo info = TestPBHelper.getStorageInfo(HdfsServerConstants.NodeType.NAME_NODE);
        NamenodeRegistration reg = new NamenodeRegistration("address:999", "http:1000", info, HdfsServerConstants.NamenodeRole.NAMENODE);
        HdfsServerProtos.NamenodeRegistrationProto regProto = PBHelper.convert((NamenodeRegistration)reg);
        NamenodeRegistration reg2 = PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto)regProto);
        Assert.assertEquals((Object)reg.getAddress(), (Object)reg2.getAddress());
        Assert.assertEquals((Object)reg.getClusterID(), (Object)reg2.getClusterID());
        Assert.assertEquals((long)reg.getCTime(), (long)reg2.getCTime());
        Assert.assertEquals((Object)reg.getHttpAddress(), (Object)reg2.getHttpAddress());
        Assert.assertEquals((long)reg.getLayoutVersion(), (long)reg2.getLayoutVersion());
        Assert.assertEquals((long)reg.getNamespaceID(), (long)reg2.getNamespaceID());
        Assert.assertEquals((Object)reg.getRegistrationID(), (Object)reg2.getRegistrationID());
        Assert.assertEquals((Object)reg.getRole(), (Object)reg2.getRole());
        Assert.assertEquals((long)reg.getVersion(), (long)reg2.getVersion());
    }

    @Test
    public void testConvertDatanodeID() {
        DatanodeID dn = DFSTestUtil.getLocalDatanodeID();
        HdfsProtos.DatanodeIDProto dnProto = PBHelperClient.convert((DatanodeID)dn);
        DatanodeID dn2 = PBHelperClient.convert((HdfsProtos.DatanodeIDProto)dnProto);
        this.compare(dn, dn2);
    }

    void compare(DatanodeID dn, DatanodeID dn2) {
        Assert.assertEquals((Object)dn.getIpAddr(), (Object)dn2.getIpAddr());
        Assert.assertEquals((Object)dn.getHostName(), (Object)dn2.getHostName());
        Assert.assertEquals((Object)dn.getDatanodeUuid(), (Object)dn2.getDatanodeUuid());
        Assert.assertEquals((long)dn.getXferPort(), (long)dn2.getXferPort());
        Assert.assertEquals((long)dn.getInfoPort(), (long)dn2.getInfoPort());
        Assert.assertEquals((long)dn.getIpcPort(), (long)dn2.getIpcPort());
    }

    void compare(DatanodeStorage dns1, DatanodeStorage dns2) {
        Assert.assertThat((Object)dns2.getStorageID(), (Matcher)CoreMatchers.is((Object)dns1.getStorageID()));
        Assert.assertThat((Object)dns2.getState(), (Matcher)CoreMatchers.is((Object)dns1.getState()));
        Assert.assertThat((Object)dns2.getStorageType(), (Matcher)CoreMatchers.is((Object)dns1.getStorageType()));
    }

    @Test
    public void testConvertBlock() {
        Block b = new Block(1L, 100L, 3L);
        HdfsProtos.BlockProto bProto = PBHelperClient.convert((Block)b);
        Block b2 = PBHelperClient.convert((HdfsProtos.BlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b2);
    }

    @Test
    public void testConvertBlockType() {
        BlockType bContiguous = BlockType.CONTIGUOUS;
        HdfsProtos.BlockTypeProto bContiguousProto = PBHelperClient.convert((BlockType)bContiguous);
        BlockType bContiguous2 = PBHelperClient.convert((HdfsProtos.BlockTypeProto)bContiguousProto);
        Assert.assertEquals((Object)bContiguous, (Object)bContiguous2);
        BlockType bStriped = BlockType.STRIPED;
        HdfsProtos.BlockTypeProto bStripedProto = PBHelperClient.convert((BlockType)bStriped);
        BlockType bStriped2 = PBHelperClient.convert((HdfsProtos.BlockTypeProto)bStripedProto);
        Assert.assertEquals((Object)bStriped, (Object)bStriped2);
    }

    private static BlocksWithLocations.BlockWithLocations getBlockWithLocations(int bid, boolean isStriped) {
        String[] datanodeUuids = new String[]{"dn1", "dn2", "dn3"};
        String[] storageIDs = new String[]{"s1", "s2", "s3"};
        StorageType[] storageTypes = new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK};
        byte[] indices = new byte[]{0, 1, 2};
        int dataBlkNum = 6;
        BlocksWithLocations.BlockWithLocations blkLocs = new BlocksWithLocations.BlockWithLocations(new Block((long)bid, 0L, 1L), datanodeUuids, storageIDs, storageTypes);
        if (isStriped) {
            blkLocs = new BlocksWithLocations.StripedBlockWithLocations(blkLocs, indices, 6, StripedFileTestUtil.getDefaultECPolicy().getCellSize());
        }
        return blkLocs;
    }

    private void compare(BlocksWithLocations.BlockWithLocations locs1, BlocksWithLocations.BlockWithLocations locs2) {
        Assert.assertEquals((Object)locs1.getBlock(), (Object)locs2.getBlock());
        Assert.assertTrue((boolean)Arrays.equals(locs1.getStorageIDs(), locs2.getStorageIDs()));
        if (locs1 instanceof BlocksWithLocations.StripedBlockWithLocations) {
            Assert.assertTrue((boolean)Arrays.equals(((BlocksWithLocations.StripedBlockWithLocations)locs1).getIndices(), ((BlocksWithLocations.StripedBlockWithLocations)locs2).getIndices()));
        }
    }

    @Test
    public void testConvertBlockWithLocations() {
        boolean[] testSuite = new boolean[]{false, true};
        for (int i = 0; i < testSuite.length; ++i) {
            BlocksWithLocations.BlockWithLocations locs = TestPBHelper.getBlockWithLocations(1, testSuite[i]);
            HdfsServerProtos.BlockWithLocationsProto locsProto = PBHelper.convert((BlocksWithLocations.BlockWithLocations)locs);
            BlocksWithLocations.BlockWithLocations locs2 = PBHelper.convert((HdfsServerProtos.BlockWithLocationsProto)locsProto);
            this.compare(locs, locs2);
        }
    }

    @Test
    public void testConvertBlocksWithLocations() {
        boolean[] testSuite = new boolean[]{false, true};
        for (int i = 0; i < testSuite.length; ++i) {
            BlocksWithLocations.BlockWithLocations[] list = new BlocksWithLocations.BlockWithLocations[]{TestPBHelper.getBlockWithLocations(1, testSuite[i]), TestPBHelper.getBlockWithLocations(2, testSuite[i])};
            BlocksWithLocations locs = new BlocksWithLocations(list);
            HdfsServerProtos.BlocksWithLocationsProto locsProto = PBHelper.convert((BlocksWithLocations)locs);
            BlocksWithLocations locs2 = PBHelper.convert((HdfsServerProtos.BlocksWithLocationsProto)locsProto);
            BlocksWithLocations.BlockWithLocations[] blocks = locs.getBlocks();
            BlocksWithLocations.BlockWithLocations[] blocks2 = locs2.getBlocks();
            Assert.assertEquals((long)blocks.length, (long)blocks2.length);
            for (int j = 0; j < blocks.length; ++j) {
                this.compare(blocks[j], blocks2[j]);
            }
        }
    }

    private static BlockKey getBlockKey(int keyId) {
        return new BlockKey(keyId, 10L, "encodedKey".getBytes());
    }

    private void compare(BlockKey k1, BlockKey k2) {
        Assert.assertEquals((long)k1.getExpiryDate(), (long)k2.getExpiryDate());
        Assert.assertEquals((long)k1.getKeyId(), (long)k2.getKeyId());
        Assert.assertTrue((boolean)Arrays.equals(k1.getEncodedKey(), k2.getEncodedKey()));
    }

    @Test
    public void testConvertBlockKey() {
        BlockKey key = TestPBHelper.getBlockKey(1);
        HdfsServerProtos.BlockKeyProto keyProto = PBHelper.convert((BlockKey)key);
        BlockKey key1 = PBHelper.convert((HdfsServerProtos.BlockKeyProto)keyProto);
        this.compare(key, key1);
    }

    @Test
    public void testConvertExportedBlockKeys() {
        BlockKey[] keys = new BlockKey[]{TestPBHelper.getBlockKey(2), TestPBHelper.getBlockKey(3)};
        ExportedBlockKeys expKeys = new ExportedBlockKeys(true, 9L, 10L, TestPBHelper.getBlockKey(1), keys);
        HdfsServerProtos.ExportedBlockKeysProto expKeysProto = PBHelper.convert((ExportedBlockKeys)expKeys);
        ExportedBlockKeys expKeys1 = PBHelper.convert((HdfsServerProtos.ExportedBlockKeysProto)expKeysProto);
        this.compare(expKeys, expKeys1);
    }

    void compare(ExportedBlockKeys expKeys, ExportedBlockKeys expKeys1) {
        BlockKey[] allKeys = expKeys.getAllKeys();
        BlockKey[] allKeys1 = expKeys1.getAllKeys();
        Assert.assertEquals((long)allKeys.length, (long)allKeys1.length);
        for (int i = 0; i < allKeys.length; ++i) {
            this.compare(allKeys[i], allKeys1[i]);
        }
        this.compare(expKeys.getCurrentKey(), expKeys1.getCurrentKey());
        Assert.assertEquals((long)expKeys.getKeyUpdateInterval(), (long)expKeys1.getKeyUpdateInterval());
        Assert.assertEquals((long)expKeys.getTokenLifetime(), (long)expKeys1.getTokenLifetime());
    }

    @Test
    public void testConvertCheckpointSignature() {
        CheckpointSignature s = new CheckpointSignature(TestPBHelper.getStorageInfo(HdfsServerConstants.NodeType.NAME_NODE), "bpid", 100L, 1L);
        HdfsServerProtos.CheckpointSignatureProto sProto = PBHelper.convert((CheckpointSignature)s);
        CheckpointSignature s1 = PBHelper.convert((HdfsServerProtos.CheckpointSignatureProto)sProto);
        Assert.assertEquals((Object)s.getBlockpoolID(), (Object)s1.getBlockpoolID());
        Assert.assertEquals((Object)s.getClusterID(), (Object)s1.getClusterID());
        Assert.assertEquals((long)s.getCTime(), (long)s1.getCTime());
        Assert.assertEquals((long)s.getCurSegmentTxId(), (long)s1.getCurSegmentTxId());
        Assert.assertEquals((long)s.getLayoutVersion(), (long)s1.getLayoutVersion());
        Assert.assertEquals((long)s.getMostRecentCheckpointTxId(), (long)s1.getMostRecentCheckpointTxId());
        Assert.assertEquals((long)s.getNamespaceID(), (long)s1.getNamespaceID());
    }

    private static void compare(RemoteEditLog l1, RemoteEditLog l2) {
        Assert.assertEquals((long)l1.getEndTxId(), (long)l2.getEndTxId());
        Assert.assertEquals((long)l1.getStartTxId(), (long)l2.getStartTxId());
    }

    @Test
    public void testConvertRemoteEditLog() {
        RemoteEditLog l = new RemoteEditLog(1L, 100L);
        HdfsServerProtos.RemoteEditLogProto lProto = PBHelper.convert((RemoteEditLog)l);
        RemoteEditLog l1 = PBHelper.convert((HdfsServerProtos.RemoteEditLogProto)lProto);
        TestPBHelper.compare(l, l1);
    }

    private void convertAndCheckRemoteEditLogManifest(RemoteEditLogManifest m, List<RemoteEditLog> logs, long committedTxnId) {
        HdfsServerProtos.RemoteEditLogManifestProto mProto = PBHelper.convert((RemoteEditLogManifest)m);
        RemoteEditLogManifest m1 = PBHelper.convert((HdfsServerProtos.RemoteEditLogManifestProto)mProto);
        List logs1 = m1.getLogs();
        Assert.assertEquals((long)logs.size(), (long)logs1.size());
        for (int i = 0; i < logs.size(); ++i) {
            TestPBHelper.compare(logs.get(i), (RemoteEditLog)logs1.get(i));
        }
        Assert.assertEquals((long)committedTxnId, (long)m.getCommittedTxnId());
    }

    @Test
    public void testConvertRemoteEditLogManifest() {
        ArrayList<RemoteEditLog> logs = new ArrayList<RemoteEditLog>();
        logs.add(new RemoteEditLog(1L, 10L));
        logs.add(new RemoteEditLog(11L, 20L));
        this.convertAndCheckRemoteEditLogManifest(new RemoteEditLogManifest(logs, 20L), logs, 20L);
        this.convertAndCheckRemoteEditLogManifest(new RemoteEditLogManifest(logs), logs, -12345L);
    }

    public ExtendedBlock getExtendedBlock() {
        return this.getExtendedBlock(1L);
    }

    public ExtendedBlock getExtendedBlock(long blkid) {
        return new ExtendedBlock("bpid", blkid, 100L, 2L);
    }

    private void compare(DatanodeInfo dn1, DatanodeInfo dn2) {
        Assert.assertEquals((Object)dn1.getAdminState(), (Object)dn2.getAdminState());
        Assert.assertEquals((long)dn1.getBlockPoolUsed(), (long)dn2.getBlockPoolUsed());
        Assert.assertEquals((double)dn1.getBlockPoolUsedPercent(), (double)dn2.getBlockPoolUsedPercent(), (double)1.0E-6);
        Assert.assertEquals((long)dn1.getCapacity(), (long)dn2.getCapacity());
        Assert.assertEquals((Object)dn1.getDatanodeReport(), (Object)dn2.getDatanodeReport());
        Assert.assertEquals((long)dn1.getDfsUsed(), (long)dn1.getDfsUsed());
        Assert.assertEquals((double)dn1.getDfsUsedPercent(), (double)dn1.getDfsUsedPercent(), (double)1.0E-6);
        Assert.assertEquals((Object)dn1.getIpAddr(), (Object)dn2.getIpAddr());
        Assert.assertEquals((Object)dn1.getHostName(), (Object)dn2.getHostName());
        Assert.assertEquals((long)dn1.getInfoPort(), (long)dn2.getInfoPort());
        Assert.assertEquals((long)dn1.getIpcPort(), (long)dn2.getIpcPort());
        Assert.assertEquals((long)dn1.getLastUpdate(), (long)dn2.getLastUpdate());
        Assert.assertEquals((long)dn1.getLevel(), (long)dn2.getLevel());
        Assert.assertEquals((Object)dn1.getNetworkLocation(), (Object)dn2.getNetworkLocation());
    }

    @Test
    public void testConvertExtendedBlock() {
        ExtendedBlock b = this.getExtendedBlock();
        HdfsProtos.ExtendedBlockProto bProto = PBHelperClient.convert((ExtendedBlock)b);
        ExtendedBlock b1 = PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b1);
        b.setBlockId(-1L);
        bProto = PBHelperClient.convert((ExtendedBlock)b);
        b1 = PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b1);
    }

    @Test
    public void testConvertRecoveringBlock() {
        DatanodeInfo di1 = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo di2 = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] dnInfo = new DatanodeInfo[]{di1, di2};
        BlockRecoveryCommand.RecoveringBlock b = new BlockRecoveryCommand.RecoveringBlock(this.getExtendedBlock(), dnInfo, 3L);
        HdfsServerProtos.RecoveringBlockProto bProto = PBHelper.convert((BlockRecoveryCommand.RecoveringBlock)b);
        BlockRecoveryCommand.RecoveringBlock b1 = PBHelper.convert((HdfsServerProtos.RecoveringBlockProto)bProto);
        Assert.assertEquals((Object)b.getBlock(), (Object)b1.getBlock());
        DatanodeInfoWithStorage[] dnInfo1 = b1.getLocations();
        Assert.assertEquals((long)dnInfo.length, (long)dnInfo1.length);
        for (int i = 0; i < dnInfo.length; ++i) {
            this.compare(dnInfo[0], (DatanodeInfo)dnInfo1[0]);
        }
    }

    @Test
    public void testConvertBlockRecoveryCommand() {
        DatanodeInfo di1 = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo di2 = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] dnInfo = new DatanodeInfo[]{di1, di2};
        ImmutableList blks = ImmutableList.of((Object)new BlockRecoveryCommand.RecoveringBlock(this.getExtendedBlock(1L), dnInfo, 3L), (Object)new BlockRecoveryCommand.RecoveringBlock(this.getExtendedBlock(2L), dnInfo, 3L));
        BlockRecoveryCommand cmd = new BlockRecoveryCommand((Collection)blks);
        DatanodeProtocolProtos.BlockRecoveryCommandProto proto = PBHelper.convert((BlockRecoveryCommand)cmd);
        Assert.assertEquals((long)1L, (long)proto.getBlocks(0).getBlock().getB().getBlockId());
        Assert.assertEquals((long)2L, (long)proto.getBlocks(1).getBlock().getB().getBlockId());
        BlockRecoveryCommand cmd2 = PBHelper.convert((DatanodeProtocolProtos.BlockRecoveryCommandProto)proto);
        ArrayList cmd2Blks = Lists.newArrayList((Iterable)cmd2.getRecoveringBlocks());
        Assert.assertEquals((Object)((BlockRecoveryCommand.RecoveringBlock)blks.get(0)).getBlock(), (Object)((BlockRecoveryCommand.RecoveringBlock)cmd2Blks.get(0)).getBlock());
        Assert.assertEquals((Object)((BlockRecoveryCommand.RecoveringBlock)blks.get(1)).getBlock(), (Object)((BlockRecoveryCommand.RecoveringBlock)cmd2Blks.get(1)).getBlock());
        Assert.assertEquals((Object)Joiner.on((String)",").join((Iterable)blks), (Object)Joiner.on((String)",").join((Iterable)cmd2Blks));
        Assert.assertEquals((Object)cmd.toString(), (Object)cmd2.toString());
    }

    @Test
    public void testConvertText() {
        Text t = new Text("abc".getBytes());
        String s = t.toString();
        Text t1 = new Text(s);
        Assert.assertEquals((Object)t, (Object)t1);
    }

    @Test
    public void testConvertBlockToken() {
        Token token = new Token("identifier".getBytes(), "password".getBytes(), new Text("kind"), new Text("service"));
        SecurityProtos.TokenProto tokenProto = PBHelperClient.convert((Token)token);
        Token token2 = PBHelperClient.convert((SecurityProtos.TokenProto)tokenProto);
        this.compare((Token<BlockTokenIdentifier>)token, (Token<BlockTokenIdentifier>)token2);
    }

    @Test
    public void testConvertNamespaceInfo() {
        NamespaceInfo info = new NamespaceInfo(37, "clusterID", "bpID", 2300L);
        HdfsServerProtos.NamespaceInfoProto proto = PBHelper.convert((NamespaceInfo)info);
        NamespaceInfo info2 = PBHelper.convert((HdfsServerProtos.NamespaceInfoProto)proto);
        this.compare((StorageInfo)info, (StorageInfo)info2);
        Assert.assertEquals((Object)info.getBlockPoolID(), (Object)info2.getBlockPoolID());
        Assert.assertEquals((Object)info.getBuildVersion(), (Object)info2.getBuildVersion());
    }

    private void compare(StorageInfo expected, StorageInfo actual) {
        Assert.assertEquals((Object)expected.clusterID, (Object)actual.clusterID);
        Assert.assertEquals((long)expected.namespaceID, (long)actual.namespaceID);
        Assert.assertEquals((long)expected.cTime, (long)actual.cTime);
        Assert.assertEquals((long)expected.layoutVersion, (long)actual.layoutVersion);
    }

    private void compare(Token<BlockTokenIdentifier> expected, Token<BlockTokenIdentifier> actual) {
        Assert.assertTrue((boolean)Arrays.equals(expected.getIdentifier(), actual.getIdentifier()));
        Assert.assertTrue((boolean)Arrays.equals(expected.getPassword(), actual.getPassword()));
        Assert.assertEquals((Object)expected.getKind(), (Object)actual.getKind());
        Assert.assertEquals((Object)expected.getService(), (Object)actual.getService());
    }

    private void compare(LocatedBlock expected, LocatedBlock actual) {
        Assert.assertEquals((Object)expected.getBlock(), (Object)actual.getBlock());
        this.compare((Token<BlockTokenIdentifier>)expected.getBlockToken(), (Token<BlockTokenIdentifier>)actual.getBlockToken());
        Assert.assertEquals((long)expected.getStartOffset(), (long)actual.getStartOffset());
        Assert.assertEquals((Object)expected.isCorrupt(), (Object)actual.isCorrupt());
        DatanodeInfoWithStorage[] ei = expected.getLocations();
        DatanodeInfoWithStorage[] ai = actual.getLocations();
        Assert.assertEquals((long)ei.length, (long)ai.length);
        for (int i = 0; i < ei.length; ++i) {
            this.compare((DatanodeInfo)ei[i], (DatanodeInfo)ai[i]);
        }
    }

    private LocatedBlock createLocatedBlock() {
        DatanodeInfo[] dnInfos = new DatanodeInfo[]{DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h1", DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h2", DatanodeInfo.AdminStates.DECOMMISSIONED), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h3", DatanodeInfo.AdminStates.NORMAL), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h4", DatanodeInfo.AdminStates.NORMAL)};
        String[] storageIDs = new String[]{"s1", "s2", "s3", "s4"};
        StorageType[] media = new StorageType[]{StorageType.DISK, StorageType.SSD, StorageType.DISK, StorageType.RAM_DISK};
        LocatedBlock lb = new LocatedBlock(new ExtendedBlock("bp12", 12345L, 10L, 53L), dnInfos, storageIDs, media, 5L, false, new DatanodeInfo[0]);
        lb.setBlockToken(new Token("identifier".getBytes(), "password".getBytes(), new Text("kind"), new Text("service")));
        return lb;
    }

    private LocatedBlock createLocatedBlockNoStorageMedia() {
        DatanodeInfo[] dnInfos = new DatanodeInfo[]{DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h1", DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h2", DatanodeInfo.AdminStates.DECOMMISSIONED), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h3", DatanodeInfo.AdminStates.NORMAL)};
        LocatedBlock lb = new LocatedBlock(new ExtendedBlock("bp12", 12345L, 10L, 53L), dnInfos);
        lb.setBlockToken(new Token("identifier".getBytes(), "password".getBytes(), new Text("kind"), new Text("service")));
        lb.setStartOffset(5L);
        return lb;
    }

    @Test
    public void testConvertLocatedBlock() {
        LocatedBlock lb = this.createLocatedBlock();
        HdfsProtos.LocatedBlockProto lbProto = PBHelperClient.convertLocatedBlock((LocatedBlock)lb);
        LocatedBlock lb2 = PBHelperClient.convertLocatedBlockProto((HdfsProtos.LocatedBlockProto)lbProto);
        this.compare(lb, lb2);
    }

    @Test
    public void testConvertLocatedBlockNoStorageMedia() {
        LocatedBlock lb = this.createLocatedBlockNoStorageMedia();
        HdfsProtos.LocatedBlockProto lbProto = PBHelperClient.convertLocatedBlock((LocatedBlock)lb);
        LocatedBlock lb2 = PBHelperClient.convertLocatedBlockProto((HdfsProtos.LocatedBlockProto)lbProto);
        this.compare(lb, lb2);
    }

    @Test
    public void testConvertLocatedBlockList() {
        ArrayList<LocatedBlock> lbl = new ArrayList<LocatedBlock>();
        for (int i = 0; i < 3; ++i) {
            lbl.add(this.createLocatedBlock());
        }
        List lbpl = PBHelperClient.convertLocatedBlocks2(lbl);
        List lbl2 = PBHelperClient.convertLocatedBlocks((List)lbpl);
        Assert.assertEquals((long)lbl.size(), (long)lbl2.size());
        for (int i = 0; i < lbl.size(); ++i) {
            this.compare((LocatedBlock)lbl.get(i), (LocatedBlock)lbl2.get(2));
        }
    }

    @Test
    public void testConvertLocatedBlockArray() {
        LocatedBlock[] lbl = new LocatedBlock[3];
        for (int i = 0; i < 3; ++i) {
            lbl[i] = this.createLocatedBlock();
        }
        HdfsProtos.LocatedBlockProto[] lbpl = PBHelperClient.convertLocatedBlocks((LocatedBlock[])lbl);
        LocatedBlock[] lbl2 = PBHelperClient.convertLocatedBlocks((HdfsProtos.LocatedBlockProto[])lbpl);
        Assert.assertEquals((long)lbl.length, (long)lbl2.length);
        for (int i = 0; i < lbl.length; ++i) {
            this.compare(lbl[i], lbl2[i]);
        }
    }

    @Test
    public void testConvertDatanodeRegistration() {
        DatanodeID dnId = DFSTestUtil.getLocalDatanodeID();
        BlockKey[] keys = new BlockKey[]{TestPBHelper.getBlockKey(2), TestPBHelper.getBlockKey(3)};
        ExportedBlockKeys expKeys = new ExportedBlockKeys(true, 9L, 10L, TestPBHelper.getBlockKey(1), keys);
        DatanodeRegistration reg = new DatanodeRegistration(dnId, new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), expKeys, "3.0.0");
        DatanodeProtocolProtos.DatanodeRegistrationProto proto = PBHelper.convert((DatanodeRegistration)reg);
        DatanodeRegistration reg2 = PBHelper.convert((DatanodeProtocolProtos.DatanodeRegistrationProto)proto);
        this.compare(reg.getStorageInfo(), reg2.getStorageInfo());
        this.compare(reg.getExportedKeys(), reg2.getExportedKeys());
        this.compare((DatanodeID)reg, (DatanodeID)reg2);
        Assert.assertEquals((Object)reg.getSoftwareVersion(), (Object)reg2.getSoftwareVersion());
    }

    @Test
    public void TestConvertDatanodeStorage() {
        DatanodeStorage dns1 = new DatanodeStorage("id1", DatanodeStorage.State.NORMAL, StorageType.SSD);
        HdfsProtos.DatanodeStorageProto proto = PBHelperClient.convert((DatanodeStorage)dns1);
        DatanodeStorage dns2 = PBHelperClient.convert((HdfsProtos.DatanodeStorageProto)proto);
        this.compare(dns1, dns2);
    }

    @Test
    public void testConvertBlockCommand() {
        Block[] blocks = new Block[]{new Block(21L), new Block(22L)};
        DatanodeInfo[][] dnInfos = new DatanodeInfo[][]{new DatanodeInfo[1], new DatanodeInfo[2]};
        dnInfos[0][0] = DFSTestUtil.getLocalDatanodeInfo();
        dnInfos[1][0] = DFSTestUtil.getLocalDatanodeInfo();
        dnInfos[1][1] = DFSTestUtil.getLocalDatanodeInfo();
        String[][] storageIDs = new String[][]{{"s00"}, {"s10", "s11"}};
        StorageType[][] storageTypes = new StorageType[][]{{StorageType.DEFAULT}, {StorageType.DEFAULT, StorageType.DEFAULT}};
        BlockCommand bc = new BlockCommand(1, "bp1", blocks, (DatanodeInfo[][])dnInfos, (StorageType[][])storageTypes, storageIDs);
        DatanodeProtocolProtos.BlockCommandProto bcProto = PBHelper.convert((BlockCommand)bc);
        BlockCommand bc2 = PBHelper.convert((DatanodeProtocolProtos.BlockCommandProto)bcProto);
        Assert.assertEquals((long)bc.getAction(), (long)bc2.getAction());
        Assert.assertEquals((long)bc.getBlocks().length, (long)bc2.getBlocks().length);
        Block[] blocks2 = bc2.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            Assert.assertEquals((Object)blocks[i], (Object)blocks2[i]);
        }
        DatanodeInfo[][] dnInfos2 = bc2.getTargets();
        Assert.assertEquals((long)dnInfos.length, (long)dnInfos2.length);
        for (int i = 0; i < dnInfos.length; ++i) {
            DatanodeInfo[] d1 = dnInfos[i];
            DatanodeInfo[] d2 = dnInfos2[i];
            Assert.assertEquals((long)d1.length, (long)d2.length);
            for (int j = 0; j < d1.length; ++j) {
                this.compare(d1[j], d2[j]);
            }
        }
    }

    @Test
    public void testChecksumTypeProto() {
        Assert.assertEquals((Object)DataChecksum.Type.NULL, (Object)PBHelperClient.convert((HdfsProtos.ChecksumTypeProto)HdfsProtos.ChecksumTypeProto.CHECKSUM_NULL));
        Assert.assertEquals((Object)DataChecksum.Type.CRC32, (Object)PBHelperClient.convert((HdfsProtos.ChecksumTypeProto)HdfsProtos.ChecksumTypeProto.CHECKSUM_CRC32));
        Assert.assertEquals((Object)DataChecksum.Type.CRC32C, (Object)PBHelperClient.convert((HdfsProtos.ChecksumTypeProto)HdfsProtos.ChecksumTypeProto.CHECKSUM_CRC32C));
        Assert.assertEquals((Object)PBHelperClient.convert((DataChecksum.Type)DataChecksum.Type.NULL), (Object)HdfsProtos.ChecksumTypeProto.CHECKSUM_NULL);
        Assert.assertEquals((Object)PBHelperClient.convert((DataChecksum.Type)DataChecksum.Type.CRC32), (Object)HdfsProtos.ChecksumTypeProto.CHECKSUM_CRC32);
        Assert.assertEquals((Object)PBHelperClient.convert((DataChecksum.Type)DataChecksum.Type.CRC32C), (Object)HdfsProtos.ChecksumTypeProto.CHECKSUM_CRC32C);
    }

    @Test
    public void testBlockChecksumTypeProto() {
        Assert.assertEquals((Object)BlockChecksumType.MD5CRC, (Object)PBHelperClient.convert((HdfsProtos.BlockChecksumTypeProto)HdfsProtos.BlockChecksumTypeProto.MD5CRC));
        Assert.assertEquals((Object)BlockChecksumType.COMPOSITE_CRC, (Object)PBHelperClient.convert((HdfsProtos.BlockChecksumTypeProto)HdfsProtos.BlockChecksumTypeProto.COMPOSITE_CRC));
        Assert.assertEquals((Object)PBHelperClient.convert((BlockChecksumType)BlockChecksumType.MD5CRC), (Object)HdfsProtos.BlockChecksumTypeProto.MD5CRC);
        Assert.assertEquals((Object)PBHelperClient.convert((BlockChecksumType)BlockChecksumType.COMPOSITE_CRC), (Object)HdfsProtos.BlockChecksumTypeProto.COMPOSITE_CRC);
    }

    @Test
    public void testAclEntryProto() {
        AclEntry e1 = new AclEntry.Builder().setName("test").setPermission(FsAction.READ_EXECUTE).setScope(AclEntryScope.DEFAULT).setType(AclEntryType.OTHER).build();
        AclEntry e2 = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(FsAction.ALL).build();
        AclEntry e3 = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setName("test").build();
        Object[] expected = new AclEntry[]{e1, e2, new AclEntry.Builder().setScope(e3.getScope()).setType(e3.getType()).setName(e3.getName()).setPermission(FsAction.NONE).build()};
        Object[] actual = Lists.newArrayList((Iterable)PBHelperClient.convertAclEntry((List)PBHelperClient.convertAclEntryProto((List)Lists.newArrayList((Object[])new AclEntry[]{e1, e2, e3})))).toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testAclStatusProto() {
        AclEntry e = new AclEntry.Builder().setName("test").setPermission(FsAction.READ_EXECUTE).setScope(AclEntryScope.DEFAULT).setType(AclEntryType.OTHER).build();
        AclStatus s = new AclStatus.Builder().owner("foo").group("bar").addEntry(e).build();
        Assert.assertEquals((Object)s, (Object)PBHelperClient.convert((AclProtos.GetAclStatusResponseProto)PBHelperClient.convert((AclStatus)s)));
    }

    @Test
    public void testBlockECRecoveryCommand() {
        DatanodeInfo[] dnInfos0 = new DatanodeInfo[]{DFSTestUtil.getLocalDatanodeInfo(), DFSTestUtil.getLocalDatanodeInfo()};
        DatanodeStorageInfo targetDnInfos_0 = BlockManagerTestUtil.newDatanodeStorageInfo(DFSTestUtil.getLocalDatanodeDescriptor(), new DatanodeStorage("s00"));
        DatanodeStorageInfo targetDnInfos_1 = BlockManagerTestUtil.newDatanodeStorageInfo(DFSTestUtil.getLocalDatanodeDescriptor(), new DatanodeStorage("s01"));
        DatanodeStorageInfo[] targetDnInfos0 = new DatanodeStorageInfo[]{targetDnInfos_0, targetDnInfos_1};
        byte[] liveBlkIndices0 = new byte[2];
        BlockECReconstructionCommand.BlockECReconstructionInfo blkECRecoveryInfo0 = new BlockECReconstructionCommand.BlockECReconstructionInfo(new ExtendedBlock("bp1", 1234L), dnInfos0, targetDnInfos0, liveBlkIndices0, StripedFileTestUtil.getDefaultECPolicy());
        DatanodeInfo[] dnInfos1 = new DatanodeInfo[]{DFSTestUtil.getLocalDatanodeInfo(), DFSTestUtil.getLocalDatanodeInfo()};
        DatanodeStorageInfo targetDnInfos_2 = BlockManagerTestUtil.newDatanodeStorageInfo(DFSTestUtil.getLocalDatanodeDescriptor(), new DatanodeStorage("s02"));
        DatanodeStorageInfo targetDnInfos_3 = BlockManagerTestUtil.newDatanodeStorageInfo(DFSTestUtil.getLocalDatanodeDescriptor(), new DatanodeStorage("s03"));
        DatanodeStorageInfo[] targetDnInfos1 = new DatanodeStorageInfo[]{targetDnInfos_2, targetDnInfos_3};
        byte[] liveBlkIndices1 = new byte[2];
        BlockECReconstructionCommand.BlockECReconstructionInfo blkECRecoveryInfo1 = new BlockECReconstructionCommand.BlockECReconstructionInfo(new ExtendedBlock("bp2", 3256L), dnInfos1, targetDnInfos1, liveBlkIndices1, StripedFileTestUtil.getDefaultECPolicy());
        ArrayList<BlockECReconstructionCommand.BlockECReconstructionInfo> blkRecoveryInfosList = new ArrayList<BlockECReconstructionCommand.BlockECReconstructionInfo>();
        blkRecoveryInfosList.add(blkECRecoveryInfo0);
        blkRecoveryInfosList.add(blkECRecoveryInfo1);
        BlockECReconstructionCommand blkECReconstructionCmd = new BlockECReconstructionCommand(11, blkRecoveryInfosList);
        DatanodeProtocolProtos.BlockECReconstructionCommandProto blkECRecoveryCmdProto = PBHelper.convert((BlockECReconstructionCommand)blkECReconstructionCmd);
        blkECReconstructionCmd = PBHelper.convert((DatanodeProtocolProtos.BlockECReconstructionCommandProto)blkECRecoveryCmdProto);
        Iterator iterator = blkECReconstructionCmd.getECTasks().iterator();
        this.assertBlockECRecoveryInfoEquals(blkECRecoveryInfo0, (BlockECReconstructionCommand.BlockECReconstructionInfo)iterator.next());
        this.assertBlockECRecoveryInfoEquals(blkECRecoveryInfo1, (BlockECReconstructionCommand.BlockECReconstructionInfo)iterator.next());
    }

    @Test
    public void testDataNodeInfoPBHelper() {
        DatanodeID id = DFSTestUtil.getLocalDatanodeID();
        DatanodeInfo dnInfos0 = new DatanodeInfo.DatanodeInfoBuilder().setNodeID(id).build();
        dnInfos0.setCapacity(3500L);
        dnInfos0.setDfsUsed(1000L);
        dnInfos0.setNonDfsUsed(2000L);
        dnInfos0.setRemaining(500L);
        HdfsProtos.DatanodeInfoProto dnproto = PBHelperClient.convert((DatanodeInfo)dnInfos0);
        DatanodeInfo dnInfos1 = PBHelperClient.convert((HdfsProtos.DatanodeInfoProto)dnproto);
        this.compare(dnInfos0, dnInfos1);
        Assert.assertEquals((long)dnInfos0.getNonDfsUsed(), (long)dnInfos1.getNonDfsUsed());
        HdfsProtos.DatanodeInfoProto.Builder b = HdfsProtos.DatanodeInfoProto.newBuilder();
        b.setId(PBHelperClient.convert((DatanodeID)id)).setCapacity(3500L).setDfsUsed(1000L).setRemaining(500L);
        DatanodeInfo dnInfos3 = PBHelperClient.convert((HdfsProtos.DatanodeInfoProto)b.build());
        Assert.assertEquals((long)dnInfos0.getNonDfsUsed(), (long)dnInfos3.getNonDfsUsed());
    }

    @Test
    public void testSlowPeerInfoPBHelper() {
        OutlierMetrics outlierMetrics1 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0));
        OutlierMetrics outlierMetrics2 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.0));
        OutlierMetrics outlierMetrics3 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.0));
        SlowPeerReports slowPeers = SlowPeerReports.create((Map)ImmutableMap.of((Object)"peer1", (Object)outlierMetrics1, (Object)"peer2", (Object)outlierMetrics2, (Object)"peer3", (Object)outlierMetrics3));
        SlowPeerReports slowPeersConverted1 = PBHelper.convertSlowPeerInfo((List)PBHelper.convertSlowPeerInfo((SlowPeerReports)slowPeers));
        Assert.assertTrue((String)("Expected map:" + slowPeers + ", got map:" + slowPeersConverted1.getSlowPeers()), (boolean)slowPeersConverted1.equals((Object)slowPeers));
        SlowPeerReports slowPeersConverted2 = PBHelper.convertSlowPeerInfo((List)PBHelper.convertSlowPeerInfo((SlowPeerReports)SlowPeerReports.EMPTY_REPORT));
        Assert.assertTrue((String)("Expected empty map:, got map:" + slowPeersConverted2), (boolean)slowPeersConverted2.equals((Object)SlowPeerReports.EMPTY_REPORT));
    }

    @Test
    public void testSlowDiskInfoPBHelper() {
        SlowDiskReports slowDisks = SlowDiskReports.create((Map)ImmutableMap.of((Object)"disk1", (Object)ImmutableMap.of((Object)SlowDiskReports.DiskOp.METADATA, (Object)0.5), (Object)"disk2", (Object)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.0, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.0), (Object)"disk3", (Object)ImmutableMap.of((Object)SlowDiskReports.DiskOp.METADATA, (Object)1.2, (Object)SlowDiskReports.DiskOp.READ, (Object)1.5, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.3)));
        SlowDiskReports slowDisksConverted1 = PBHelper.convertSlowDiskInfo((List)PBHelper.convertSlowDiskInfo((SlowDiskReports)slowDisks));
        Assert.assertTrue((String)("Expected map:" + slowDisks + ", got map:" + slowDisksConverted1.getSlowDisks()), (boolean)slowDisksConverted1.equals((Object)slowDisks));
        SlowDiskReports slowDisksConverted2 = PBHelper.convertSlowDiskInfo((List)PBHelper.convertSlowDiskInfo((SlowDiskReports)SlowDiskReports.EMPTY_REPORT));
        Assert.assertTrue((String)("Expected empty map:, got map:" + slowDisksConverted2), (boolean)slowDisksConverted2.equals((Object)SlowDiskReports.EMPTY_REPORT));
    }

    private void assertBlockECRecoveryInfoEquals(BlockECReconstructionCommand.BlockECReconstructionInfo blkECRecoveryInfo1, BlockECReconstructionCommand.BlockECReconstructionInfo blkECRecoveryInfo2) {
        Assert.assertEquals((Object)blkECRecoveryInfo1.getExtendedBlock(), (Object)blkECRecoveryInfo2.getExtendedBlock());
        DatanodeInfo[] sourceDnInfos1 = blkECRecoveryInfo1.getSourceDnInfos();
        DatanodeInfo[] sourceDnInfos2 = blkECRecoveryInfo2.getSourceDnInfos();
        this.assertDnInfosEqual(sourceDnInfos1, sourceDnInfos2);
        DatanodeInfo[] targetDnInfos1 = blkECRecoveryInfo1.getTargetDnInfos();
        DatanodeInfo[] targetDnInfos2 = blkECRecoveryInfo2.getTargetDnInfos();
        this.assertDnInfosEqual(targetDnInfos1, targetDnInfos2);
        String[] targetStorageIDs1 = blkECRecoveryInfo1.getTargetStorageIDs();
        String[] targetStorageIDs2 = blkECRecoveryInfo2.getTargetStorageIDs();
        Assert.assertEquals((long)targetStorageIDs1.length, (long)targetStorageIDs2.length);
        for (int i = 0; i < targetStorageIDs1.length; ++i) {
            Assert.assertEquals((Object)targetStorageIDs1[i], (Object)targetStorageIDs2[i]);
        }
        byte[] liveBlockIndices1 = blkECRecoveryInfo1.getLiveBlockIndices();
        byte[] liveBlockIndices2 = blkECRecoveryInfo2.getLiveBlockIndices();
        for (int i = 0; i < liveBlockIndices1.length; ++i) {
            Assert.assertEquals((long)liveBlockIndices1[i], (long)liveBlockIndices2[i]);
        }
        ErasureCodingPolicy ecPolicy1 = blkECRecoveryInfo1.getErasureCodingPolicy();
        ErasureCodingPolicy ecPolicy2 = blkECRecoveryInfo2.getErasureCodingPolicy();
        this.compareECPolicies(StripedFileTestUtil.getDefaultECPolicy(), ecPolicy1);
        this.compareECPolicies(StripedFileTestUtil.getDefaultECPolicy(), ecPolicy2);
    }

    private void compareECPolicies(ErasureCodingPolicy ecPolicy1, ErasureCodingPolicy ecPolicy2) {
        Assert.assertEquals((Object)ecPolicy1.getName(), (Object)ecPolicy2.getName());
        Assert.assertEquals((long)ecPolicy1.getNumDataUnits(), (long)ecPolicy2.getNumDataUnits());
        Assert.assertEquals((long)ecPolicy1.getNumParityUnits(), (long)ecPolicy2.getNumParityUnits());
    }

    private void assertDnInfosEqual(DatanodeInfo[] dnInfos1, DatanodeInfo[] dnInfos2) {
        Assert.assertEquals((long)dnInfos1.length, (long)dnInfos2.length);
        for (int i = 0; i < dnInfos1.length; ++i) {
            this.compare(dnInfos1[i], dnInfos2[i]);
        }
    }

    @Test
    public void testFSServerDefaultsHelper() {
        HdfsProtos.FsServerDefaultsProto.Builder b = HdfsProtos.FsServerDefaultsProto.newBuilder();
        b.setBlockSize(0x8000000L);
        b.setBytesPerChecksum(512);
        b.setWritePacketSize(65536);
        b.setReplication(3);
        b.setFileBufferSize(4096);
        b.setEncryptDataTransfer(false);
        b.setTrashInterval(0L);
        b.setChecksumType(HdfsProtos.ChecksumTypeProto.forNumber((int)DataChecksum.Type.valueOf((String)"CRC32C").id));
        HdfsProtos.FsServerDefaultsProto proto = b.build();
        Assert.assertFalse((String)"KeyProvider uri is not supported", (boolean)proto.hasKeyProviderUri());
        FsServerDefaults fsServerDefaults = PBHelperClient.convert((HdfsProtos.FsServerDefaultsProto)proto);
        Assert.assertNotNull((String)"FsServerDefaults is null", (Object)fsServerDefaults);
        Assert.assertNull((String)"KeyProviderUri should be null", (Object)fsServerDefaults.getKeyProviderUri());
    }

    @Test
    public void testConvertAddingECPolicyResponse() throws Exception {
        for (ErasureCodingPolicy policy : SystemErasureCodingPolicies.getPolicies()) {
            AddErasureCodingPolicyResponse response = new AddErasureCodingPolicyResponse(policy);
            HdfsProtos.AddErasureCodingPolicyResponseProto proto = PBHelperClient.convertAddErasureCodingPolicyResponse((AddErasureCodingPolicyResponse)response);
            Assert.assertFalse((String)"Unnecessary field is set.", (boolean)proto.hasErrorMsg());
            AddErasureCodingPolicyResponse convertedResponse = PBHelperClient.convertAddErasureCodingPolicyResponse((HdfsProtos.AddErasureCodingPolicyResponseProto)proto);
            Assert.assertEquals((String)"Converted policy not equal", (Object)response.getPolicy(), (Object)convertedResponse.getPolicy());
            Assert.assertEquals((String)"Converted policy not equal", (Object)response.isSucceed(), (Object)convertedResponse.isSucceed());
        }
        ErasureCodingPolicy policy = (ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(0);
        AddErasureCodingPolicyResponse response = new AddErasureCodingPolicyResponse(policy, "failed");
        HdfsProtos.AddErasureCodingPolicyResponseProto proto = PBHelperClient.convertAddErasureCodingPolicyResponse((AddErasureCodingPolicyResponse)response);
        AddErasureCodingPolicyResponse convertedResponse = PBHelperClient.convertAddErasureCodingPolicyResponse((HdfsProtos.AddErasureCodingPolicyResponseProto)proto);
        Assert.assertEquals((String)"Converted policy not equal", (Object)response.getPolicy(), (Object)convertedResponse.getPolicy());
        Assert.assertEquals((String)"Converted policy not equal", (Object)response.getErrorMsg(), (Object)convertedResponse.getErrorMsg());
    }

    @Test
    public void testConvertErasureCodingPolicy() throws Exception {
        ErasureCodingPolicy convertedPolicy;
        HdfsProtos.ErasureCodingPolicyProto proto;
        for (ErasureCodingPolicy policy : SystemErasureCodingPolicies.getPolicies()) {
            proto = PBHelperClient.convertErasureCodingPolicy((ErasureCodingPolicy)policy);
            Assert.assertFalse((String)"Unnecessary field is set.", (boolean)proto.hasName());
            Assert.assertFalse((String)"Unnecessary field is set.", (boolean)proto.hasSchema());
            Assert.assertFalse((String)"Unnecessary field is set.", (boolean)proto.hasCellSize());
            convertedPolicy = PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)proto);
            Assert.assertEquals((String)"Converted policy not equal", (Object)policy, (Object)convertedPolicy);
        }
        ECSchema newSchema = new ECSchema("testcodec", 3, 2);
        ErasureCodingPolicy newPolicy = new ErasureCodingPolicy(newSchema, 131072);
        proto = PBHelperClient.convertErasureCodingPolicy((ErasureCodingPolicy)newPolicy);
        Assert.assertTrue((String)"Optional field not set", (boolean)proto.hasName());
        Assert.assertTrue((String)"Optional field not set", (boolean)proto.hasSchema());
        Assert.assertTrue((String)"Optional field not set", (boolean)proto.hasCellSize());
        convertedPolicy = PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)proto);
        Assert.assertEquals((String)"Converted policy not equal", (Object)newPolicy, (Object)convertedPolicy);
    }

    @Test(expected=UninitializedMessageException.class)
    public void testErasureCodingPolicyMissingId() throws Exception {
        HdfsProtos.ErasureCodingPolicyProto.Builder builder = HdfsProtos.ErasureCodingPolicyProto.newBuilder();
        PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)builder.build());
    }

    @Test
    public void testErasureCodingPolicyMissingOptionalFields() throws Exception {
        HdfsProtos.ECSchemaProto schemaProto = PBHelperClient.convertECSchema((ECSchema)StripedFileTestUtil.getDefaultECPolicy().getSchema());
        try {
            PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)HdfsProtos.ErasureCodingPolicyProto.newBuilder().setId(14).setSchema(schemaProto).setCellSize(123).build());
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Missing", (Throwable)e);
        }
        try {
            PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)HdfsProtos.ErasureCodingPolicyProto.newBuilder().setId(14).setName("testpolicy").setCellSize(123).build());
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Missing", (Throwable)e);
        }
        try {
            PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)HdfsProtos.ErasureCodingPolicyProto.newBuilder().setId(14).setName("testpolicy").setSchema(schemaProto).build());
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Missing", (Throwable)e);
        }
    }
}

