/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;

public class FSYarnSiteConverter {
    private boolean preemptionEnabled;
    private boolean autoCreateChildQueues;
    private boolean sizeBasedWeight;
    private boolean userAsDefaultQueue;

    public void convertSiteProperties(Configuration conf, Configuration yarnSiteConfig, boolean drfUsed, boolean enableAsyncScheduler) {
        float localityThresholdRack;
        float localityThresholdNode;
        String vcoreIncrementAllocation;
        String mbIncrementAllocation;
        yarnSiteConfig.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getCanonicalName());
        if (conf.getBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", false)) {
            yarnSiteConfig.setBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", true);
            int interval = conf.getInt("yarn.scheduler.fair.continuous-scheduling-sleep-ms", 5);
            yarnSiteConfig.setInt("yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms", interval);
        }
        if ((mbIncrementAllocation = conf.get("yarn.resource-types.memory-mb.increment-allocation")) != null) {
            yarnSiteConfig.set("yarn.scheduler.minimum-allocation-mb", mbIncrementAllocation);
        }
        if ((vcoreIncrementAllocation = conf.get("yarn.resource-types.vcores.increment-allocation")) != null) {
            yarnSiteConfig.set("yarn.scheduler.minimum-allocation-vcores", vcoreIncrementAllocation);
        }
        if (conf.getBoolean("yarn.scheduler.fair.preemption", false)) {
            yarnSiteConfig.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
            this.preemptionEnabled = true;
            int waitTimeBeforeKill = conf.getInt("yarn.scheduler.fair.waitTimeBeforeKill", 15000);
            yarnSiteConfig.setInt("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", waitTimeBeforeKill);
            long waitBeforeNextStarvationCheck = conf.getLong("yarn.scheduler.fair.waitTimeBeforeNextStarvationCheck", 10000L);
            yarnSiteConfig.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", waitBeforeNextStarvationCheck);
        }
        if (conf.getBoolean("yarn.scheduler.fair.assignmultiple", false)) {
            yarnSiteConfig.setBoolean("yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled", true);
        } else {
            yarnSiteConfig.setBoolean("yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled", false);
        }
        int maxAssign = conf.getInt("yarn.scheduler.fair.max.assign", -1);
        if (maxAssign != -1) {
            yarnSiteConfig.setInt("yarn.scheduler.capacity.per-node-heartbeat.maximum-container-assignments", maxAssign);
        }
        if ((localityThresholdNode = conf.getFloat("yarn.scheduler.fair.locality.threshold.node", -1.0f)) != -1.0f) {
            yarnSiteConfig.setFloat("yarn.scheduler.capacity.node-locality-delay", localityThresholdNode);
        }
        if ((localityThresholdRack = conf.getFloat("yarn.scheduler.fair.locality.threshold.rack", -1.0f)) != -1.0f) {
            yarnSiteConfig.setFloat("yarn.scheduler.capacity.rack-locality-additional-delay", localityThresholdRack);
        }
        if (conf.getBoolean("yarn.scheduler.fair.allow-undeclared-pools", true)) {
            this.autoCreateChildQueues = true;
        }
        if (conf.getBoolean("yarn.scheduler.fair.sizebasedweight", false)) {
            this.sizeBasedWeight = true;
        }
        if (conf.getBoolean("yarn.scheduler.fair.user-as-default-queue", true)) {
            this.userAsDefaultQueue = true;
        }
        if (drfUsed) {
            yarnSiteConfig.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getCanonicalName());
        }
        if (enableAsyncScheduler) {
            yarnSiteConfig.setBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", true);
        }
    }

    public boolean isPreemptionEnabled() {
        return this.preemptionEnabled;
    }

    public boolean isAutoCreateChildQueues() {
        return this.autoCreateChildQueues;
    }

    public boolean isSizeBasedWeight() {
        return this.sizeBasedWeight;
    }

    public boolean isUserAsDefaultQueue() {
        return this.userAsDefaultQueue;
    }
}

