/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.appmaster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DAGAMSimulator
extends AMSimulator {
    private static final int PRIORITY = 20;
    private List<ContainerSimulator> pendingContainers = new LinkedList<ContainerSimulator>();
    private List<ContainerSimulator> scheduledContainers = new LinkedList<ContainerSimulator>();
    private Map<ContainerId, ContainerSimulator> assignedContainers = new HashMap<ContainerId, ContainerSimulator>();
    private List<ContainerSimulator> completedContainers = new LinkedList<ContainerSimulator>();
    private List<ContainerSimulator> allContainers = new LinkedList<ContainerSimulator>();
    private boolean isFinished = false;
    private long amStartTime;
    private static final Logger LOG = LoggerFactory.getLogger(DAGAMSimulator.class);

    @Override
    public void init(int heartbeatInterval, List<ContainerSimulator> containerList, ResourceManager resourceManager, SLSRunner slsRunnner, long startTime, long finishTime, String simUser, String simQueue, boolean tracked, String oldApp, long baseTimeMS, Resource amResource, String nodeLabelExpr, Map<String, String> params, Map<ApplicationId, AMSimulator> appIdAMSim) {
        super.init(heartbeatInterval, containerList, resourceManager, slsRunnner, startTime, finishTime, simUser, simQueue, tracked, oldApp, baseTimeMS, amResource, nodeLabelExpr, params, appIdAMSim);
        this.amtype = "dag";
        this.allContainers.addAll(containerList);
        this.pendingContainers.addAll(containerList);
        this.totalContainers = this.allContainers.size();
        LOG.info("Added new job with {} containers", (Object)this.allContainers.size());
    }

    @Override
    public void firstStep() throws Exception {
        super.firstStep();
        this.amStartTime = System.currentTimeMillis();
    }

    @Override
    public void initReservation(ReservationId reservationId, long deadline, long now) {
        this.setReservationRequest(null);
    }

    @Override
    public synchronized void notifyAMContainerLaunched(Container masterContainer) throws Exception {
        if (null != masterContainer) {
            this.restart();
            super.notifyAMContainerLaunched(masterContainer);
        }
    }

    @Override
    protected void processResponseQueue() throws Exception {
        while (!this.responseQueue.isEmpty()) {
            AllocateResponse response = (AllocateResponse)this.responseQueue.take();
            if (!response.getCompletedContainersStatuses().isEmpty()) {
                for (ContainerStatus cs : response.getCompletedContainersStatuses()) {
                    ContainerId containerId = cs.getContainerId();
                    if (cs.getExitStatus() == 0) {
                        if (this.assignedContainers.containsKey(containerId)) {
                            LOG.debug("Application {} has one container finished ({}).", (Object)this.appId, (Object)containerId);
                            ContainerSimulator containerSimulator = this.assignedContainers.remove(containerId);
                            ++this.finishedContainers;
                            this.completedContainers.add(containerSimulator);
                        } else if (this.amContainer.getId().equals((Object)containerId)) {
                            this.isFinished = true;
                            LOG.info("Application {} goes to finish.", (Object)this.appId);
                        }
                        if (this.finishedContainers < this.totalContainers) continue;
                        this.lastStep();
                        continue;
                    }
                    if (this.assignedContainers.containsKey(containerId)) {
                        LOG.error("Application {} has one container killed ({}).", (Object)this.appId, (Object)containerId);
                        this.pendingContainers.add(this.assignedContainers.remove(containerId));
                        continue;
                    }
                    if (!this.amContainer.getId().equals((Object)containerId)) continue;
                    LOG.error("Application {}'s AM is going to be killed. Waiting for rescheduling...", (Object)this.appId);
                }
            }
            if (this.isAMContainerRunning && this.finishedContainers >= this.totalContainers) {
                this.isAMContainerRunning = false;
                LOG.info("Application {} sends out event to clean up its AM container.", (Object)this.appId);
                this.isFinished = true;
                break;
            }
            for (Container container : response.getAllocatedContainers()) {
                if (this.scheduledContainers.isEmpty()) continue;
                ContainerSimulator cs = this.scheduledContainers.remove(0);
                LOG.debug("Application {} starts to launch a container ({}).", (Object)this.appId, (Object)container.getId());
                this.assignedContainers.put(container.getId(), cs);
                this.se.getNmMap().get(container.getNodeId()).addNewContainer(container, cs.getLifeTime());
            }
        }
    }

    @Override
    protected void sendContainerRequest() throws Exception {
        List<ContainerSimulator> toBeScheduled;
        if (this.isFinished) {
            return;
        }
        List<Object> ask = null;
        if (this.finishedContainers != this.totalContainers && !this.pendingContainers.isEmpty() && (toBeScheduled = this.getToBeScheduledContainers(this.pendingContainers, this.amStartTime)).size() > 0) {
            ask = this.packageRequests(toBeScheduled, 20);
            LOG.info("Application {} sends out request for {} containers.", (Object)this.appId, (Object)toBeScheduled.size());
            this.scheduledContainers.addAll(toBeScheduled);
            this.pendingContainers.removeAll(toBeScheduled);
            toBeScheduled.clear();
        }
        if (ask == null) {
            ask = new ArrayList();
        }
        AllocateRequest request = this.createAllocateRequest(ask);
        if (this.totalContainers == 0) {
            request.setProgress(1.0f);
        } else {
            request.setProgress((float)this.finishedContainers / (float)this.totalContainers);
        }
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appAttemptId.getApplicationId())).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        AllocateResponse response = (AllocateResponse)ugi.doAs(() -> this.rm.getApplicationMasterService().allocate(request));
        if (response != null) {
            this.responseQueue.put(response);
        }
    }

    @VisibleForTesting
    public List<ContainerSimulator> getToBeScheduledContainers(List<ContainerSimulator> containers, long startTime) {
        LinkedList<ContainerSimulator> toBeScheduled = new LinkedList<ContainerSimulator>();
        for (ContainerSimulator cs : containers) {
            if (cs.getRequestDelay() + startTime > System.currentTimeMillis()) continue;
            toBeScheduled.add(cs);
        }
        return toBeScheduled;
    }

    @Override
    protected void checkStop() {
        if (this.isFinished) {
            super.setEndTime(System.currentTimeMillis());
        }
    }

    @Override
    public void lastStep() throws Exception {
        super.lastStep();
        this.allContainers.clear();
        this.pendingContainers.clear();
        this.scheduledContainers.clear();
        this.assignedContainers.clear();
        this.completedContainers.clear();
    }

    private void restart() {
        this.isFinished = false;
        this.pendingContainers.clear();
        this.pendingContainers.addAll(this.allContainers);
        this.pendingContainers.removeAll(this.completedContainers);
        this.amContainer = null;
    }
}

