/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;

public final class HouseholderRight
extends MatrixOperation {
    public static final HouseholderRight SETUP = new HouseholderRight();
    public static int THRESHOLD = 512;

    public static void invoke(BigDecimal[] data, int first, int limit, int tmpColDim, Householder.Big householder) {
        BigDecimal[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        BigDecimal tmpBeta = householder.beta;
        int tmpRowDim = data.length / tmpColDim;
        for (int i = first; i < limit; ++i) {
            int j;
            BigDecimal tmpScale = BigMath.ZERO;
            int tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                tmpScale = BigFunction.ADD.invoke(tmpScale, BigFunction.MULTIPLY.invoke(tmpHouseholderVector[j], data[tmpIndex]));
                tmpIndex += tmpRowDim;
            }
            tmpScale = BigFunction.MULTIPLY.invoke(tmpScale, tmpBeta);
            tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                data[tmpIndex] = BigFunction.SUBTRACT.invoke(data[tmpIndex], BigFunction.MULTIPLY.invoke(tmpScale, tmpHouseholderVector[j]));
                tmpIndex += tmpRowDim;
            }
        }
    }

    public static void invoke(ComplexNumber[] data, int first, int limit, int tmpColDim, Householder.Complex householder) {
        ComplexNumber[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        ComplexNumber tmpBeta = householder.beta;
        int tmpRowDim = data.length / tmpColDim;
        for (int i = first; i < limit; ++i) {
            int j;
            ComplexNumber tmpScale = ComplexNumber.ZERO;
            int tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                tmpScale = tmpScale.add(tmpHouseholderVector[j].conjugate().multiply(data[tmpIndex].conjugate()));
                tmpIndex += tmpRowDim;
            }
            tmpScale = tmpScale.multiply(tmpBeta);
            tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                data[tmpIndex] = data[tmpIndex].conjugate().subtract(tmpScale.multiply(tmpHouseholderVector[j])).conjugate();
                tmpIndex += tmpRowDim;
            }
        }
    }

    public static void invoke(double[] data, int structure, int firstRow, int rowLimit, int numberOfColumns, Householder.Primitive householder, double[] work) {
        int j;
        double[] vector = householder.vector;
        int firstNonZero = householder.first;
        double beta = householder.beta;
        for (j = firstNonZero; j < numberOfColumns; ++j) {
            AXPY.invoke(work, 0, 1, beta * vector[j], data, j * structure, 1, firstRow, rowLimit);
        }
        for (j = firstNonZero; j < numberOfColumns; ++j) {
            AXPY.invoke(data, j * structure, 1, -vector[j], work, 0, 1, firstRow, rowLimit);
        }
    }

    private static void invoke2old(double[] data, int first, int limit, int tmpColDim, Householder.Primitive householder) {
        double[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        double tmpBeta = householder.beta;
        int tmpRowDim = data.length / tmpColDim;
        for (int i = first; i < limit; ++i) {
            int j;
            double tmpScale = PrimitiveMath.ZERO;
            int tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                tmpScale += tmpHouseholderVector[j] * data[tmpIndex];
                tmpIndex += tmpRowDim;
            }
            tmpScale *= tmpBeta;
            tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                int n = tmpIndex;
                data[n] = data[n] - tmpScale * tmpHouseholderVector[j];
                tmpIndex += tmpRowDim;
            }
        }
    }

    private HouseholderRight() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

