/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.nodelabels;

import java.io.IOException;
import java.util.Set;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.AbstractNodeDescriptorsProvider;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeDescriptorsScriptRunner;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeLabelsProvider;

public class ScriptBasedNodeLabelsProvider
extends NodeLabelsProvider {
    public static final String NODE_LABEL_PARTITION_PATTERN = "NODE_PARTITION:";
    private NodeDescriptorsScriptRunner runner;

    public ScriptBasedNodeLabelsProvider() {
        super(ScriptBasedNodeLabelsProvider.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        String nodeLabelsScriptPath = conf.get("yarn.nodemanager.node-labels.provider.script.path");
        long scriptTimeout = conf.getLong("yarn.nodemanager.node-labels.provider.fetch-timeout-ms", 1200000L);
        String[] scriptArgs = conf.getStrings("yarn.nodemanager.node-labels.provider.script.opts", new String[0]);
        this.verifyConfiguredScript(nodeLabelsScriptPath);
        long taskInterval = conf.getLong("yarn.nodemanager.node-labels.provider.fetch-interval-ms", 600000L);
        this.setIntervalTime(taskInterval);
        this.runner = new NodeLabelScriptRunner(nodeLabelsScriptPath, scriptArgs, scriptTimeout, this);
        super.serviceInit(conf);
    }

    @Override
    public void cleanUp() {
        if (this.runner != null) {
            this.runner.cleanUp();
        }
    }

    @Override
    public TimerTask createTimerTask() {
        return this.runner;
    }

    private static class NodeLabelScriptRunner
    extends NodeDescriptorsScriptRunner<NodeLabel> {
        NodeLabelScriptRunner(String scriptPath, String[] scriptArgs, long scriptTimeout, ScriptBasedNodeLabelsProvider provider) {
            super(scriptPath, scriptArgs, scriptTimeout, provider);
        }

        @Override
        Set<NodeLabel> parseOutput(String scriptOutput) throws IOException {
            String[] splits;
            String nodePartitionLabel = null;
            for (String line : splits = scriptOutput.split("\n")) {
                String trimmedLine = line.trim();
                if (!trimmedLine.startsWith(ScriptBasedNodeLabelsProvider.NODE_LABEL_PARTITION_PATTERN)) continue;
                nodePartitionLabel = trimmedLine.substring(ScriptBasedNodeLabelsProvider.NODE_LABEL_PARTITION_PATTERN.length());
            }
            return AbstractNodeDescriptorsProvider.convertToNodeLabelSet(nodePartitionLabel);
        }
    }
}

