/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.terracotta.context.extended;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.org.terracotta.context.ContextManager;
import org.apache.hadoop.shaded.org.terracotta.context.TreeNode;
import org.apache.hadoop.shaded.org.terracotta.context.extended.OperationStatisticDescriptor;
import org.apache.hadoop.shaded.org.terracotta.context.extended.RegisteredCompoundStatistic;
import org.apache.hadoop.shaded.org.terracotta.context.extended.RegisteredCounterStatistic;
import org.apache.hadoop.shaded.org.terracotta.context.extended.RegisteredRatioStatistic;
import org.apache.hadoop.shaded.org.terracotta.context.extended.RegisteredSizeStatistic;
import org.apache.hadoop.shaded.org.terracotta.context.extended.RegisteredStatistic;
import org.apache.hadoop.shaded.org.terracotta.context.extended.RegistrationType;
import org.apache.hadoop.shaded.org.terracotta.context.extended.ValueStatisticDescriptor;
import org.apache.hadoop.shaded.org.terracotta.context.query.Matcher;
import org.apache.hadoop.shaded.org.terracotta.context.query.Matchers;
import org.apache.hadoop.shaded.org.terracotta.context.query.QueryBuilder;
import org.apache.hadoop.shaded.org.terracotta.statistics.OperationStatistic;
import org.apache.hadoop.shaded.org.terracotta.statistics.Time;
import org.apache.hadoop.shaded.org.terracotta.statistics.ValueStatistic;
import org.apache.hadoop.shaded.org.terracotta.statistics.extended.CompoundOperation;
import org.apache.hadoop.shaded.org.terracotta.statistics.extended.CompoundOperationImpl;
import org.apache.hadoop.shaded.org.terracotta.statistics.extended.ExpiringSampledStatistic;
import org.apache.hadoop.shaded.org.terracotta.statistics.extended.Result;
import org.apache.hadoop.shaded.org.terracotta.statistics.extended.SampledStatistic;
import org.apache.hadoop.shaded.org.terracotta.statistics.extended.StatisticType;

public class StatisticsRegistry {
    private final Object contextObject;
    private final Map<String, RegisteredStatistic> registrations = new ConcurrentHashMap<String, RegisteredStatistic>();
    private final ScheduledExecutorService executor;
    private final Runnable disableTask;
    private volatile long timeToDisable;
    private volatile TimeUnit timeToDisableUnit;
    private volatile ScheduledFuture<?> disableStatus;
    private final long averageWindowDuration;
    private final TimeUnit averageWindowUnit;
    private final int historySize;
    private final long historyInterval;
    private final TimeUnit historyIntervalUnit;

    public StatisticsRegistry(Object contextObject, ScheduledExecutorService executor, long averageWindowDuration, TimeUnit averageWindowUnit, int historySize, long historyInterval, TimeUnit historyIntervalUnit, long timeToDisable, TimeUnit timeToDisableUnit) {
        this.contextObject = contextObject;
        this.averageWindowDuration = averageWindowDuration;
        this.averageWindowUnit = averageWindowUnit;
        this.historySize = historySize;
        this.historyInterval = historyInterval;
        this.historyIntervalUnit = historyIntervalUnit;
        this.executor = executor;
        this.timeToDisable = timeToDisable;
        this.timeToDisableUnit = timeToDisableUnit;
        this.disableTask = this.createDisableTask();
        this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, timeToDisable, timeToDisable, timeToDisableUnit);
    }

    private Runnable createDisableTask() {
        return new Runnable(){

            @Override
            public void run() {
                long expireThreshold = Time.absoluteTime() - StatisticsRegistry.this.timeToDisableUnit.toMillis(StatisticsRegistry.this.timeToDisable);
                for (RegisteredStatistic registeredStatistic : StatisticsRegistry.this.registrations.values()) {
                    registeredStatistic.getSupport().expire(expireThreshold);
                }
            }
        };
    }

    public synchronized void setTimeToDisable(long time, TimeUnit unit) {
        this.timeToDisable = time;
        this.timeToDisableUnit = unit;
        if (this.disableStatus != null) {
            this.disableStatus.cancel(false);
            this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, this.timeToDisable, this.timeToDisable, this.timeToDisableUnit);
        }
    }

    public synchronized void setAlwaysOn(boolean enabled) {
        if (enabled) {
            if (this.disableStatus != null) {
                this.disableStatus.cancel(false);
                this.disableStatus = null;
            }
            for (RegisteredStatistic registeredStatistic : this.registrations.values()) {
                registeredStatistic.getSupport().setAlwaysOn(true);
            }
        } else {
            if (this.disableStatus == null) {
                this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, 0L, this.timeToDisable, this.timeToDisableUnit);
            }
            for (RegisteredStatistic registeredStatistic : this.registrations.values()) {
                registeredStatistic.getSupport().setAlwaysOn(false);
            }
        }
    }

    public void registerSize(String name, ValueStatisticDescriptor descriptor) {
        this.registerStatistic(name, descriptor, StatisticType.SIZE, new Function<ExpiringSampledStatistic<Long>, RegisteredStatistic>(){

            @Override
            public RegisteredStatistic apply(ExpiringSampledStatistic<Long> expiringSampledStatistic) {
                return new RegisteredSizeStatistic(expiringSampledStatistic);
            }
        });
    }

    public void registerCounter(String name, ValueStatisticDescriptor descriptor) {
        this.registerStatistic(name, descriptor, StatisticType.COUNTER, new Function<ExpiringSampledStatistic<Long>, RegisteredStatistic>(){

            @Override
            public RegisteredStatistic apply(ExpiringSampledStatistic<Long> expiringSampledStatistic) {
                return new RegisteredCounterStatistic(expiringSampledStatistic);
            }
        });
    }

    private <N extends Number> void registerStatistic(String name, ValueStatisticDescriptor descriptor, StatisticType type, Function<ExpiringSampledStatistic<N>, RegisteredStatistic> registeredStatisticFunction) {
        HashMap<String, RegisteredStatistic> registeredStatistics = new HashMap<String, RegisteredStatistic>();
        Map<String, ValueStatistic<N>> valueStatistics = StatisticsRegistry.findValueStatistics(this.contextObject, name, descriptor.getObserverName(), descriptor.getTags());
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry<String, ValueStatistic<N>> entry : valueStatistics.entrySet()) {
            String key = entry.getKey();
            ValueStatistic<N> value = entry.getValue();
            if (this.registrations.containsKey(key)) {
                duplicates.add(key);
            }
            ExpiringSampledStatistic<N> expiringSampledStatistic = new ExpiringSampledStatistic<N>(value, this.executor, this.historySize, this.historyInterval, this.historyIntervalUnit, type);
            RegisteredStatistic registeredStatistic = registeredStatisticFunction.apply(expiringSampledStatistic);
            registeredStatistics.put(key, registeredStatistic);
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Found duplicate value statistic(s) " + duplicates);
        }
        this.registrations.putAll(registeredStatistics);
    }

    public <T extends Enum<T>> void registerCompoundOperations(String name, OperationStatisticDescriptor<T> descriptor, EnumSet<T> compound) {
        Map<String, CompoundOperation<T>> compoundOperations = this.createCompoundOperations(name, descriptor.getObserverName(), descriptor.getTags(), descriptor.getType());
        HashMap<String, RegisteredCompoundStatistic<T>> registeredStatistics = new HashMap<String, RegisteredCompoundStatistic<T>>();
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry<String, CompoundOperation<T>> entry : compoundOperations.entrySet()) {
            String key = entry.getKey();
            if (this.registrations.containsKey(key)) {
                duplicates.add(key);
            }
            registeredStatistics.put(key, new RegisteredCompoundStatistic<T>(entry.getValue(), compound));
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Found duplicate operation statistic(s) " + duplicates);
        }
        for (CompoundOperation compoundOperation : compoundOperations.values()) {
            compoundOperation.compound(compound);
        }
        this.registrations.putAll(registeredStatistics);
    }

    public <T extends Enum<T>> void registerRatios(String name, OperationStatisticDescriptor<T> descriptor, EnumSet<T> ratioNumerator, EnumSet<T> ratioDenominator) {
        Map<String, CompoundOperation<T>> compoundOperations = this.createCompoundOperations(name, descriptor.getObserverName(), descriptor.getTags(), descriptor.getType());
        HashMap<String, RegisteredRatioStatistic<T>> registeredStatistics = new HashMap<String, RegisteredRatioStatistic<T>>();
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry<String, CompoundOperation<T>> entry : compoundOperations.entrySet()) {
            String key = entry.getKey();
            if (this.registrations.containsKey(key)) {
                duplicates.add(key);
            }
            registeredStatistics.put(key, new RegisteredRatioStatistic<T>(entry.getValue(), ratioNumerator, ratioDenominator));
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Found duplicate operation statistic(s) " + duplicates);
        }
        for (CompoundOperation compoundOperation : compoundOperations.values()) {
            compoundOperation.ratioOf(ratioNumerator, ratioDenominator);
        }
        this.registrations.putAll(registeredStatistics);
    }

    public Map<String, RegisteredStatistic> getRegistrations() {
        return Collections.unmodifiableMap(this.registrations);
    }

    public void clearRegistrations() {
        this.registrations.clear();
    }

    public SampledStatistic<? extends Number> findSampledStatistic(String statisticName) {
        RegisteredStatistic registeredStatistic = this.registrations.get(statisticName);
        if (registeredStatistic != null) {
            switch (registeredStatistic.getType()) {
                case COUNTER: {
                    return ((RegisteredCounterStatistic)registeredStatistic).getSampledStatistic();
                }
                case RATIO: {
                    return ((RegisteredRatioStatistic)registeredStatistic).getSampledStatistic();
                }
                case SIZE: {
                    return ((RegisteredSizeStatistic)registeredStatistic).getSampledStatistic();
                }
            }
        }
        return null;
    }

    public SampledStatistic<? extends Number> findSampledCompoundStatistic(String statisticName, StatisticType statisticType) {
        RegisteredStatistic registeredStatistic = this.registrations.get(statisticName);
        if (registeredStatistic != null && registeredStatistic.getType() == RegistrationType.COMPOUND) {
            Result result = ((RegisteredCompoundStatistic)registeredStatistic).getResult();
            switch (statisticType) {
                case COUNTER: {
                    return result.count();
                }
                case RATE: {
                    return result.rate();
                }
                case LATENCY_MIN: {
                    return result.latency().minimum();
                }
                case LATENCY_MAX: {
                    return result.latency().maximum();
                }
                case LATENCY_AVG: {
                    return result.latency().average();
                }
            }
        }
        return null;
    }

    private <T extends Enum<T>> Map<String, CompoundOperation<T>> createCompoundOperations(String name, String observerName, Set<String> tags, Class<T> type) {
        HashMap<String, CompoundOperation<T>> result = new HashMap<String, CompoundOperation<T>>();
        Map<String, OperationStatistic<T>> operationObservers = StatisticsRegistry.findOperationStatistics(this.contextObject, name, type, observerName, tags);
        if (operationObservers.isEmpty()) {
            throw new IllegalArgumentException("Required statistic observer '" + observerName + "' with tags " + tags + " and type '" + type + "' not found under '" + this.contextObject + "'");
        }
        for (Map.Entry<String, OperationStatistic<T>> entry : operationObservers.entrySet()) {
            CompoundOperationImpl<T> newOperation = new CompoundOperationImpl<T>(entry.getValue(), type, this.averageWindowDuration, this.averageWindowUnit, this.executor, this.historySize, this.historyInterval, this.historyIntervalUnit);
            result.put(entry.getKey(), newOperation);
        }
        return result;
    }

    private static <T extends Enum<T>> Map<String, OperationStatistic<T>> findOperationStatistics(Object contextObject, String name, Class<T> type, String observerName, final Set<String> tags) {
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("type", type), Matchers.hasAttribute("name", observerName), Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Set<String>>(){

            @Override
            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(tags);
            }
        }))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(OperationStatistic.class)))).build().execute(Collections.singleton(ContextManager.nodeFor(contextObject)));
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, OperationStatistic<T>> observers = new HashMap<String, OperationStatistic<T>>();
        for (TreeNode node : result) {
            String completeName;
            OperationStatistic existing;
            String discriminator = null;
            Map properties = (Map)node.getContext().attributes().get("properties");
            if (properties != null && properties.containsKey("discriminator")) {
                discriminator = properties.get("discriminator").toString();
            }
            if ((existing = observers.put(completeName = (discriminator == null ? "" : discriminator + ":") + name, (OperationStatistic)node.getContext().attributes().get("this"))) == null) continue;
            throw new IllegalStateException("Duplicate OperationStatistic found for '" + completeName + "'");
        }
        return observers;
    }

    private static <N extends Number> Map<String, ValueStatistic<N>> findValueStatistics(Object contextObject, String name, String observerName, final Set<String> tags) {
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", observerName), Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Set<String>>(){

            @Override
            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(tags);
            }
        }))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(ValueStatistic.class)))).build().execute(Collections.singleton(ContextManager.nodeFor(contextObject)));
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ValueStatistic<N>> observers = new HashMap<String, ValueStatistic<N>>();
        for (TreeNode node : result) {
            String completeName;
            ValueStatistic existing;
            String discriminator = null;
            Map properties = (Map)node.getContext().attributes().get("properties");
            if (properties != null && properties.containsKey("discriminator")) {
                discriminator = properties.get("discriminator").toString();
            }
            if ((existing = observers.put(completeName = (discriminator == null ? "" : discriminator + ":") + name, (ValueStatistic)node.getContext().attributes().get("this"))) == null) continue;
            throw new IllegalStateException("Duplicate ValueStatistic found for '" + completeName + "'");
        }
        return observers;
    }

    private static interface Function<T, R> {
        public R apply(T var1);
    }
}

