/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.streams;

import org.apache.hadoop.shaded.org.glassfish.grizzly.TransformationException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Transformer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.streams.Stream;
import org.apache.hadoop.shaded.org.glassfish.grizzly.streams.StreamReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.ResultAware;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.conditions.Condition;

public class StreamDecodeCondition<E>
implements Condition {
    private final StreamReader streamReader;
    private final Transformer<Stream, E> decoder;
    private final ResultAware<E> resultAware;

    public StreamDecodeCondition(StreamReader streamReader, Transformer<Stream, E> decoder, ResultAware<E> resultAware) {
        this.streamReader = streamReader;
        this.decoder = decoder;
        this.resultAware = resultAware;
    }

    @Override
    public boolean check() {
        TransformationResult<Stream, E> result = this.decoder.transform(this.streamReader.getConnection(), this.streamReader);
        TransformationResult.Status status = result.getStatus();
        if (status == TransformationResult.Status.COMPLETE) {
            this.resultAware.setResult(result.getMessage());
            return true;
        }
        if (status == TransformationResult.Status.INCOMPLETE) {
            return false;
        }
        throw new TransformationException(result.getErrorCode() + ": " + result.getErrorDescription());
    }
}

