/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.ByteChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.CharChunk;

public final class StringCache {
    private static final Logger logger = Grizzly.logger(StringCache.class);
    static boolean byteEnabled = "true".equals(System.getProperty("tomcat.util.buf.StringCache.byte.enabled", "false"));
    static boolean charEnabled = "true".equals(System.getProperty("tomcat.util.buf.StringCache.char.enabled", "false"));
    static int trainThreshold = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.trainThreshold", "20000"));
    static int cacheSize = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.cacheSize", "200"));
    static final HashMap<ByteEntry, int[]> bcStats = new HashMap(cacheSize);
    static int bcCount = 0;
    static ByteEntry[] bcCache = null;
    static final HashMap<CharEntry, int[]> ccStats = new HashMap(cacheSize);
    static int ccCount = 0;
    static CharEntry[] ccCache = null;
    static int accessCount = 0;
    static int hitCount = 0;

    public static int getCacheSize() {
        return cacheSize;
    }

    public static void setCacheSize(int cacheSize) {
        StringCache.cacheSize = cacheSize;
    }

    public static boolean getByteEnabled() {
        return byteEnabled;
    }

    public static void setByteEnabled(boolean byteEnabled) {
        StringCache.byteEnabled = byteEnabled;
    }

    public static boolean getCharEnabled() {
        return charEnabled;
    }

    public static void setCharEnabled(boolean charEnabled) {
        StringCache.charEnabled = charEnabled;
    }

    public static int getTrainThreshold() {
        return trainThreshold;
    }

    public static void setTrainThreshold(int trainThreshold) {
        StringCache.trainThreshold = trainThreshold;
    }

    public static int getAccessCount() {
        return accessCount;
    }

    public static int getHitCount() {
        return hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        hitCount = 0;
        accessCount = 0;
        HashMap<Object, int[]> hashMap = bcStats;
        synchronized (hashMap) {
            bcCache = null;
            bcCount = 0;
        }
        hashMap = ccStats;
        synchronized (hashMap) {
            ccCache = null;
            ccCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ByteChunk bc) {
        if (bcCache == null) {
            String value = bc.toStringInternal();
            if (byteEnabled) {
                HashMap<ByteEntry, int[]> hashMap = bcStats;
                synchronized (hashMap) {
                    if (bcCache != null) {
                        return value;
                    }
                    if (bcCount > trainThreshold) {
                        long t1 = System.currentTimeMillis();
                        TreeMap<Integer, ArrayList<ByteEntry>> tempMap = new TreeMap<Integer, ArrayList<ByteEntry>>();
                        for (ByteEntry entry : bcStats.keySet()) {
                            int[] countA = bcStats.get(entry);
                            Integer count = countA[0];
                            ArrayList<ByteEntry> list = (ArrayList<ByteEntry>)tempMap.get(count);
                            if (list == null) {
                                list = new ArrayList<ByteEntry>();
                                tempMap.put(count, list);
                            }
                            list.add(entry);
                        }
                        int size = bcStats.size();
                        if (size > cacheSize) {
                            size = cacheSize;
                        }
                        ByteEntry[] tempbcCache = new ByteEntry[size];
                        ByteChunk tempChunk = new ByteChunk();
                        int n = 0;
                        while (n < size) {
                            Object key = tempMap.lastKey();
                            ArrayList list = (ArrayList)tempMap.get(key);
                            for (int i = 0; i < list.size() && n < size; ++n, ++i) {
                                ByteEntry entry = (ByteEntry)list.get(i);
                                tempChunk.setBytes(entry.name, 0, entry.name.length);
                                int insertPos = StringCache.findClosest(tempChunk, tempbcCache, n);
                                if (insertPos == n) {
                                    tempbcCache[n + 1] = entry;
                                    continue;
                                }
                                System.arraycopy(tempbcCache, insertPos + 1, tempbcCache, insertPos + 2, n - insertPos - 1);
                                tempbcCache[insertPos + 1] = entry;
                            }
                            tempMap.remove(key);
                        }
                        bcCount = 0;
                        bcStats.clear();
                        bcCache = tempbcCache;
                        if (logger.isLoggable(Level.FINEST)) {
                            long t2 = System.currentTimeMillis();
                            logger.log(Level.FINEST, "ByteCache generation time: " + (t2 - t1) + "ms");
                        }
                    } else {
                        ++bcCount;
                        ByteEntry entry = new ByteEntry();
                        entry.value = value;
                        int[] count = bcStats.get(entry);
                        if (count == null) {
                            int end = bc.getEnd();
                            int start = bc.getStart();
                            entry.name = new byte[bc.getLength()];
                            System.arraycopy(bc.getBuffer(), start, entry.name, 0, end - start);
                            entry.charset = bc.getCharset();
                            count = new int[]{1};
                            bcStats.put(entry, count);
                        } else {
                            count[0] = count[0] + 1;
                        }
                    }
                }
            }
            return value;
        }
        ++accessCount;
        String result = StringCache.find(bc);
        if (result == null) {
            return bc.toStringInternal();
        }
        ++hitCount;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(CharChunk cc) {
        if (ccCache == null) {
            String value = cc.toStringInternal();
            if (charEnabled) {
                HashMap<CharEntry, int[]> hashMap = ccStats;
                synchronized (hashMap) {
                    if (ccCache != null) {
                        return value;
                    }
                    if (ccCount > trainThreshold) {
                        long t1 = System.currentTimeMillis();
                        TreeMap<Integer, ArrayList<CharEntry>> tempMap = new TreeMap<Integer, ArrayList<CharEntry>>();
                        for (CharEntry entry : ccStats.keySet()) {
                            int[] countA = ccStats.get(entry);
                            Integer count = countA[0];
                            ArrayList<CharEntry> list = (ArrayList<CharEntry>)tempMap.get(count);
                            if (list == null) {
                                list = new ArrayList<CharEntry>();
                                tempMap.put(count, list);
                            }
                            list.add(entry);
                        }
                        int size = ccStats.size();
                        if (size > cacheSize) {
                            size = cacheSize;
                        }
                        CharEntry[] tempccCache = new CharEntry[size];
                        CharChunk tempChunk = new CharChunk();
                        int n = 0;
                        while (n < size) {
                            Object key = tempMap.lastKey();
                            ArrayList list = (ArrayList)tempMap.get(key);
                            for (int i = 0; i < list.size() && n < size; ++n, ++i) {
                                CharEntry entry = (CharEntry)list.get(i);
                                tempChunk.setChars(entry.name, 0, entry.name.length);
                                int insertPos = StringCache.findClosest(tempChunk, tempccCache, n);
                                if (insertPos == n) {
                                    tempccCache[n + 1] = entry;
                                    continue;
                                }
                                System.arraycopy(tempccCache, insertPos + 1, tempccCache, insertPos + 2, n - insertPos - 1);
                                tempccCache[insertPos + 1] = entry;
                            }
                            tempMap.remove(key);
                        }
                        ccCount = 0;
                        ccStats.clear();
                        ccCache = tempccCache;
                        if (logger.isLoggable(Level.FINEST)) {
                            long t2 = System.currentTimeMillis();
                            logger.log(Level.FINEST, "CharCache generation time: " + (t2 - t1) + "ms");
                        }
                    } else {
                        ++ccCount;
                        CharEntry entry = new CharEntry();
                        entry.value = value;
                        int[] count = ccStats.get(entry);
                        if (count == null) {
                            int end = cc.getEnd();
                            int start = cc.getStart();
                            entry.name = new char[cc.getLength()];
                            System.arraycopy(cc.getBuffer(), start, entry.name, 0, end - start);
                            count = new int[]{1};
                            ccStats.put(entry, count);
                        } else {
                            count[0] = count[0] + 1;
                        }
                    }
                }
            }
            return value;
        }
        ++accessCount;
        String result = StringCache.find(cc);
        if (result == null) {
            return cc.toStringInternal();
        }
        ++hitCount;
        return result;
    }

    protected static int compare(ByteChunk name, byte[] compareTo) {
        int len;
        int result = 0;
        byte[] b = name.getBuffer();
        int start = name.getStart();
        int end = name.getEnd();
        if (end - start < (len = compareTo.length)) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (b[i + start] > compareTo[i]) {
                result = 1;
                continue;
            }
            if (b[i + start] >= compareTo[i]) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length > end - start) {
                result = -1;
            } else if (compareTo.length < end - start) {
                result = 1;
            }
        }
        return result;
    }

    protected static String find(ByteChunk name) {
        int pos = StringCache.findClosest(name, bcCache, bcCache.length);
        if (pos < 0 || StringCache.compare(name, StringCache.bcCache[pos].name) != 0 || !name.getCharset().equals(StringCache.bcCache[pos].charset)) {
            return null;
        }
        return StringCache.bcCache[pos].value;
    }

    protected static int findClosest(ByteChunk name, ByteEntry[] array, int len) {
        int a = 0;
        int b = len - 1;
        if (b == -1) {
            return -1;
        }
        if (StringCache.compare(name, array[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = StringCache.compare(name, array[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = StringCache.compare(name, array[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    protected static int compare(CharChunk name, char[] compareTo) {
        int len;
        int result = 0;
        char[] c = name.getBuffer();
        int start = name.getStart();
        int end = name.getEnd();
        if (end - start < (len = compareTo.length)) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (c[i + start] > compareTo[i]) {
                result = 1;
                continue;
            }
            if (c[i + start] >= compareTo[i]) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length > end - start) {
                result = -1;
            } else if (compareTo.length < end - start) {
                result = 1;
            }
        }
        return result;
    }

    protected static String find(CharChunk name) {
        int pos = StringCache.findClosest(name, ccCache, ccCache.length);
        if (pos < 0 || StringCache.compare(name, StringCache.ccCache[pos].name) != 0) {
            return null;
        }
        return StringCache.ccCache[pos].value;
    }

    protected static int findClosest(CharChunk name, CharEntry[] array, int len) {
        int a = 0;
        int b = len - 1;
        if (b == -1) {
            return -1;
        }
        if (StringCache.compare(name, array[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = StringCache.compare(name, array[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = StringCache.compare(name, array[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    protected static class CharEntry {
        public char[] name = null;
        public String value = null;

        protected CharEntry() {
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CharEntry && this.value.equals(((CharEntry)obj).value);
        }
    }

    protected static class ByteEntry {
        public byte[] name = null;
        public Charset charset = null;
        public String value = null;

        protected ByteEntry() {
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ByteEntry && this.value.equals(((ByteEntry)obj).value);
        }
    }
}

