/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.javax.websocket.Decoder;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.util.ReflectUtils;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.MessageType;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata.CoderMetadataSet;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata.DecoderMetadata;

public class DecoderMetadataSet
extends CoderMetadataSet<Decoder, DecoderMetadata> {
    @Override
    protected List<DecoderMetadata> discover(Class<? extends Decoder> decoder) {
        Class<?> objType;
        ArrayList<DecoderMetadata> metadatas = new ArrayList<DecoderMetadata>();
        if (Decoder.Binary.class.isAssignableFrom(decoder)) {
            objType = this.getDecoderType(decoder, Decoder.Binary.class);
            metadatas.add(new DecoderMetadata(decoder, objType, MessageType.BINARY, false));
        }
        if (Decoder.BinaryStream.class.isAssignableFrom(decoder)) {
            objType = this.getDecoderType(decoder, Decoder.BinaryStream.class);
            metadatas.add(new DecoderMetadata(decoder, objType, MessageType.BINARY, true));
        }
        if (Decoder.Text.class.isAssignableFrom(decoder)) {
            objType = this.getDecoderType(decoder, Decoder.Text.class);
            metadatas.add(new DecoderMetadata(decoder, objType, MessageType.TEXT, false));
        }
        if (Decoder.TextStream.class.isAssignableFrom(decoder)) {
            objType = this.getDecoderType(decoder, Decoder.TextStream.class);
            metadatas.add(new DecoderMetadata(decoder, objType, MessageType.TEXT, true));
        }
        if (!ReflectUtils.isDefaultConstructable(decoder)) {
            throw new InvalidSignatureException("Decoder must have public, no-args constructor: " + decoder.getName());
        }
        if (metadatas.size() <= 0) {
            throw new InvalidSignatureException("Not a valid Decoder class: " + decoder.getName());
        }
        return metadatas;
    }

    private Class<?> getDecoderType(Class<? extends Decoder> decoder, Class<?> interfaceClass) {
        Class decoderClass = ReflectUtils.findGenericClassFor(decoder, interfaceClass);
        if (decoderClass == null) {
            StringBuilder err = new StringBuilder();
            err.append("Invalid type declared for interface ");
            err.append(interfaceClass.getName());
            err.append(" on class ");
            err.append(decoder);
            throw new InvalidWebSocketException(err.toString());
        }
        return decoderClass;
    }

    protected final void register(Class<?> type, Class<? extends Decoder> decoder, MessageType msgType, boolean streamed) {
        DecoderMetadata metadata = new DecoderMetadata(decoder, type, msgType, streamed);
        this.trackMetadata(metadata);
    }
}

