/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints;

import java.util.Map;
import org.apache.hadoop.shaded.javax.websocket.CloseReason;
import org.apache.hadoop.shaded.javax.websocket.EndpointConfig;
import org.apache.hadoop.shaded.javax.websocket.Session;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.Frame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.CloseInfo;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.WebSocketSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.events.AbstractEventDriver;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;

public abstract class AbstractJsrEventDriver
extends AbstractEventDriver {
    protected final EndpointMetadata metadata;
    protected final EndpointConfig config;
    protected JsrSession jsrsession;
    private boolean hasCloseBeenCalled = false;

    public AbstractJsrEventDriver(WebSocketPolicy policy, EndpointInstance endpointInstance) {
        super(policy, endpointInstance.getEndpoint());
        this.config = endpointInstance.getConfig();
        this.metadata = endpointInstance.getMetadata();
    }

    public EndpointConfig getConfig() {
        return this.config;
    }

    public Session getJsrSession() {
        return this.jsrsession;
    }

    public EndpointMetadata getMetadata() {
        return this.metadata;
    }

    public abstract void init(JsrSession var1);

    public final void onClose(CloseInfo close) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        CloseReason.CloseCode closecode = CloseReason.CloseCodes.getCloseCode(close.getStatusCode());
        CloseReason closereason = new CloseReason(closecode, close.getReason());
        this.onClose(closereason);
        if (this.jsrsession != null) {
            this.jsrsession.destroy();
        }
    }

    protected abstract void onClose(CloseReason var1);

    public void onFrame(Frame frame) {
    }

    public final void openSession(WebSocketSession session) {
        this.jsrsession = (JsrSession)session;
        this.jsrsession.init(this.config);
        this.init(this.jsrsession);
        super.openSession(session);
    }

    public void setEndpointconfig(EndpointConfig endpointconfig) {
        throw new RuntimeException("Why are you reconfiguring the endpoint?");
    }

    public abstract void setPathParameters(Map<String, String> var1);
}

