/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter;

import org.apache.hadoop.shaded.com.sun.jersey.api.ParamException;
import org.apache.hadoop.shaded.com.sun.jersey.api.core.HttpContext;
import org.apache.hadoop.shaded.com.sun.jersey.api.model.Parameter;
import org.apache.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentContext;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.BaseParamInjectableProvider;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.ExtractorContainerException;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import org.apache.hadoop.shaded.com.sun.jersey.spi.inject.Injectable;
import org.apache.hadoop.shaded.javax.ws.rs.CookieParam;
import org.apache.hadoop.shaded.javax.ws.rs.core.Cookie;

public final class CookieParamInjectableProvider
extends BaseParamInjectableProvider<CookieParam> {
    public CookieParamInjectableProvider(MultivaluedParameterExtractorProvider w) {
        super(w);
    }

    public Injectable getInjectable(ComponentContext ic, CookieParam a, Parameter c) {
        String parameterName = c.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        if (c.getParameterClass() == Cookie.class) {
            return new CookieTypeParamInjectable(parameterName);
        }
        MultivaluedParameterExtractor e = this.get(c);
        if (e == null) {
            return null;
        }
        return new CookieParamInjectable(e);
    }

    private static final class CookieTypeParamInjectable
    extends AbstractHttpContextInjectable<Cookie> {
        private final String name;

        CookieTypeParamInjectable(String name) {
            this.name = name;
        }

        @Override
        public Cookie getValue(HttpContext context) {
            return (Cookie)context.getRequest().getCookies().get(this.name);
        }
    }

    private static final class CookieParamInjectable
    extends AbstractHttpContextInjectable<Object> {
        private final MultivaluedParameterExtractor extractor;

        CookieParamInjectable(MultivaluedParameterExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        public Object getValue(HttpContext context) {
            try {
                return this.extractor.extract(context.getRequest().getCookieNameValueMap());
            }
            catch (ExtractorContainerException e) {
                throw new ParamException.CookieParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultStringValue());
            }
        }
    }
}

