/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.internal;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.inject.Key;
import org.apache.hadoop.shaded.com.google.inject.MembersInjector;
import org.apache.hadoop.shaded.com.google.inject.Provider;
import org.apache.hadoop.shaded.com.google.inject.TypeLiteral;
import org.apache.hadoop.shaded.com.google.inject.internal.Errors;
import org.apache.hadoop.shaded.com.google.inject.internal.Lookups;
import org.apache.hadoop.shaded.com.google.inject.internal.MethodAspect;
import org.apache.hadoop.shaded.com.google.inject.matcher.Matcher;
import org.apache.hadoop.shaded.com.google.inject.matcher.Matchers;
import org.apache.hadoop.shaded.com.google.inject.spi.InjectionListener;
import org.apache.hadoop.shaded.com.google.inject.spi.Message;
import org.apache.hadoop.shaded.com.google.inject.spi.TypeEncounter;
import org.apache.hadoop.shaded.org.aopalliance.intercept.MethodInterceptor;

final class EncounterImpl<T>
implements TypeEncounter<T> {
    private final Errors errors;
    private final Lookups lookups;
    private List<MembersInjector<? super T>> membersInjectors;
    private List<InjectionListener<? super T>> injectionListeners;
    private List<MethodAspect> aspects;
    private boolean valid = true;

    EncounterImpl(Errors errors, Lookups lookups) {
        this.errors = errors;
        this.lookups = lookups;
    }

    void invalidate() {
        this.valid = false;
    }

    ImmutableList<MethodAspect> getAspects() {
        return this.aspects == null ? ImmutableList.of() : ImmutableList.copyOf(this.aspects);
    }

    @Override
    public void bindInterceptor(Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        Preconditions.checkState((boolean)this.valid, (Object)"Encounters may not be used after hear() returns.");
        if (this.aspects == null) {
            this.aspects = Lists.newArrayList();
        }
        this.aspects.add(new MethodAspect(Matchers.any(), methodMatcher, interceptors));
    }

    ImmutableSet<MembersInjector<? super T>> getMembersInjectors() {
        return this.membersInjectors == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.membersInjectors);
    }

    ImmutableSet<InjectionListener<? super T>> getInjectionListeners() {
        return this.injectionListeners == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.injectionListeners);
    }

    @Override
    public void register(MembersInjector<? super T> membersInjector) {
        Preconditions.checkState((boolean)this.valid, (Object)"Encounters may not be used after hear() returns.");
        if (this.membersInjectors == null) {
            this.membersInjectors = Lists.newArrayList();
        }
        this.membersInjectors.add(membersInjector);
    }

    @Override
    public void register(InjectionListener<? super T> injectionListener) {
        Preconditions.checkState((boolean)this.valid, (Object)"Encounters may not be used after hear() returns.");
        if (this.injectionListeners == null) {
            this.injectionListeners = Lists.newArrayList();
        }
        this.injectionListeners.add(injectionListener);
    }

    @Override
    public void addError(String message, Object ... arguments) {
        Preconditions.checkState((boolean)this.valid, (Object)"Encounters may not be used after hear() returns.");
        this.errors.addMessage(message, arguments);
    }

    @Override
    public void addError(Throwable t) {
        Preconditions.checkState((boolean)this.valid, (Object)"Encounters may not be used after hear() returns.");
        this.errors.errorInUserCode(t, "An exception was caught and reported. Message: %s", t.getMessage());
    }

    @Override
    public void addError(Message message) {
        Preconditions.checkState((boolean)this.valid, (Object)"Encounters may not be used after hear() returns.");
        this.errors.addMessage(message);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        Preconditions.checkState((boolean)this.valid, (Object)"Encounters may not be used after hear() returns.");
        return this.lookups.getProvider(key);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Preconditions.checkState((boolean)this.valid, (Object)"Encounters may not be used after hear() returns.");
        return this.lookups.getMembersInjector(typeLiteral);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.getMembersInjector(TypeLiteral.get(type));
    }
}

