/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.JobHistoryFileParser;
import org.apache.hadoop.mapreduce.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobHistoryFileReplayHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JobHistoryFileReplayHelper.class);
    static final String PROCESSING_PATH = "processing path";
    static final String REPLAY_MODE = "replay mode";
    static final int WRITE_ALL_AT_ONCE = 1;
    static final int WRITE_PER_ENTITY = 2;
    static final int REPLAY_MODE_DEFAULT = 1;
    private static Pattern JOB_ID_PARSER = Pattern.compile("^(job_[0-9]+_([0-9]+)).*");
    JobHistoryFileParser parser;
    int replayMode;
    Collection<JobFiles> jobFiles;

    JobHistoryFileReplayHelper(Mapper.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        int taskId = context.getTaskAttemptID().getTaskID().getId();
        int size = conf.getInt("mapreduce.job.maps", 1);
        this.replayMode = conf.getInt(REPLAY_MODE, 1);
        String processingDir = conf.get(PROCESSING_PATH);
        Path processingPath = new Path(processingDir);
        FileSystem processingFs = processingPath.getFileSystem(conf);
        this.parser = new JobHistoryFileParser(processingFs);
        this.jobFiles = this.selectJobFiles(processingFs, processingPath, taskId, size);
    }

    public int getReplayMode() {
        return this.replayMode;
    }

    public Collection<JobFiles> getJobFiles() {
        return this.jobFiles;
    }

    public JobHistoryFileParser getParser() {
        return this.parser;
    }

    private Collection<JobFiles> selectJobFiles(FileSystem fs, Path processingRoot, int i, int size) throws IOException {
        HashMap<String, JobFiles> jobs = new HashMap<String, JobFiles>();
        RemoteIterator it = fs.listFiles(processingRoot, true);
        while (it.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)it.next();
            Path path = status.getPath();
            String fileName = path.getName();
            Matcher m = JOB_ID_PARSER.matcher(fileName);
            if (!m.matches()) continue;
            String jobId = m.group(1);
            int lastId = Integer.parseInt(m.group(2));
            int mod = lastId % size;
            if (mod != i) continue;
            LOG.info("this mapper will process file " + fileName);
            JobFiles jobFiles = (JobFiles)jobs.get(jobId);
            if (jobFiles == null) {
                jobFiles = new JobFiles(jobId);
                jobs.put(jobId, jobFiles);
            }
            this.setFilePath(fileName, path, jobFiles);
        }
        return jobs.values();
    }

    private void setFilePath(String fileName, Path path, JobFiles jobFiles) {
        FileType type = this.getFileType(fileName);
        switch (type) {
            case JOB_HISTORY_FILE: {
                if (jobFiles.getJobHistoryFilePath() == null) {
                    jobFiles.setJobHistoryFilePath(path);
                    break;
                }
                LOG.warn("we already have the job history file " + jobFiles.getJobHistoryFilePath() + ": skipping " + path);
                break;
            }
            case JOB_CONF_FILE: {
                if (jobFiles.getJobConfFilePath() == null) {
                    jobFiles.setJobConfFilePath(path);
                    break;
                }
                LOG.warn("we already have the job conf file " + jobFiles.getJobConfFilePath() + ": skipping " + path);
                break;
            }
            case UNKNOWN: {
                LOG.warn("unknown type: " + path);
            }
        }
    }

    private FileType getFileType(String fileName) {
        if (fileName.endsWith(".jhist")) {
            return FileType.JOB_HISTORY_FILE;
        }
        if (fileName.endsWith("_conf.xml")) {
            return FileType.JOB_CONF_FILE;
        }
        return FileType.UNKNOWN;
    }

    public static class JobFiles {
        private final String jobId;
        private Path jobHistoryFilePath;
        private Path jobConfFilePath;

        public JobFiles(String jobId) {
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        public Path getJobHistoryFilePath() {
            return this.jobHistoryFilePath;
        }

        public void setJobHistoryFilePath(Path jobHistoryFilePath) {
            this.jobHistoryFilePath = jobHistoryFilePath;
        }

        public Path getJobConfFilePath() {
            return this.jobConfFilePath;
        }

        public void setJobConfFilePath(Path jobConfFilePath) {
            this.jobConfFilePath = jobConfFilePath;
        }

        public int hashCode() {
            return this.jobId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobFiles other = (JobFiles)obj;
            return this.jobId.equals(other.jobId);
        }
    }

    private static enum FileType {
        JOB_HISTORY_FILE,
        JOB_CONF_FILE,
        UNKNOWN;

    }
}

