/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.caches;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.AuthorizationTokenType;
import com.microsoft.azure.cosmosdb.rx.internal.ClearingSessionContainerClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicyFactory;
import com.microsoft.azure.cosmosdb.rx.internal.ObservableHelper;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxStoreModel;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Single;

public class RxClientCollectionCache
extends RxCollectionCache {
    private RxStoreModel storeModel;
    private final IAuthorizationTokenProvider tokenProvider;
    private final IRetryPolicyFactory retryPolicy;
    private final ISessionContainer sessionContainer;

    public RxClientCollectionCache(ISessionContainer sessionContainer, RxStoreModel storeModel, IAuthorizationTokenProvider tokenProvider, IRetryPolicyFactory retryPolicy) {
        this.storeModel = storeModel;
        this.tokenProvider = tokenProvider;
        this.retryPolicy = retryPolicy;
        this.sessionContainer = sessionContainer;
    }

    @Override
    protected Single<DocumentCollection> getByRidAsync(String collectionRid, Map<String, Object> properties) {
        ClearingSessionContainerClientRetryPolicy retryPolicyInstance = new ClearingSessionContainerClientRetryPolicy(this.sessionContainer, this.retryPolicy.getRequestPolicy());
        return ObservableHelper.inlineIfPossible(() -> this.readCollectionAsync(PathsHelper.generatePath((ResourceType)ResourceType.DocumentCollection, (String)collectionRid, (boolean)false), retryPolicyInstance, properties), retryPolicyInstance);
    }

    @Override
    protected Single<DocumentCollection> getByNameAsync(String resourceAddress, Map<String, Object> properties) {
        ClearingSessionContainerClientRetryPolicy retryPolicyInstance = new ClearingSessionContainerClientRetryPolicy(this.sessionContainer, this.retryPolicy.getRequestPolicy());
        return ObservableHelper.inlineIfPossible(() -> this.readCollectionAsync(resourceAddress, retryPolicyInstance, properties), retryPolicyInstance);
    }

    private Single<DocumentCollection> readCollectionAsync(String collectionLink, IDocumentClientRetryPolicy retryPolicyInstance, Map<String, Object> properties) {
        String path = Utils.joinPath((String)collectionLink, null);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.DocumentCollection, (String)path, new HashMap());
        request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        String resourceName = request.getResourceAddress();
        String authorizationToken = this.tokenProvider.getUserAuthorizationToken(resourceName, request.getResourceType(), "GET", request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey, properties);
        try {
            authorizationToken = URLEncoder.encode(authorizationToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return Single.error((Throwable)new IllegalStateException("Failed to encode authtoken.", e));
        }
        request.getHeaders().put("authorization", authorizationToken);
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        Observable<RxDocumentServiceResponse> responseObs = this.storeModel.processMessage(request);
        return responseObs.map(response -> (DocumentCollection)BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, DocumentCollection.class).getResource()).toSingle();
    }
}

