/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.sftp;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.sftp.SFTPFileSystem;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;

public class SFTPContract
extends AbstractFSContract {
    private static final String CONTRACT_XML = "contract/sftp.xml";
    private static final URI TEST_URI = URI.create("sftp://user:password@localhost");
    private final String testDataDir = new FileSystemTestHelper().getTestRootDir();
    private final Configuration conf;
    private SshServer sshd;

    public SFTPContract(Configuration conf) {
        super(conf);
        this.addConfResource(CONTRACT_XML);
        this.conf = conf;
    }

    @Override
    public void init() throws IOException {
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(0);
        this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        ArrayList<UserAuthPasswordFactory> userAuthFactories = new ArrayList<UserAuthPasswordFactory>();
        userAuthFactories.add(new UserAuthPasswordFactory());
        this.sshd.setUserAuthFactories(userAuthFactories);
        this.sshd.setPasswordAuthenticator((username, password, session) -> username.equals("user") && password.equals("password"));
        this.sshd.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        this.sshd.start();
        int port = this.sshd.getPort();
        this.conf.setClass("fs.sftp.impl", SFTPFileSystem.class, FileSystem.class);
        this.conf.setInt("fs.sftp.host.port", port);
        this.conf.setBoolean("fs.sftp.impl.disable.cache", true);
    }

    @Override
    public void teardown() throws IOException {
        if (this.sshd != null) {
            this.sshd.stop();
        }
    }

    @Override
    public FileSystem getTestFileSystem() throws IOException {
        return FileSystem.get((URI)TEST_URI, (Configuration)this.conf);
    }

    @Override
    public String getScheme() {
        return "sftp";
    }

    @Override
    public Path getTestPath() {
        try {
            FileSystem fs = FileSystem.get((URI)URI.create("sftp://user:password@localhost"), (Configuration)this.conf);
            return fs.makeQualified(new Path(this.testDataDir));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

