/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.FutureIO;
import org.junit.Test;

public abstract class AbstractContractOpenTest
extends AbstractFSContractTestBase {
    private FSDataInputStream instream;

    @Override
    protected Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setInt("io.file.buffer.size", 4096);
        return conf;
    }

    @Override
    public void teardown() throws Exception {
        IOUtils.closeStream((Closeable)this.instream);
        this.instream = null;
        super.teardown();
    }

    @Test
    public void testOpenReadZeroByteFile() throws Throwable {
        this.describe("create & read a 0 byte file");
        Path path = this.path("zero.txt");
        ContractTestUtils.touch(this.getFileSystem(), path);
        this.instream = this.getFileSystem().open(path);
        AbstractContractOpenTest.assertEquals((long)0L, (long)this.instream.getPos());
        this.assertMinusOne("initial byte read", this.instream.read());
    }

    @Test
    public void testFsIsEncrypted() throws Exception {
        this.describe("create an empty file and call FileStatus.isEncrypted()");
        Path path = this.path("file");
        ContractTestUtils.createFile(this.getFileSystem(), path, false, new byte[0]);
        FileStatus stat = this.getFileSystem().getFileStatus(path);
        AbstractContractOpenTest.assertEquals((String)("Result wrong for for isEncrypted() in " + stat), (Object)this.areZeroByteFilesEncrypted(), (Object)stat.isEncrypted());
    }

    protected boolean areZeroByteFilesEncrypted() {
        return false;
    }

    @Test
    public void testOpenReadDir() throws Throwable {
        this.describe("create & read a directory");
        Path path = this.path("zero.dir");
        this.mkdirs(path);
        try {
            this.instream = this.getFileSystem().open(path);
            AbstractContractOpenTest.fail((String)"A directory has been opened for reading");
        }
        catch (FileNotFoundException e) {
            this.handleExpectedException(e);
        }
        catch (IOException e) {
            this.handleRelaxedException("opening a directory for reading", "FileNotFoundException", e);
        }
    }

    @Test
    public void testOpenReadDirWithChild() throws Throwable {
        this.describe("create & read a directory which has a child");
        Path path = this.path("zero.dir");
        this.mkdirs(path);
        Path path2 = new Path(path, "child");
        this.mkdirs(path2);
        try {
            this.instream = this.getFileSystem().open(path);
            AbstractContractOpenTest.fail((String)"A directory has been opened for reading");
        }
        catch (FileNotFoundException e) {
            this.handleExpectedException(e);
        }
        catch (IOException e) {
            this.handleRelaxedException("opening a directory for reading", "FileNotFoundException", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenFileTwice() throws Throwable {
        this.describe("verify that two opened file streams are independent");
        Path path = this.path("testopenfiletwice.txt");
        byte[] block = ContractTestUtils.dataset(1024, 0, 255);
        ContractTestUtils.createFile(this.getFileSystem(), path, true, block);
        FSDataInputStream instream1 = this.getFileSystem().open(path);
        FSDataInputStream instream2 = null;
        try {
            int c = instream1.read();
            AbstractContractOpenTest.assertEquals((long)0L, (long)c);
            instream2 = this.getFileSystem().open(path);
            AbstractContractOpenTest.assertEquals((String)"first read of instream 2", (long)0L, (long)instream2.read());
            AbstractContractOpenTest.assertEquals((String)"second read of instream 1", (long)1L, (long)instream1.read());
            instream1.close();
            AbstractContractOpenTest.assertEquals((String)"second read of instream 2", (long)1L, (long)instream2.read());
            instream1.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeStream((Closeable)instream1);
            IOUtils.closeStream(instream2);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)instream1);
        IOUtils.closeStream((Closeable)instream2);
    }

    @Test
    public void testSequentialRead() throws Throwable {
        this.describe("verify that sequential read() operations return values");
        Path path = this.path("testsequentialread.txt");
        int len = 4;
        int base = 64;
        byte[] block = ContractTestUtils.dataset(len, base, base + len);
        ContractTestUtils.createFile(this.getFileSystem(), path, true, block);
        this.instream = this.getFileSystem().open(path);
        AbstractContractOpenTest.assertEquals((long)base, (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)(base + 1), (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)(base + 2), (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)(base + 3), (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)-1L, (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)-1L, (long)this.instream.read());
        this.instream.close();
    }

    @Test
    public void testOpenFileReadZeroByte() throws Throwable {
        this.describe("create & read a 0 byte file through the builders");
        Path path = this.path("zero.txt");
        FileSystem fs = this.getFileSystem();
        fs.createFile(path).overwrite(true).build().close();
        try (FSDataInputStream is = (FSDataInputStream)((FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)fs.openFile(path).opt("fs.test.something", true)).opt("fs.test.something2", 3)).opt("fs.test.something3", "3")).build().get();){
            this.assertMinusOne("initial byte read", is.read());
        }
    }

    @Test
    public void testOpenFileUnknownOption() throws Throwable {
        this.describe("calling openFile fails when a 'must()' option is unknown");
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)this.getFileSystem().openFile(this.path("testOpenFileUnknownOption")).opt("fs.test.something", true)).must("fs.test.something", true);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> builder.build());
    }

    @Test
    public void testOpenFileLazyFail() throws Throwable {
        this.describe("openFile fails on a missing file in the get() and not before");
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)this.getFileSystem().openFile(this.path("testOpenFileLazyFail")).opt("fs.test.something", true);
        LambdaTestUtils.interceptFuture(FileNotFoundException.class, "", builder.build());
    }

    @Test
    public void testOpenFileFailExceptionally() throws Throwable {
        this.describe("openFile missing file chains into exceptionally()");
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)this.getFileSystem().openFile(this.path("testOpenFileFailExceptionally")).opt("fs.test.something", true);
        AbstractContractOpenTest.assertNull((String)"exceptional uprating", ((CompletableFuture)builder.build().exceptionally(ex -> null)).get());
    }

    @Test
    public void testAwaitFutureFailToFNFE() throws Throwable {
        this.describe("Verify that FutureIOSupport.awaitFuture extracts IOExceptions");
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)this.getFileSystem().openFile(this.path("testAwaitFutureFailToFNFE")).opt("fs.test.something", true);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> (FSDataInputStream)FutureIO.awaitFuture((Future)builder.build()));
    }

    @Test
    public void testAwaitFutureTimeoutFailToFNFE() throws Throwable {
        this.describe("Verify that FutureIOSupport.awaitFuture with a timeout works");
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)this.getFileSystem().openFile(this.path("testAwaitFutureFailToFNFE")).opt("fs.test.something", true);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> (FSDataInputStream)FutureIO.awaitFuture((Future)builder.build(), (long)10L, (TimeUnit)TimeUnit.DAYS));
    }

    @Test
    public void testOpenFileExceptionallyTranslating() throws Throwable {
        this.describe("openFile missing file chains into exceptionally()");
        CompletableFuture f = this.getFileSystem().openFile(this.path("testOpenFileExceptionallyTranslating")).build();
        LambdaTestUtils.interceptFuture(RuntimeException.class, "exceptionally", f.exceptionally(ex -> {
            throw new RuntimeException("exceptionally", (Throwable)ex);
        }));
    }

    @Test
    public void testChainedFailureAwaitFuture() throws Throwable {
        this.describe("await Future handles chained failures");
        CompletableFuture f = this.getFileSystem().openFile(this.path("testChainedFailureAwaitFuture")).withFileStatus(null).build();
        LambdaTestUtils.intercept(RuntimeException.class, "exceptionally", () -> (FSDataInputStream)FutureIO.awaitFuture((Future)((Object)f.exceptionally(ex -> {
            throw new RuntimeException("exceptionally", (Throwable)ex);
        }))));
    }

    @Test
    public void testOpenFileApplyRead() throws Throwable {
        this.describe("use the apply sequence to read a whole file");
        Path path = this.path("testOpenFileApplyRead");
        FileSystem fs = this.getFileSystem();
        int len = 4096;
        ContractTestUtils.createFile(fs, path, true, ContractTestUtils.dataset(len, 64, 128));
        FileStatus st = fs.getFileStatus(path);
        CompletionStage readAllBytes = fs.openFile(path).withFileStatus(st).build().thenApply(ContractTestUtils::readStream);
        AbstractContractOpenTest.assertEquals((String)"Wrong number of bytes read value", (long)len, (long)((Long)((CompletableFuture)readAllBytes).get()));
        FileStatus st2 = new FileStatus((long)len, false, (int)st.getReplication(), st.getBlockSize(), st.getModificationTime(), st.getAccessTime(), st.getPermission(), st.getOwner(), st.getGroup(), new Path("gopher:///localhost:/" + path.getName()));
        AbstractContractOpenTest.assertEquals((String)"Wrong number of bytes read value", (long)len, (long)((Long)((CompletableFuture)fs.openFile(path).withFileStatus(st2).build().thenApply(ContractTestUtils::readStream)).get()));
    }

    @Test
    public void testOpenFileApplyAsyncRead() throws Throwable {
        this.describe("verify that async accept callbacks are evaluated");
        Path path = this.path("testOpenFileApplyAsyncRead");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.createFile(fs, path, true, ContractTestUtils.dataset(4, 64, 128));
        CompletableFuture future = fs.openFile(path).build();
        AtomicBoolean accepted = new AtomicBoolean(false);
        ((FSDataInputStream)((CompletableFuture)future.thenApply(stream -> {
            accepted.set(true);
            return stream;
        })).get()).close();
        AbstractContractOpenTest.assertTrue((String)"async accept operation not invoked", (boolean)accepted.get());
    }

    @Test
    public void testOpenFileNullStatusButFileLength() throws Throwable {
        this.describe("use openFile() with a null status and expect the status to be ignored. block size, fadvise and length are passed in as opt() options");
        Path path = this.path("testOpenFileNullStatus");
        FileSystem fs = this.getFileSystem();
        int len = 4;
        byte[] result = new byte[len];
        byte[] dataset = ContractTestUtils.dataset(len, 64, 128);
        ContractTestUtils.createFile(fs, path, true, dataset);
        CompletableFuture future = ((FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)fs.openFile(path).withFileStatus(null).opt("fs.option.openfile.read.policy", "unknown, sequential, random")).opt("fs.option.openfile.buffer.size", 32768)).opt("fs.option.openfile.length", len)).build();
        try (FSDataInputStream in = (FSDataInputStream)future.get();){
            in.readFully(result);
        }
        ContractTestUtils.compareByteArrays(dataset, result, len);
    }
}

