/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.store;

import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.sharedcachemanager.AppChecker;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SharedCacheResourceReference;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class SCMStore
extends CompositeService {
    protected AppChecker appChecker;

    protected SCMStore(String name) {
        super(name);
    }

    @VisibleForTesting
    SCMStore(String name, AppChecker appChecker) {
        super(name);
        this.appChecker = appChecker;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (this.appChecker == null) {
            this.appChecker = SCMStore.createAppCheckerService(conf);
        }
        this.addService((Service)this.appChecker);
        super.serviceInit(conf);
    }

    @InterfaceAudience.Private
    public abstract String addResource(String var1, String var2);

    @InterfaceAudience.Private
    public abstract boolean removeResource(String var1);

    @InterfaceAudience.Private
    public abstract String addResourceReference(String var1, SharedCacheResourceReference var2);

    @InterfaceAudience.Private
    public abstract Collection<SharedCacheResourceReference> getResourceReferences(String var1);

    @InterfaceAudience.Private
    public abstract boolean removeResourceReference(String var1, SharedCacheResourceReference var2, boolean var3);

    @InterfaceAudience.Private
    public abstract void removeResourceReferences(String var1, Collection<SharedCacheResourceReference> var2, boolean var3);

    @InterfaceAudience.Private
    public void cleanResourceReferences(String key) throws YarnException {
        Collection<SharedCacheResourceReference> refs = this.getResourceReferences(key);
        if (!refs.isEmpty()) {
            HashSet<SharedCacheResourceReference> refsToRemove = new HashSet<SharedCacheResourceReference>();
            for (SharedCacheResourceReference r : refs) {
                if (this.appChecker.isApplicationActive(r.getAppId())) continue;
                refsToRemove.add(r);
            }
            if (refsToRemove.size() > 0) {
                this.removeResourceReferences(key, refsToRemove, false);
            }
        }
    }

    @InterfaceAudience.Private
    public abstract boolean isResourceEvictable(String var1, FileStatus var2);

    @InterfaceAudience.Private
    public static AppChecker createAppCheckerService(Configuration conf) {
        Class<?> defaultCheckerClass;
        try {
            defaultCheckerClass = Class.forName("org.apache.hadoop.yarn.server.sharedcachemanager.RemoteAppChecker");
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Invalid default scm app checker classorg.apache.hadoop.yarn.server.sharedcachemanager.RemoteAppChecker", (Throwable)e);
        }
        AppChecker checker = (AppChecker)((Object)ReflectionUtils.newInstance((Class)conf.getClass("yarn.sharedcache.app-checker.class", defaultCheckerClass, AppChecker.class), (Configuration)conf));
        return checker;
    }
}

