/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timeline.TimelineHealth;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreVendor;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.TimelineCollectionReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStoreTimelineReaderImpl
extends AbstractService
implements TimelineReader {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentStoreTimelineReaderImpl.class);
    private TimelineCollectionReader collectionReader;

    public DocumentStoreTimelineReaderImpl() {
        super(DocumentStoreTimelineReaderImpl.class.getName());
    }

    public void serviceInit(Configuration conf) throws Exception {
        DocumentStoreVendor storeType = DocumentStoreUtils.getStoreVendor(conf);
        LOG.info("Initializing Document Store Reader for : " + (Object)((Object)storeType));
        this.collectionReader = new TimelineCollectionReader(conf);
    }

    public void serviceStop() throws Exception {
        super.serviceStop();
        LOG.info("Stopping Document Timeline Store reader...");
        this.collectionReader.close();
    }

    public TimelineEntity getEntity(TimelineReaderContext context, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        switch (TimelineEntityType.valueOf((String)context.getEntityType())) {
            case YARN_FLOW_ACTIVITY: 
            case YARN_FLOW_RUN: {
                TimelineEntityDocument timelineEntityDoc = this.collectionReader.readDocument(context);
                return DocumentStoreUtils.createEntityToBeReturned(timelineEntityDoc, dataToRetrieve.getConfsToRetrieve(), dataToRetrieve.getMetricsToRetrieve());
            }
        }
        TimelineEntityDocument timelineEntityDoc = this.collectionReader.readDocument(context);
        return DocumentStoreUtils.createEntityToBeReturned(timelineEntityDoc, dataToRetrieve);
    }

    public Set<TimelineEntity> getEntities(TimelineReaderContext context, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        List<TimelineEntityDocument> entityDocs = this.collectionReader.readDocuments(context, filters.getLimit());
        return this.applyFilters(filters, dataToRetrieve, entityDocs);
    }

    public Set<String> getEntityTypes(TimelineReaderContext context) {
        return this.collectionReader.fetchEntityTypes(context);
    }

    public TimelineHealth getHealthStatus() {
        if (this.collectionReader != null) {
            return new TimelineHealth(TimelineHealth.TimelineHealthStatus.RUNNING, "");
        }
        return new TimelineHealth(TimelineHealth.TimelineHealthStatus.READER_CONNECTION_FAILURE, "Timeline store reader not initialized.");
    }

    private Set<TimelineEntity> applyFilters(TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve, List<TimelineEntityDocument> entityDocs) throws IOException {
        HashSet<TimelineEntity> timelineEntities = new HashSet<TimelineEntity>();
        for (TimelineEntityDocument entityDoc : entityDocs) {
            TimelineEntity timelineEntity = entityDoc.fetchTimelineEntity();
            if (DocumentStoreUtils.isFilterNotMatching(filters, timelineEntity)) continue;
            TimelineEntity entityToBeReturned = DocumentStoreUtils.createEntityToBeReturned(entityDoc, dataToRetrieve);
            timelineEntities.add(entityToBeReturned);
        }
        return timelineEntities;
    }
}

