/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.impl.InternalConstants;
import org.apache.hadoop.util.Progressable;

public class CreateFileBuilder
extends FSDataOutputStreamBuilder<FSDataOutputStream, CreateFileBuilder> {
    public static final EnumSet<CreateFlag> CREATE_OVERWRITE_FLAGS = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
    public static final EnumSet<CreateFlag> CREATE_NO_OVERWRITE_FLAGS = EnumSet.of(CreateFlag.CREATE);
    public static final CreateFileOptions OPTIONS_CREATE_FILE_OVERWRITE = new CreateFileOptions(CREATE_OVERWRITE_FLAGS, true, false, null);
    public static final CreateFileOptions OPTIONS_CREATE_FILE_NO_OVERWRITE = new CreateFileOptions(CREATE_NO_OVERWRITE_FLAGS, true, false, null);
    private final CreateFileBuilderCallbacks callbacks;

    public CreateFileBuilder(@Nonnull FileSystem fileSystem, @Nonnull Path path, @Nonnull CreateFileBuilderCallbacks callbacks) {
        super(fileSystem, path);
        this.callbacks = callbacks;
    }

    public CreateFileBuilder getThisBuilder() {
        return this;
    }

    public FSDataOutputStream build() throws IOException {
        Path path = this.getPath();
        Configuration options = this.getOptions();
        HashMap<String, String> headers = new HashMap<String, String>();
        Set mandatoryKeys = this.getMandatoryKeys();
        HashSet keysToValidate = new HashSet();
        String headerPrefix = "fs.s3a.create.header.";
        int prefixLen = headerPrefix.length();
        mandatoryKeys.stream().forEach(key -> {
            if (key.startsWith(headerPrefix) && key.length() > prefixLen) {
                headers.put(key.substring(prefixLen), options.get(key));
            } else {
                keysToValidate.add(key);
            }
        });
        CreateFileBuilder.rejectUnknownMandatoryKeys(keysToValidate, InternalConstants.CREATE_FILE_KEYS, (String)("for " + path));
        this.getOptionalKeys().stream().filter(key -> key.startsWith(headerPrefix) && key.length() > prefixLen).forEach(key -> headers.put(key.substring(prefixLen), options.get(key)));
        EnumSet<CreateFlag> flags = this.getFlags();
        if (flags.contains(CreateFlag.APPEND)) {
            throw new UnsupportedOperationException("Append is not supported");
        }
        if (!flags.contains(CreateFlag.CREATE) && !flags.contains(CreateFlag.OVERWRITE)) {
            throw new PathIOException(path.toString(), "Must specify either create or overwrite");
        }
        boolean performance = options.getBoolean("fs.s3a.create.performance", false);
        return this.callbacks.createFileFromBuilder(path, this.getProgress(), new CreateFileOptions(flags, this.isRecursive(), performance, headers));
    }

    public CreateFileBuilder withFlags(EnumSet<CreateFlag> flags) {
        if (flags.contains(CreateFlag.CREATE)) {
            this.create();
        }
        if (flags.contains(CreateFlag.APPEND)) {
            this.append();
        }
        this.overwrite(flags.contains(CreateFlag.OVERWRITE));
        return this;
    }

    public EnumSet<CreateFlag> getFlags() {
        return super.getFlags();
    }

    public static final class CreateFileOptions {
        private final EnumSet<CreateFlag> flags;
        private final boolean recursive;
        private final boolean performance;
        private final Map<String, String> headers;

        public CreateFileOptions(EnumSet<CreateFlag> flags, boolean recursive, boolean performance, Map<String, String> headers) {
            this.flags = flags;
            this.recursive = recursive;
            this.performance = performance;
            this.headers = headers;
        }

        public String toString() {
            return "CreateFileOptions{flags=" + this.flags + ", recursive=" + this.recursive + ", performance=" + this.performance + ", headers=" + this.headers + '}';
        }

        public EnumSet<CreateFlag> getFlags() {
            return this.flags;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public boolean isPerformance() {
            return this.performance;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    public static interface CreateFileBuilderCallbacks {
        public FSDataOutputStream createFileFromBuilder(Path var1, Progressable var2, CreateFileOptions var3) throws IOException;
    }
}

