/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top.window;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindowManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRollingWindowManager {
    Configuration conf;
    RollingWindowManager manager;
    String[] users;
    static final int MIN_2_MS = 60000;
    final int WINDOW_LEN_MS = 60000;
    final int BUCKET_CNT = 10;
    final int N_TOP_USERS = 10;
    final int BUCKET_LEN = 6000;

    @Before
    public void init() {
        this.conf = new Configuration();
        this.conf.setInt("dfs.namenode.top.window.num.buckets", 10);
        this.conf.setInt("dfs.namenode.top.num.users", 10);
        this.manager = new RollingWindowManager(this.conf, 60000);
        this.users = new String[20];
        for (int i = 0; i < this.users.length; ++i) {
            this.users[i] = "user" + i;
        }
    }

    @Test
    public void testTops() {
        int i;
        long time = 69000L;
        for (i = 0; i < this.users.length; ++i) {
            this.manager.recordMetric(time, "open", this.users[i], (long)((i + 1) * 2));
        }
        ++time;
        for (i = 0; i < this.users.length; ++i) {
            this.manager.recordMetric(time, "close", this.users[i], (long)(i + 1));
        }
        RollingWindowManager.TopWindow tops = this.manager.snapshot(++time);
        Assert.assertEquals((String)"Unexpected number of ops", (long)2L, (long)tops.getOps().size());
        for (RollingWindowManager.Op op : tops.getOps()) {
            List topUsers = op.getTopUsers();
            Assert.assertEquals((String)"Unexpected number of users", (long)10L, (long)topUsers.size());
            if (op.getOpType() != "open") continue;
            for (int i2 = 0; i2 < topUsers.size(); ++i2) {
                RollingWindowManager.User user = (RollingWindowManager.User)topUsers.get(i2);
                Assert.assertEquals((String)("Unexpected count for user " + user.getUser()), (long)((this.users.length - i2) * 2), (long)user.getCount());
            }
            Assert.assertEquals((String)"Unexpected total count for op", (long)((2 + this.users.length * 2) * (this.users.length / 2)), (long)op.getTotalCount());
        }
        tops = this.manager.snapshot(time += 59998L);
        Assert.assertEquals((String)"Unexpected number of ops", (long)1L, (long)tops.getOps().size());
        RollingWindowManager.Op op = (RollingWindowManager.Op)tops.getOps().get(0);
        Assert.assertEquals((String)"Should only see close ops", (Object)"close", (Object)op.getOpType());
        List topUsers = op.getTopUsers();
        for (int i3 = 0; i3 < topUsers.size(); ++i3) {
            RollingWindowManager.User user = (RollingWindowManager.User)topUsers.get(i3);
            Assert.assertEquals((String)("Unexpected count for user " + user.getUser()), (long)(this.users.length - i3), (long)user.getCount());
        }
        Assert.assertEquals((String)"Unexpected total count for op", (long)((1 + this.users.length) * (this.users.length / 2)), (long)op.getTotalCount());
    }
}

