/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.Arrays;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.access.Structure1D;

public interface StructureAnyD
extends Structure1D {
    public static int index(int[] structure, int[] reference) {
        int retVal = reference[0];
        int tmpFactor = structure[0];
        int tmpLength = reference.length;
        for (int i = 1; i < tmpLength; ++i) {
            retVal += tmpFactor * reference[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static int index(int[] structure, long[] reference) {
        int retVal = (int)reference[0];
        int tmpFactor = structure[0];
        int tmpLength = reference.length;
        for (int i = 1; i < tmpLength; ++i) {
            retVal = (int)((long)retVal + (long)tmpFactor * reference[i]);
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static long index(long[] structure, long[] reference) {
        long retVal = reference[0];
        long tmpFactor = structure[0];
        int tmpLength = Math.min(structure.length, reference.length);
        for (int i = 1; i < tmpLength; ++i) {
            retVal += tmpFactor * reference[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static void loopMatching(StructureAnyD structureA, StructureAnyD structureB, ReferenceCallback callback) {
        long[] tmpShape = structureA.shape();
        if (!Arrays.equals(tmpShape, structureB.shape())) {
            throw new ProgrammingError("The 2 structures must have the same shape!");
        }
        for (long i = 0L; i < structureA.count(); ++i) {
            callback.call(StructureAnyD.reference(i, tmpShape));
        }
    }

    public static long[] reference(long index, long[] structure) {
        long[] retVal = new long[structure.length];
        long tmpPrev = 1L;
        long tmpNext = 1L;
        for (int s = 0; s < structure.length; ++s) {
            retVal[s] = index % (tmpNext *= structure[s]) / tmpPrev;
            tmpPrev = tmpNext;
        }
        return retVal;
    }

    public static long[] shape(StructureAnyD structure) {
        long tmpSize = structure.count();
        long tmpTotal = structure.count(0);
        int tmpRank = 1;
        while (tmpTotal < tmpSize) {
            tmpTotal *= structure.count(tmpRank);
            ++tmpRank;
        }
        long[] retVal = new long[tmpRank];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = structure.count(i);
        }
        return retVal;
    }

    public static int step(int[] structure, int dimension) {
        int retVal = 1;
        for (int i = 0; i < dimension; ++i) {
            retVal *= AccessUtils.count(structure, i);
        }
        return retVal;
    }

    public static int step(int[] structure, int[] increment) {
        int retVal = 0;
        int tmpFactor = 1;
        int tmpLimit = increment.length;
        for (int i = 1; i < tmpLimit; ++i) {
            retVal += tmpFactor * increment[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static long step(long[] structure, int dimension) {
        long retVal = 1L;
        for (int i = 0; i < dimension; ++i) {
            retVal *= AccessUtils.count(structure, i);
        }
        return retVal;
    }

    public static long step(long[] structure, long[] increment) {
        long retVal = 0L;
        long tmpFactor = 1L;
        int tmpLimit = increment.length;
        for (int i = 1; i < tmpLimit; ++i) {
            retVal += tmpFactor * increment[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    @Override
    default public long count() {
        return AccessUtils.count(this.shape());
    }

    public long count(int var1);

    default public void loopAll(ReferenceCallback callback) {
        long[] tmpShape = this.shape();
        for (long i = 0L; i < this.count(); ++i) {
            callback.call(StructureAnyD.reference(i, tmpShape));
        }
    }

    public long[] shape();

    @FunctionalInterface
    public static interface ReferenceCallback {
        public void call(long[] var1);
    }
}

