/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.MathContext;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public final class BigScalar
extends Number
implements Scalar<BigDecimal>,
NumberContext.Enforceable<BigScalar> {
    public static final Scalar.Factory<BigDecimal> FACTORY = new Scalar.Factory<BigDecimal>(){

        @Override
        public BigDecimal cast(double value) {
            return new BigDecimal(value);
        }

        @Override
        public BigDecimal cast(Number number) {
            return TypeUtils.toBigDecimal(number);
        }

        public BigScalar convert(double value) {
            return BigScalar.valueOf(value);
        }

        public BigScalar convert(Number number) {
            return BigScalar.valueOf(number);
        }

        public BigScalar one() {
            return ONE;
        }

        public BigScalar zero() {
            return ZERO;
        }
    };
    public static final BigScalar ONE = new BigScalar(BigMath.ONE);
    public static final BigScalar ZERO = new BigScalar();
    static final NumberContext CONTEXT = NumberContext.getMath(MathContext.DECIMAL128);
    private final BigDecimal myNumber;

    public static boolean isAbsolute(BigDecimal value) {
        return value.signum() >= 0;
    }

    public static boolean isSmall(double comparedTo, BigDecimal value) {
        return value.signum() == 0 || CONTEXT.isSmall(comparedTo, value.doubleValue());
    }

    public static BigScalar of(BigDecimal value) {
        return new BigScalar(value);
    }

    public static BigScalar valueOf(double value) {
        return new BigScalar(BigDecimal.valueOf(value));
    }

    public static BigScalar valueOf(Number number) {
        if (number != null) {
            if (number instanceof BigScalar) {
                return (BigScalar)number;
            }
            return new BigScalar(TypeUtils.toBigDecimal(number));
        }
        return ZERO;
    }

    private BigScalar() {
        this.myNumber = BigMath.ZERO;
    }

    private BigScalar(BigDecimal number) {
        this.myNumber = number;
    }

    @Override
    public BigScalar add(BigDecimal arg) {
        return new BigScalar(this.myNumber.add(arg));
    }

    @Override
    public BigScalar add(double arg) {
        return this.add(new BigDecimal(arg));
    }

    @Override
    public int compareTo(BigDecimal reference) {
        return this.myNumber.compareTo(reference);
    }

    @Override
    public BigScalar conjugate() {
        return this;
    }

    @Override
    public BigScalar divide(BigDecimal arg) {
        return new BigScalar(this.myNumber.divide(arg, CONTEXT.getMathContext()));
    }

    @Override
    public BigScalar divide(double arg) {
        return this.divide(new BigDecimal(arg));
    }

    @Override
    public double doubleValue() {
        return this.myNumber.doubleValue();
    }

    @Override
    public BigScalar enforce(NumberContext context) {
        return new BigScalar(context.enforce(this.myNumber));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scalar)) {
            return false;
        }
        BigDecimal other = ((Scalar)obj).toBigDecimal();
        return !(this.myNumber == null ? other != null : !this.myNumber.equals(other));
    }

    @Override
    public float floatValue() {
        return this.myNumber.floatValue();
    }

    @Override
    public BigDecimal getNumber() {
        return this.myNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myNumber == null ? 0 : this.myNumber.hashCode());
        return result;
    }

    @Override
    public int intValue() {
        return this.myNumber.intValueExact();
    }

    @Override
    public BigScalar invert() {
        return ONE.divide(this.myNumber);
    }

    @Override
    public boolean isAbsolute() {
        return BigScalar.isAbsolute(this.myNumber);
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return CONTEXT.isSmall(comparedTo, this.doubleValue());
    }

    @Override
    public long longValue() {
        return this.myNumber.longValueExact();
    }

    @Override
    public BigScalar multiply(BigDecimal arg) {
        return new BigScalar(this.myNumber.multiply(arg));
    }

    @Override
    public BigScalar multiply(double arg) {
        return this.multiply(new BigDecimal(arg));
    }

    @Override
    public BigScalar negate() {
        return new BigScalar(this.myNumber.negate());
    }

    @Override
    public double norm() {
        return PrimitiveFunction.ABS.invoke(this.myNumber.doubleValue());
    }

    @Override
    public BigScalar signum() {
        return new BigScalar(BigFunction.SIGNUM.invoke(this.myNumber));
    }

    @Override
    public BigScalar subtract(BigDecimal arg) {
        return new BigScalar(this.myNumber.subtract(arg));
    }

    @Override
    public BigScalar subtract(double arg) {
        return this.subtract(new BigDecimal(arg));
    }

    @Override
    public BigDecimal toBigDecimal() {
        return this.myNumber;
    }

    public String toString() {
        return this.myNumber.toString();
    }

    @Override
    public String toString(NumberContext context) {
        return context.enforce(this.myNumber).toString();
    }
}

