/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.tiering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;

public class TieredStore<K, V>
implements Store<K, V> {
    private final AtomicReference<CachingTier<K, V>> cachingTierRef;
    private final CachingTier<K, V> noopCachingTier;
    private final CachingTier<K, V> realCachingTier;
    private final AuthoritativeTier<K, V> authoritativeTier;

    public TieredStore(CachingTier<K, V> cachingTier, AuthoritativeTier<K, V> authoritativeTier) {
        this.cachingTierRef = new AtomicReference<CachingTier<K, CachingTier<K, V>>>(cachingTier);
        this.authoritativeTier = authoritativeTier;
        this.realCachingTier = cachingTier;
        this.noopCachingTier = new NoopCachingTier<K, V>(authoritativeTier);
        this.realCachingTier.setInvalidationListener(this.authoritativeTier::flush);
        this.authoritativeTier.setInvalidationValve(new AuthoritativeTier.InvalidationValve(){

            @Override
            public void invalidateAll() throws StoreAccessException {
                TieredStore.this.invalidateAllInternal();
            }

            @Override
            public void invalidateAllWithHash(long hash) throws StoreAccessException {
                TieredStore.this.cachingTier().invalidateAllWithHash(hash);
            }
        });
    }

    @Override
    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        try {
            return this.cachingTier().getOrComputeIfAbsent(key, keyParam -> {
                try {
                    return this.authoritativeTier.getAndFault(keyParam);
                }
                catch (StoreAccessException cae) {
                    throw new StorePassThroughException(cae);
                }
            });
        }
        catch (StoreAccessException ce) {
            return this.handleStoreAccessException(ce);
        }
    }

    @Override
    public boolean containsKey(K key) throws StoreAccessException {
        return this.authoritativeTier.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        try {
            Store.PutStatus putStatus = this.authoritativeTier.put(key, value);
            return putStatus;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Store.ValueHolder<V> getAndPut(K key, V value) throws StoreAccessException {
        try {
            Store.ValueHolder<V> valueHolder = this.authoritativeTier.getAndPut(key, value);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Store.ValueHolder<V> putIfAbsent(K key, V value, Consumer<Boolean> put) throws StoreAccessException {
        try {
            Store.ValueHolder<V> valueHolder = this.authoritativeTier.putIfAbsent(key, value, put);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    @Override
    public boolean remove(K key) throws StoreAccessException {
        try {
            boolean bl = this.authoritativeTier.remove(key);
            return bl;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    @Override
    public Store.ValueHolder<V> getAndRemove(K key) throws StoreAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.getAndRemove(key);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        try {
            Store.RemoveStatus removeStatus = this.authoritativeTier.remove(key, value);
            return removeStatus;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        try {
            Store.ValueHolder<V> valueHolder = this.authoritativeTier.replace(key, value);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        try {
            Store.ReplaceStatus replaceStatus = this.authoritativeTier.replace(key, oldValue, newValue);
            return replaceStatus;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    @Override
    public void clear() throws StoreAccessException {
        this.swapCachingTiers();
        try {
            this.authoritativeTier.clear();
        }
        finally {
            try {
                this.realCachingTier.clear();
            }
            finally {
                this.swapBackCachingTiers();
            }
        }
    }

    private void invalidateAllInternal() throws StoreAccessException {
        this.swapCachingTiers();
        try {
            this.realCachingTier.invalidateAll();
        }
        finally {
            this.swapBackCachingTiers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapCachingTiers() {
        boolean interrupted = false;
        while (!this.cachingTierRef.compareAndSet(this.realCachingTier, this.noopCachingTier)) {
            CachingTier<K, V> cachingTier = this.noopCachingTier;
            synchronized (cachingTier) {
                if (this.cachingTierRef.get() == this.noopCachingTier) {
                    try {
                        this.noopCachingTier.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapBackCachingTiers() {
        if (!this.cachingTierRef.compareAndSet(this.noopCachingTier, this.realCachingTier)) {
            throw new AssertionError((Object)"Something bad happened");
        }
        CachingTier<K, V> cachingTier = this.noopCachingTier;
        synchronized (cachingTier) {
            this.noopCachingTier.notify();
        }
    }

    @Override
    public StoreEventSource<K, V> getStoreEventSource() {
        return this.authoritativeTier.getStoreEventSource();
    }

    @Override
    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        final Store.Iterator authoritativeIterator = this.authoritativeTier.iterator();
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private StoreAccessException prefetchFailure;
            private Cache.Entry<K, Store.ValueHolder<V>> prefetched;
            {
                try {
                    this.prefetched = this.advance();
                }
                catch (StoreAccessException sae) {
                    this.prefetchFailure = sae;
                }
            }

            @Override
            public boolean hasNext() {
                return this.prefetched != null || this.prefetchFailure != null;
            }

            @Override
            public Cache.Entry<K, Store.ValueHolder<V>> next() throws StoreAccessException {
                StoreAccessException nextFailure = this.prefetchFailure;
                Cache.Entry next = this.prefetched;
                try {
                    this.prefetchFailure = null;
                    this.prefetched = this.advance();
                }
                catch (StoreAccessException sae) {
                    this.prefetchFailure = sae;
                    this.prefetched = null;
                }
                if (nextFailure == null) {
                    if (next == null) {
                        throw new NoSuchElementException();
                    }
                    return next;
                }
                throw nextFailure;
            }

            private Cache.Entry<K, Store.ValueHolder<V>> advance() throws StoreAccessException {
                while (authoritativeIterator.hasNext()) {
                    Cache.Entry next = (Cache.Entry)authoritativeIterator.next();
                    final Object authKey = next.getKey();
                    final Store.ValueHolder checked = TieredStore.this.cachingTier().getOrDefault(authKey, key -> (Store.ValueHolder)next.getValue());
                    if (checked == null) continue;
                    return new Cache.Entry<K, Store.ValueHolder<V>>(){

                        @Override
                        public K getKey() {
                            return authKey;
                        }

                        @Override
                        public Store.ValueHolder<V> getValue() {
                            return checked;
                        }
                    };
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Store.ValueHolder<V> getAndCompute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        try {
            Store.ValueHolder<? extends V> valueHolder = this.authoritativeTier.getAndCompute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)mappingFunction);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Store.ValueHolder<V> computeAndGet(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter) throws StoreAccessException {
        try {
            Store.ValueHolder<? extends V> valueHolder = this.authoritativeTier.computeAndGet((K)key, (BiFunction<? super K, ? extends V, ? extends V>)mappingFunction, replaceEqual, () -> false);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    @Override
    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        try {
            return this.cachingTier().getOrComputeIfAbsent(key, keyParam -> {
                try {
                    return this.authoritativeTier.computeIfAbsentAndFault(keyParam, mappingFunction);
                }
                catch (StoreAccessException cae) {
                    throw new StorePassThroughException(cae);
                }
            });
        }
        catch (StoreAccessException ce) {
            return this.handleStoreAccessException(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction, replaceEqual);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkComputeIfAbsent(keys, mappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.addAll(this.realCachingTier.getConfigurationChangeListeners());
        configurationChangeListenerList.addAll(this.authoritativeTier.getConfigurationChangeListeners());
        return configurationChangeListenerList;
    }

    private CachingTier<K, V> cachingTier() {
        return this.cachingTierRef.get();
    }

    private Store.ValueHolder<V> handleStoreAccessException(StoreAccessException ce) throws StoreAccessException {
        Throwable cause = ce.getCause();
        if (cause instanceof StorePassThroughException) {
            throw (StoreAccessException)cause.getCause();
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException("Unexpected checked exception wrapped in StoreAccessException", cause);
    }

    private static class NoopCachingTier<K, V>
    implements CachingTier<K, V> {
        private final AuthoritativeTier<K, V> authoritativeTier;

        public NoopCachingTier(AuthoritativeTier<K, V> authoritativeTier) {
            this.authoritativeTier = authoritativeTier;
        }

        @Override
        public Store.ValueHolder<V> getOrComputeIfAbsent(K key, Function<K, Store.ValueHolder<V>> source) {
            Store.ValueHolder<V> apply = source.apply(key);
            this.authoritativeTier.flush(key, apply);
            return apply;
        }

        @Override
        public Store.ValueHolder<V> getOrDefault(K key, Function<K, Store.ValueHolder<V>> source) {
            return source.apply(key);
        }

        @Override
        public void invalidate(K key) {
        }

        @Override
        public void invalidateAll() {
        }

        @Override
        public void clear() {
        }

        @Override
        public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        }

        @Override
        public void invalidateAllWithHash(long hash) {
        }

        @Override
        public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
            return null;
        }
    }

    @ServiceDependencies(value={CachingTier.Provider.class, AuthoritativeTier.Provider.class, StatisticsService.class})
    public static class Provider
    implements Store.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private final ConcurrentMap<Store<?, ?>, Map.Entry<CachingTier.Provider, AuthoritativeTier.Provider>> providersMap = new ConcurrentWeakIdentityHashMap();

        @Override
        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            if (resourceTypes.size() == 1) {
                return 0;
            }
            ResourceType<?> authorityResource = this.getAuthorityResource(resourceTypes);
            int authorityRank = 0;
            Collection<AuthoritativeTier.Provider> authorityProviders = this.serviceProvider.getServicesOfType(AuthoritativeTier.Provider.class);
            for (AuthoritativeTier.Provider authorityProvider : authorityProviders) {
                int newRank = authorityProvider.rankAuthority(authorityResource, serviceConfigs);
                if (newRank <= authorityRank) continue;
                authorityRank = newRank;
            }
            if (authorityRank == 0) {
                return 0;
            }
            HashSet cachingResources = new HashSet(resourceTypes);
            cachingResources.remove(authorityResource);
            int cachingTierRank = 0;
            Collection<CachingTier.Provider> cachingTierProviders = this.serviceProvider.getServicesOfType(CachingTier.Provider.class);
            for (CachingTier.Provider cachingTierProvider : cachingTierProviders) {
                int newRank = cachingTierProvider.rankCachingTier(cachingResources, serviceConfigs);
                if (newRank <= cachingTierRank) continue;
                cachingTierRank = newRank;
            }
            if (cachingTierRank == 0) {
                return 0;
            }
            return authorityRank + cachingTierRank;
        }

        private ResourceType<?> getAuthorityResource(Set<ResourceType<?>> resourceTypes) {
            ResourceType<?> authorityResource = null;
            for (ResourceType<?> resourceType : resourceTypes) {
                if (authorityResource != null && authorityResource.getTierHeight() <= resourceType.getTierHeight()) continue;
                authorityResource = resourceType;
            }
            return authorityResource;
        }

        @Override
        public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            ArrayList enhancedServiceConfigs = new ArrayList(Arrays.asList(serviceConfigs));
            ResourcePools resourcePools = storeConfig.getResourcePools();
            if (this.rank(resourcePools.getResourceTypeSet(), enhancedServiceConfigs) == 0) {
                throw new IllegalArgumentException("TieredStore.Provider does not support configured resource types " + resourcePools.getResourceTypeSet());
            }
            ResourceType<?> authorityResource = this.getAuthorityResource(resourcePools.getResourceTypeSet());
            AuthoritativeTier.Provider authoritativeTierProvider = this.getAuthoritativeTierProvider(authorityResource, enhancedServiceConfigs);
            HashSet cachingResources = new HashSet(resourcePools.getResourceTypeSet());
            cachingResources.remove(authorityResource);
            CachingTier.Provider cachingTierProvider = this.getCachingTierProvider(cachingResources, enhancedServiceConfigs);
            ServiceConfiguration[] configurations = enhancedServiceConfigs.toArray(new ServiceConfiguration[enhancedServiceConfigs.size()]);
            CachingTier<K, V> cachingTier = cachingTierProvider.createCachingTier(storeConfig, configurations);
            AuthoritativeTier<K, V> authoritativeTier = authoritativeTierProvider.createAuthoritativeTier(storeConfig, configurations);
            TieredStore<K, V> store = new TieredStore<K, V>(cachingTier, authoritativeTier);
            this.serviceProvider.getService(StatisticsService.class).registerWithParent(cachingTier, store);
            this.serviceProvider.getService(StatisticsService.class).registerWithParent(authoritativeTier, store);
            this.registerStore(store, cachingTierProvider, authoritativeTierProvider);
            return store;
        }

        private CachingTier.Provider getCachingTierProvider(Set<ResourceType<?>> cachingResources, List<ServiceConfiguration<?, ?>> enhancedServiceConfigs) {
            CachingTier.Provider cachingTierProvider = null;
            Collection<CachingTier.Provider> cachingTierProviders = this.serviceProvider.getServicesOfType(CachingTier.Provider.class);
            for (CachingTier.Provider provider : cachingTierProviders) {
                if (provider.rankCachingTier(cachingResources, enhancedServiceConfigs) == 0) continue;
                cachingTierProvider = provider;
                break;
            }
            if (cachingTierProvider == null) {
                throw new AssertionError((Object)("No CachingTier.Provider found although ranking found one for " + cachingResources));
            }
            return cachingTierProvider;
        }

        AuthoritativeTier.Provider getAuthoritativeTierProvider(ResourceType<?> authorityResource, List<ServiceConfiguration<?, ?>> enhancedServiceConfigs) {
            AuthoritativeTier.Provider authoritativeTierProvider = null;
            Collection<AuthoritativeTier.Provider> authorityProviders = this.serviceProvider.getServicesOfType(AuthoritativeTier.Provider.class);
            int highestRank = 0;
            for (AuthoritativeTier.Provider provider : authorityProviders) {
                int rank = provider.rankAuthority(authorityResource, enhancedServiceConfigs);
                if (rank == 0 || highestRank >= rank) continue;
                authoritativeTierProvider = provider;
                highestRank = rank;
            }
            if (authoritativeTierProvider == null) {
                throw new AssertionError((Object)("No AuthoritativeTier.Provider found although ranking found one for " + authorityResource));
            }
            return authoritativeTierProvider;
        }

        <K, V> void registerStore(TieredStore<K, V> store, CachingTier.Provider cachingTierProvider, AuthoritativeTier.Provider authoritativeTierProvider) {
            if (this.providersMap.putIfAbsent(store, new AbstractMap.SimpleEntry<CachingTier.Provider, AuthoritativeTier.Provider>(cachingTierProvider, authoritativeTierProvider)) != null) {
                throw new IllegalStateException("Instance of the Store already registered!");
            }
        }

        @Override
        public void releaseStore(Store<?, ?> resource) {
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            if (entry == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            TieredStore tieredStore = (TieredStore)resource;
            tieredStore.authoritativeTier.setInvalidationValve(new AuthoritativeTier.InvalidationValve(){

                @Override
                public void invalidateAll() {
                }

                @Override
                public void invalidateAllWithHash(long hash) {
                }
            });
            ((CachingTier.Provider)entry.getKey()).releaseCachingTier(tieredStore.realCachingTier);
            ((AuthoritativeTier.Provider)entry.getValue()).releaseAuthoritativeTier(tieredStore.authoritativeTier);
        }

        @Override
        public void initStore(Store<?, ?> resource) {
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            if (entry == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            TieredStore tieredStore = (TieredStore)resource;
            ((CachingTier.Provider)entry.getKey()).initCachingTier(tieredStore.realCachingTier);
            ((AuthoritativeTier.Provider)entry.getValue()).initAuthoritativeTier(tieredStore.authoritativeTier);
        }

        @Override
        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        @Override
        public void stop() {
            this.serviceProvider = null;
            this.providersMap.clear();
        }
    }
}

