/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataBlocks {
    private final Configuration configuration = new Configuration();
    private static final int ONE_KB = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(TestDataBlocks.class);

    @Test
    public void testDataBlocksFactory() throws Exception {
        this.testCreateFactory("disk");
        this.testCreateFactory("array");
        this.testCreateFactory("bytebuffer");
    }

    public void testCreateFactory(String nameOfFactory) throws Exception {
        LOG.info("Testing: {}", (Object)nameOfFactory);
        DataBlocks.BlockFactory blockFactory = DataBlocks.createFactory((String)"Dir", (Configuration)this.configuration, (String)nameOfFactory);
        DataBlocks.DataBlock dataBlock = blockFactory.create(0L, 1024, null);
        this.assertWriteBlock(dataBlock);
        this.assertToByteArray(dataBlock);
        this.assertCloseBlock(dataBlock);
    }

    private void assertWriteBlock(DataBlocks.DataBlock dataBlock) throws IOException {
        byte[] oneKbBuff = new byte[1024];
        new Random().nextBytes(oneKbBuff);
        dataBlock.write(oneKbBuff, 0, 1024);
        dataBlock.verifyState(DataBlocks.DataBlock.DestState.Writing);
        Assert.assertTrue((String)"Expected Data block to have data", (boolean)dataBlock.hasData());
        Assert.assertEquals((String)"Mismatch in data size in block", (long)1024L, (long)dataBlock.dataSize());
        Assert.assertFalse((String)"Expected the data block to have no capacity to write 1 byte of data", (boolean)dataBlock.hasCapacity(1L));
    }

    private void assertToByteArray(DataBlocks.DataBlock dataBlock) throws Exception {
        DataBlocks.BlockUploadData blockUploadData = dataBlock.startUpload();
        dataBlock.verifyState(DataBlocks.DataBlock.DestState.Upload);
        byte[] bytesWritten = blockUploadData.toByteArray();
        Assert.assertEquals((String)"Mismatch in byteArray provided by toByteArray() the second time", (Object)bytesWritten, (Object)blockUploadData.toByteArray());
        IOUtils.close((Closeable)blockUploadData);
        LambdaTestUtils.intercept(IllegalStateException.class, "Block is closed", "Expected to throw IllegalStateException.java after closing blockUploadData and trying to call toByteArray()", () -> blockUploadData.toByteArray());
    }

    private void assertCloseBlock(DataBlocks.DataBlock dataBlock) throws IOException {
        dataBlock.close();
        dataBlock.verifyState(DataBlocks.DataBlock.DestState.Closed);
    }
}

