/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestBlockCountersInPendingIBR {
    @Test
    public void testBlockCounters() throws Exception {
        DatanodeStorage storage;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 10800000L);
        conf.setLong("dfs.heartbeat.interval", 1080L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DatanodeProtocolClientSideTranslatorPB spy = InternalDataNodeTestUtils.spyOnBposToNN(cluster.getDataNodes().get(0), cluster.getNameNode());
        DataNode datanode = cluster.getDataNodes().get(0);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spy, (VerificationMode)Mockito.timeout((long)60000L).times(0))).blockReceivedAndDeleted((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageReceivedDeletedBlocks[])ArgumentMatchers.any(StorageReceivedDeletedBlocks[].class));
        BPServiceActor actor = (BPServiceActor)((BPOfferService)datanode.getAllBpOs().get(0)).getBPServiceActors().get(0);
        FsDatasetSpi dataset = datanode.getFSDataset();
        try (FsDatasetSpi.FsVolumeReferences volumes = dataset.getFsVolumeReferences();){
            storage = dataset.getStorage(volumes.get(0).getStorageID());
        }
        ReceivedDeletedBlockInfo rdbi = null;
        rdbi = new ReceivedDeletedBlockInfo(new Block(5678L, 512L, 1000L), ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, null);
        actor.getIbrManager().addRDBI(rdbi, storage);
        rdbi = new ReceivedDeletedBlockInfo(new Block(5679L, 512L, 1000L), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null);
        actor.getIbrManager().addRDBI(rdbi, storage);
        rdbi = new ReceivedDeletedBlockInfo(new Block(5680L, 512L, 1000L), ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null);
        actor.getIbrManager().addRDBI(rdbi, storage);
        this.verifyBlockCounters(datanode, 3L, 1L, 1L, 1L);
        datanode.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(true).build());
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spy, (VerificationMode)Mockito.timeout((long)60000L).times(1))).blockReceivedAndDeleted((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageReceivedDeletedBlocks[])ArgumentMatchers.any(StorageReceivedDeletedBlocks[].class));
        this.verifyBlockCounters(datanode, 0L, 0L, 0L, 0L);
        cluster.shutdown();
    }

    private void verifyBlockCounters(DataNode datanode, long blocksInPendingIBR, long blocksReceivingInPendingIBR, long blocksReceivedInPendingIBR, long blocksDeletedInPendingIBR) {
        MetricsRecordBuilder m = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
        MetricsAsserts.assertGauge((String)"BlocksInPendingIBR", (long)blocksInPendingIBR, (MetricsRecordBuilder)m);
        MetricsAsserts.assertGauge((String)"BlocksReceivingInPendingIBR", (long)blocksReceivingInPendingIBR, (MetricsRecordBuilder)m);
        MetricsAsserts.assertGauge((String)"BlocksReceivedInPendingIBR", (long)blocksReceivedInPendingIBR, (MetricsRecordBuilder)m);
        MetricsAsserts.assertGauge((String)"BlocksDeletedInPendingIBR", (long)blocksDeletedInPendingIBR, (MetricsRecordBuilder)m);
    }
}

