/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AboutBlock
extends HtmlBlock {
    private static final long BYTES_IN_MB = 0x100000L;
    private final Router router;

    @Inject
    AboutBlock(Router router, View.ViewContext ctx) {
        super(ctx);
        this.router = router;
    }

    protected void render(HtmlBlock.Block html) {
        Configuration conf = this.router.getConfig();
        String webAppAddress = WebAppUtils.getRouterWebAppURLWithScheme((Configuration)conf);
        ClusterMetricsInfo metrics = RouterWebServiceUtil.genericForward(webAppAddress, null, ClusterMetricsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/metrics", null, null);
        boolean isEnabled = conf.getBoolean("yarn.federation.enabled", false);
        this.info("Cluster Status")._("Federation Enabled", (Object)isEnabled)._("Applications Submitted", (Object)"N/A")._("Applications Pending", (Object)"N/A")._("Applications Running", (Object)"N/A")._("Applications Failed", (Object)"N/A")._("Applications Killed", (Object)"N/A")._("Applications Completed", (Object)"N/A")._("Containers Allocated", (Object)metrics.getContainersAllocated())._("Containers Reserved", (Object)metrics.getReservedContainers())._("Containers Pending", (Object)metrics.getPendingContainers())._("Available Memory", (Object)StringUtils.byteDesc((long)(metrics.getAvailableMB() * 0x100000L)))._("Allocated Memory", (Object)StringUtils.byteDesc((long)(metrics.getAllocatedMB() * 0x100000L)))._("Reserved Memory", (Object)StringUtils.byteDesc((long)(metrics.getReservedMB() * 0x100000L)))._("Total Memory", (Object)StringUtils.byteDesc((long)(metrics.getTotalMB() * 0x100000L)))._("Available VirtualCores", (Object)metrics.getAvailableVirtualCores())._("Allocated VirtualCores", (Object)metrics.getAllocatedVirtualCores())._("Reserved VirtualCores", (Object)metrics.getReservedVirtualCores())._("Total VirtualCores", (Object)metrics.getTotalVirtualCores())._("Active Nodes", (Object)metrics.getActiveNodes())._("Lost Nodes", (Object)metrics.getLostNodes())._("Available Nodes", (Object)metrics.getDecommissionedNodes())._("Unhealthy Nodes", (Object)metrics.getUnhealthyNodes())._("Rebooted Nodes", (Object)metrics.getRebootedNodes())._("Total Nodes", (Object)metrics.getTotalNodes());
        html._(InfoBlock.class);
    }
}

